/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.xbase.lib.InputOutput;

public class RunServer {
    public static void main(String[] args) throws Exception {
        ServerModule _serverModule = new ServerModule();
        Injector injector = Guice.createInjector((Module[])new Module[]{_serverModule});
        AsynchronousServerSocketChannel _open = AsynchronousServerSocketChannel.open();
        InetSocketAddress _inetSocketAddress = new InetSocketAddress("localhost", 5007);
        AsynchronousServerSocketChannel serverSocket = _open.bind(_inetSocketAddress);
        ExecutorService threadPool = Executors.newCachedThreadPool();
        while (true) {
            InputOutput.println((Object)"started LSP server");
            LanguageServerImpl languageServer = (LanguageServerImpl)injector.getInstance(LanguageServerImpl.class);
            AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
            InputStream in = Channels.newInputStream(socketChannel);
            OutputStream out = Channels.newOutputStream(socketChannel);
            Function<MessageConsumer, MessageConsumer> _function = it -> it;
            Launcher launcher = Launcher.createIoLauncher((Object)languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)threadPool, _function);
            languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            launcher.startListening();
        }
    }
}

