/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.tests;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.LiveExecutionType;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.xtext.lib.setup.ThisOffset;
import org.eclipse.xpect.xtext.lib.setup.XtextStandaloneSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextWorkspaceSetup;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.junit.runner.RunWith;

@RunWith(value=XpectRunner.class)
@XpectImport(value={XtextStandaloneSetup.class, XtextWorkspaceSetup.class})
public class ScopingTest {
    @Inject
    private IQualifiedNameConverter converter;
    @Inject
    private IScopeProvider scopeProvider;

    public IQualifiedNameConverter getConverter() {
        return this.converter;
    }

    public IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void scope(@CommaSeparatedValuesExpectation ICommaSeparatedValuesExpectation expectation, @ThisOffset XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        IScope scope = this.scopeProvider.getScope(arg1.getEObject(), arg1.getCrossEReference());
        expectation.assertEquals((Iterable)new ScopeAllElements(scope), (Predicate)new IsInScope(this.converter, scope));
    }

    protected static class EObjectDescriptionToStringMapper
    implements Function<IEObjectDescription, String> {
        protected EObjectDescriptionToStringMapper() {
        }

        public String apply(IEObjectDescription desc) {
            return desc.getName().toString();
        }
    }

    protected static class IsInScope
    implements Predicate<String> {
        private IQualifiedNameConverter converter;
        private IScope scope;

        public IsInScope(IQualifiedNameConverter converter, IScope scope) {
            this.converter = converter;
            this.scope = scope;
        }

        public boolean apply(String name) {
            QualifiedName qualifiedName = this.converter.toQualifiedName(name);
            IEObjectDescription singleElement = this.scope.getSingleElement(qualifiedName);
            return singleElement != null;
        }
    }

    protected static class ScopeAllElements
    implements Iterable<String> {
        private IScope scope;

        public ScopeAllElements(IScope scope) {
            this.scope = scope;
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.transform(this.scope.getAllElements().iterator(), (Function)new EObjectDescriptionToStringMapper());
        }
    }
}

