/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.diagnosing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.resource.ErrorAwareLinkingService;
import org.eclipse.n4js.scoping.diagnosing.N4JSScopingConsumableMethodsDiagnosis;
import org.eclipse.n4js.scoping.diagnosing.N4JSScopingInstanceOfPrimitivTypeDiagnosis;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;

public class N4JSScopingDiagnostician {
    @Inject
    private N4JSScopingConsumableMethodsDiagnosis consumableMethodsDiagnosis;
    @Inject
    private N4JSScopingInstanceOfPrimitivTypeDiagnosis instanceOfPrimitiveTypeDiagnosis;
    @Inject
    private ErrorAwareLinkingService linkingService;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public DiagnosticMessage getMessageFor(EObject context, EReference reference, INode node) {
        String crossRefAsString = this.linkingService.getCrossRefNodeAsString(context, reference, node);
        if (crossRefAsString != null && !crossRefAsString.equals("")) {
            QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(crossRefAsString);
            return this.diagnose(qualifiedName, context, reference);
        }
        return null;
    }

    private DiagnosticMessage _diagnose(QualifiedName name, ParameterizedPropertyAccessExpression context, EReference reference) {
        Expression _target = context.getTarget();
        if (_target instanceof SuperLiteral) {
            return this.consumableMethodsDiagnosis.diagnose(name, context);
        }
        return null;
    }

    private DiagnosticMessage _diagnose(QualifiedName name, IdentifierRef context, EReference reference) {
        EObject container = context.eContainer();
        EStructuralFeature containingFeature = context.eContainingFeature();
        while (container instanceof ParenExpression) {
            containingFeature = ((ParenExpression)container).eContainmentFeature();
            container = ((ParenExpression)container).eContainer();
        }
        if (container instanceof RelationalExpression && Objects.equal((Object)((RelationalExpression)container).getOp(), (Object)RelationalOperator.INSTANCEOF) && Objects.equal((Object)containingFeature, (Object)N4JSPackage.Literals.RELATIONAL_EXPRESSION__RHS)) {
            return this.instanceOfPrimitiveTypeDiagnosis.diagnose(name, (RelationalExpression)container);
        }
        return null;
    }

    private DiagnosticMessage _diagnose(QualifiedName name, EObject context, EReference reference) {
        return null;
    }

    private DiagnosticMessage diagnose(QualifiedName name, EObject context, EReference reference) {
        if (context instanceof IdentifierRef) {
            return this._diagnose(name, (IdentifierRef)context, reference);
        }
        if (context instanceof ParameterizedPropertyAccessExpression) {
            return this._diagnose(name, (ParameterizedPropertyAccessExpression)context, reference);
        }
        if (context != null) {
            return this._diagnose(name, context, reference);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(name, context, reference).toString());
    }
}

