/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.naming.N4JSQualifiedNameProvider;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.Semver.VersionPart;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeDefs;
import org.eclipse.n4js.utils.ProjectResolveHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public final class ResourceNameComputer {
    private static final boolean MAKE_SIMPLE_DESCRIPTOR = true;
    private static final boolean USE_PROJECT_VERSION = true;
    private static final boolean AS_JS_IDENTIFIER = true;
    @Inject
    private N4JSQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter converter;
    @Inject
    private ProjectResolveHelper projectResolver;

    public String getSimpleTypeName(Type type) {
        String name = type.getName();
        if (name == null || name.isEmpty()) {
            String _plus;
            int _hashCode = type.hashCode();
            name = _plus = "__Anonymous_" + Integer.valueOf(_hashCode);
        }
        return name;
    }

    public String getFullyQualifiedTypeName(Type type) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)type);
        if (rootContainer instanceof TypeDefs) {
            return this.getSimpleTypeName(type);
        }
        QualifiedName moduleFQN = this.qualifiedNameProvider.getFullyQualifiedName(rootContainer);
        boolean _isModulePolyfill = N4TSQualifiedNameProvider.isModulePolyfill((QualifiedName)moduleFQN);
        if (_isModulePolyfill) {
            moduleFQN = moduleFQN.skipFirst(1);
        }
        return this.converter.toString(moduleFQN.append(this.getSimpleTypeName(type)));
    }

    public String getFullyQualifiedTypeName_WITH_LEGACY_SUPPORT(Type type) {
        return this.getFullyQualifiedTypeName(type).replace("/", ".");
    }

    public String getCompleteModuleSpecifier(TModule module) {
        IN4JSProject project = this.resolveProject(module);
        String unitPath = module.getModuleSpecifier();
        return ResourceNameComputer.formatDescriptor(project, unitPath, "-", ".", "/", false, false, true);
    }

    public String generateProjectDescriptor(URI n4jsSourceURI) {
        String _xblockexpression = null;
        IN4JSProject project = this.projectResolver.resolveProject(n4jsSourceURI);
        String unitPath = "";
        _xblockexpression = ResourceNameComputer.formatDescriptor(project, "", "-", ".", "", false, false, false);
        return _xblockexpression;
    }

    public String generateFileDescriptor(Resource resource, String fileExtension) {
        String _xblockexpression = null;
        IN4JSProject project = this.projectResolver.resolveProject(resource);
        String unitPath = this.projectResolver.resolvePackageAndFileName(resource);
        String _formatDescriptor = ResourceNameComputer.formatDescriptor(project, unitPath, "-", ".", "/", false, false, true);
        String _normalizeFileExtension = ResourceNameComputer.normalizeFileExtension(fileExtension);
        _xblockexpression = String.valueOf(_formatDescriptor) + _normalizeFileExtension;
        return _xblockexpression;
    }

    public String generateFileDescriptor(URI n4jsSourceURI, String fileExtension) {
        String _xblockexpression = null;
        IN4JSProject project = this.projectResolver.resolveProject(n4jsSourceURI);
        String unitPath = this.projectResolver.resolvePackageAndFileName(n4jsSourceURI);
        String _formatDescriptor = ResourceNameComputer.formatDescriptor(project, unitPath, "-", ".", "/", false, false, true);
        String _normalizeFileExtension = ResourceNameComputer.normalizeFileExtension(fileExtension);
        _xblockexpression = String.valueOf(_formatDescriptor) + _normalizeFileExtension;
        return _xblockexpression;
    }

    public String generateFileDescriptor(IN4JSProject project, URI n4jsSourceURI, String fileExtension) {
        String _xblockexpression = null;
        String unitPath = this.projectResolver.resolvePackageAndFileName(n4jsSourceURI, project);
        String _formatDescriptor = ResourceNameComputer.formatDescriptor(project, unitPath, "-", ".", "/", false, false, true);
        String _normalizeFileExtension = ResourceNameComputer.normalizeFileExtension(fileExtension);
        _xblockexpression = String.valueOf(_formatDescriptor) + _normalizeFileExtension;
        return _xblockexpression;
    }

    private IN4JSProject resolveProject(TModule module) {
        return this.projectResolver.resolveProject(module.eResource().getURI());
    }

    private static String normalizeFileExtension(String fileExtension) {
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)fileExtension);
        if (_isNullOrEmpty) {
            return "";
        }
        boolean _startsWith = fileExtension.startsWith(".");
        if (_startsWith) {
            return fileExtension;
        }
        return "." + fileExtension;
    }

    private static String formatDescriptor(IN4JSProject project, String unitPath, String sep1, String sep2, String sep3, boolean useProjectVersion, boolean asJsIdentifier, boolean makeSimpleDescriptor) {
        N4JSProjectName projectName = project.getProjectName();
        String path = unitPath;
        if (asJsIdentifier) {
            N4JSProjectName _n4JSProjectName;
            String _validJavascriptIdentifierName = ResourceNameComputer.getValidJavascriptIdentifierName(project.getProjectName().getRawName());
            projectName = _n4JSProjectName = new N4JSProjectName(_validJavascriptIdentifierName);
            path = ResourceNameComputer.getValidUnitPath(unitPath);
        }
        if (makeSimpleDescriptor) {
            return path;
        }
        if (useProjectVersion) {
            String _plus = projectName + sep1;
            String _projectVersionToStringWithoutQualifier = ResourceNameComputer.projectVersionToStringWithoutQualifier(project.getVersion(), sep2);
            String _plus_1 = String.valueOf(_plus) + _projectVersionToStringWithoutQualifier;
            String _plus_2 = String.valueOf(_plus_1) + sep3;
            return String.valueOf(_plus_2) + path;
        }
        String _plus_3 = projectName + sep3;
        return String.valueOf(_plus_3) + path;
    }

    private static String getValidUnitPath(String unitPath) {
        Functions.Function1 _function = it -> ResourceNameComputer.getValidJavascriptIdentifierName(it);
        return IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)unitPath.split("/"))), (Functions.Function1)_function), (CharSequence)"/");
    }

    private static String getValidJavascriptIdentifierName(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            boolean _xifexpression = false;
            _xifexpression = i == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch);
            boolean isValid = _xifexpression;
            if (isValid) {
                sb.append(ch);
            } else {
                sb.append(ResourceNameComputer.toUnicode(ch));
            }
            ++i;
        }
        return sb.toString();
    }

    private static String toUnicode(char character) {
        String _substring = Integer.toHexString(character | 0x10000).substring(1);
        return "_u" + _substring;
    }

    private static String projectVersionToStringWithoutQualifier(VersionNumber declaredVersion, String separatorChar) {
        VersionPart _major = declaredVersion.getMajor();
        String _plus = _major + separatorChar;
        VersionPart _minor = declaredVersion.getMinor();
        String _plus_1 = String.valueOf(_plus) + _minor;
        String _plus_2 = String.valueOf(_plus_1) + separatorChar;
        VersionPart _patch = declaredVersion.getPatch();
        return String.valueOf(_plus_2) + _patch;
    }
}

