/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;

public class NewAttributeAction
extends Action {
    private SchemaElement element;

    public NewAttributeAction() {
        this.setText(PDEUIMessages.SchemaEditor_NewAttribute_label);
        this.setImageDescriptor(PDEPluginImages.DESC_ATTRIBUTE_OBJ);
        this.setToolTipText(PDEUIMessages.SchemaEditor_NewAttribute_tooltip);
    }

    public SchemaElement getElement() {
        return this.element;
    }

    private String getInitialName() {
        return PDELabelUtility.generateName(this.element.getAttributeNames(), PDEUIMessages.SchemaEditor_NewAttribute_initialName, false);
    }

    public void run() {
        String name = this.getInitialName();
        SchemaAttribute att = new SchemaAttribute((ISchemaObject)this.element, name);
        att.setType((ISchemaSimpleType)new SchemaSimpleType(this.element.getSchema(), "string"));
        ISchemaType type = this.element.getType();
        SchemaComplexType complexType = null;
        if (!(type instanceof ISchemaComplexType)) {
            complexType = new SchemaComplexType(this.element.getSchema());
            this.element.setType((ISchemaType)complexType);
        } else {
            complexType = (SchemaComplexType)type;
        }
        complexType.addAttribute((ISchemaAttribute)att);
        if (this.element.hasTranslatableContent()) {
            this.element.setTranslatableProperty(false);
        }
    }

    public void setElement(SchemaElement newElement) {
        this.element = newElement;
    }
}

