/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.project;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.xtext.ui.wizard.DefaultProjectInfo;

public class N4JSProjectInfo
extends DefaultProjectInfo {
    public static final String PROJECT_LOCATION_PROP_NAME = "projectLocation";
    public static final String PROJECT_TYPE_PROP_NAME = "projectType";
    public static final String SELECTED_WORKING_SET_PROP_NAME = "selectedWorkingSet";
    public static final String IMPLEMENTATION_ID_PROP_NAME = "implementationId";
    public static final String IMPLEMENTED_PROJECTS_PROP_NAME = "implementedProjects";
    public static final String TESTED_PROJECT_PROP_NAME = "testedProjects";
    public static final String ADDITIONAL_NORMAL_SOURCE_FOLDER_PROP_NAME = "additionalSourceFolder";
    public static final String PROJECT_DEPENDENCIES_PROP_NAME = "projectDependencies";
    public static final String PROJECT_DEV_DEPENDENCIES_PROP_NAME = "projectDevDependencies";
    public static final String OUTPUT_FOLDER_PROP_NAME = "outputFolder";
    public static final String SOURCE_FOLDERS_PROP_NAME = "sourceFolders";
    public static final String EXTERNAL_SOURCE_FOLDERS_PROP_NAME = "externalSourceFolders";
    public static final String TEST_SOURCE_FOLDERS_PROP_NAME = "testSourceFolders";
    public static final String CREATE_GREETER_FILE_PROP_NAME = "createGreeterFile";
    public static final String VENDOR_ID_PROP_NAME = "vendorId";
    public static final String DEFAULT_VENDOR_ID = "org.eclipse.n4js";
    private IPath projectLocation;
    private ProjectType projectType = ProjectType.LIBRARY;
    private String vendorId = "org.eclipse.n4js";
    private String implementationId;
    private List<String> implementedProjects = Lists.newArrayList();
    private IWorkingSet[] selectedWorkingSets;
    private List<String> testedProjects = new ArrayList<String>();
    private boolean additionalSourceFolder;
    private boolean createGreeterFile;
    private List<String> projectDependencies = new ArrayList<String>();
    private List<String> projectDevDependencies = new ArrayList<String>();
    private String outputFolder;
    private List<String> sourceFolders = new ArrayList<String>();
    private List<String> externalSourceFolders = new ArrayList<String>();
    private List<String> testSourceFolders = new ArrayList<String>();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getProjectTypeForProjectDescription() {
        if (ProjectType.API.equals((Object)this.projectType)) {
            return ProjectType.API.getLiteral();
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, String.valueOf(this.projectType));
    }

    public IPath getProjectLocation() {
        return this.projectLocation;
    }

    public void setProjectLocation(IPath projectLocation) {
        this.projectLocation = projectLocation;
        this.firePropertyChange(PROJECT_LOCATION_PROP_NAME, this.projectLocation, this.projectLocation);
    }

    public ProjectType getProjectType() {
        return this.projectType;
    }

    public void setProjectType(ProjectType projectType) {
        this.projectType = projectType;
        this.firePropertyChange(PROJECT_TYPE_PROP_NAME, this.projectType, this.projectType);
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.selectedWorkingSets;
    }

    public void setSelectedWorkingSets(IWorkingSet[] selectedWorkingSets) {
        this.selectedWorkingSets = selectedWorkingSets;
        this.firePropertyChange(SELECTED_WORKING_SET_PROP_NAME, this.selectedWorkingSets, selectedWorkingSets);
    }

    public String getImplementationId() {
        return this.implementationId;
    }

    public void setImplementationId(String implementationId) {
        this.implementationId = implementationId;
        this.firePropertyChange(IMPLEMENTATION_ID_PROP_NAME, this.implementationId, this.implementationId);
    }

    public List<String> getImplementedProjects() {
        return this.implementedProjects;
    }

    public void setImplementedProjects(List<String> implementedProjects) {
        this.implementedProjects = implementedProjects;
        this.firePropertyChange(IMPLEMENTED_PROJECTS_PROP_NAME, this.implementedProjects, this.implementedProjects);
    }

    public List<String> getTestedProjects() {
        return this.testedProjects;
    }

    public void setTestedProjects(List<String> testedProjects) {
        this.testedProjects = testedProjects;
        this.firePropertyChange(TESTED_PROJECT_PROP_NAME, this.testedProjects, this.testedProjects);
    }

    public boolean getAdditionalSourceFolder() {
        return this.additionalSourceFolder;
    }

    public void setAdditionalSourceFolder(boolean additionalSourceFolder) {
        this.additionalSourceFolder = additionalSourceFolder;
        this.firePropertyChange(ADDITIONAL_NORMAL_SOURCE_FOLDER_PROP_NAME, this.additionalSourceFolder, this.additionalSourceFolder);
    }

    public List<String> getProjectDependencies() {
        return this.projectDependencies;
    }

    public void setProjectDependencies(List<String> projectDependencies) {
        this.projectDependencies = projectDependencies;
        this.firePropertyChange(PROJECT_DEPENDENCIES_PROP_NAME, this.projectDependencies, this.projectDependencies);
    }

    public List<String> getProjectDevDependencies() {
        return this.projectDevDependencies;
    }

    public void setProjectDevDependencies(List<String> projectDevDependencies) {
        this.projectDevDependencies = projectDevDependencies;
        this.firePropertyChange(PROJECT_DEPENDENCIES_PROP_NAME, this.projectDevDependencies, this.projectDevDependencies);
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
        this.firePropertyChange(OUTPUT_FOLDER_PROP_NAME, this.outputFolder, this.outputFolder);
    }

    public List<String> getSourceFolders() {
        return this.sourceFolders;
    }

    public void setSourceFolders(List<String> sourceFolders) {
        this.sourceFolders = sourceFolders;
        this.firePropertyChange(SOURCE_FOLDERS_PROP_NAME, this.sourceFolders, this.sourceFolders);
    }

    public List<String> getExternalSourceFolders() {
        return this.externalSourceFolders;
    }

    public void setExternalSourceFolders(List<String> externalSourceFolders) {
        this.externalSourceFolders = externalSourceFolders;
        this.firePropertyChange(EXTERNAL_SOURCE_FOLDERS_PROP_NAME, this.externalSourceFolders, this.externalSourceFolders);
    }

    public List<String> getTestSourceFolders() {
        return this.testSourceFolders;
    }

    public void setTestSourceFolders(List<String> testSourceFolders) {
        this.testSourceFolders = testSourceFolders;
        this.firePropertyChange(TEST_SOURCE_FOLDERS_PROP_NAME, this.testSourceFolders, this.testSourceFolders);
    }

    public boolean getCreateGreeterFile() {
        return this.createGreeterFile;
    }

    public void setCreateGreeterFile(boolean createTestGreeterFile) {
        this.createGreeterFile = createTestGreeterFile;
        this.firePropertyChange(CREATE_GREETER_FILE_PROP_NAME, this.createGreeterFile, this.createGreeterFile);
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
        this.firePropertyChange(VENDOR_ID_PROP_NAME, this.vendorId, this.vendorId);
    }
}

