/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.n4js.tester.domain.TestStatus;
import org.eclipse.n4js.tester.ui.TesterUiActivator;

class TestViewFilterHelper {
    static final int SHOW_ALL = 0;
    static final int SHOW_FAILURES = 1;
    static final int SHOW_SKIPPED = 2;
    static final String[] LABELS = new String[]{"Show Failures Only", "Show Skipped Tests Only"};
    static final String[] ICON_IDS = new String[]{"failures.gif", "testignored.gif"};
    private final ToggleFilterAction[] actions;
    private final IMenuManager orientationMenu;
    private final TreeViewer testTreeViewer;
    private int filter = 0;

    TestViewFilterHelper(TreeViewer testTreeViewer) {
        this.testTreeViewer = testTreeViewer;
        this.actions = new ToggleFilterAction[LABELS.length];
        this.orientationMenu = new MenuManager("Layout");
        int i = 0;
        while (i < LABELS.length) {
            this.actions[i] = new ToggleFilterAction(i + 1);
            this.orientationMenu.add((IAction)this.actions[i]);
            ++i;
        }
    }

    int getFilter() {
        return this.filter;
    }

    void setFilter(int filter) {
        if (filter == this.filter) {
            return;
        }
        this.filter = filter;
        if (this.testTreeViewer == null) {
            return;
        }
        this.testTreeViewer.refresh();
        this.udpateActions();
    }

    public void udpateActions() {
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].setChecked(this.filter == this.actions[i].actionFilter);
            ++i;
        }
    }

    IAction getFailureAction() {
        return this.actions[0];
    }

    IAction getSkippedAction() {
        return this.actions[1];
    }

    boolean match(TestStatus testStatus) {
        if (testStatus == null) {
            return true;
        }
        if (this.filter == 1) {
            return testStatus == TestStatus.ERROR || testStatus == TestStatus.FAILED;
        }
        if (this.filter == 2) {
            return testStatus == TestStatus.SKIPPED || testStatus == TestStatus.SKIPPED_FIXME || testStatus == TestStatus.SKIPPED_IGNORE || testStatus == TestStatus.SKIPPED_NOT_IMPLEMENTED || testStatus == TestStatus.SKIPPED_PRECONDITION;
        }
        return true;
    }

    private class ToggleFilterAction
    extends Action {
        private final int actionFilter;

        ToggleFilterAction(int filter) {
            super(LABELS[filter - 1], 2);
            this.setImageDescriptor(TesterUiActivator.getImageDescriptor(ICON_IDS[filter - 1]));
            this.actionFilter = filter;
        }

        public void run() {
            if (this.isChecked()) {
                TestViewFilterHelper.this.setFilter(this.actionFilter);
            } else {
                TestViewFilterHelper.this.setFilter(0);
            }
        }
    }
}

