/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.scoping;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xpect.AbstractComponent;
import org.eclipse.xpect.Assignment;
import org.eclipse.xpect.Component;
import org.eclipse.xpect.XjmContribution;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.XpectTest;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xpect.setup.XpectSetupRoot;
import org.eclipse.xpect.util.JvmTypesUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;

public class ComponentUtil {
    private final XpectJavaModel xjm;

    public ComponentUtil(XpectJavaModel xjm) {
        this.xjm = xjm;
    }

    private Set<JvmDeclaredType> getCompatibleContributions(Set<JvmDeclaredType> types) {
        HashSet result = Sets.newHashSet();
        HashSet inactive = Sets.newHashSet();
        Iterable<XjmContribution> contributions = this.xjm.getContributions(XpectSetupComponent.class);
        block0: for (XjmContribution contribution : contributions) {
            JvmDeclaredType jvmClass = contribution.getJvmClass();
            if (contribution.isActive()) {
                Set<JvmType> superTypes = JvmTypesUtil.getSelfAndAllSuperTypes(jvmClass);
                for (JvmType superType : superTypes) {
                    if (!(superType instanceof JvmDeclaredType) || !types.contains(superType)) continue;
                    result.add(jvmClass);
                    continue block0;
                }
                continue;
            }
            inactive.add(jvmClass);
        }
        for (JvmDeclaredType type : types) {
            if (type.isAbstract() || !(type instanceof JvmGenericType) || ((JvmGenericType)type).isInterface() || inactive.contains(type)) continue;
            result.add(type);
        }
        return result;
    }

    private void collectAdders(JvmType type, List<JvmOperation> ops) {
        if (type instanceof JvmDeclaredType && !type.eIsProxy()) {
            for (JvmFeature feat : ((JvmDeclaredType)type).getAllFeatures()) {
                if (!(feat instanceof JvmOperation) || !"add".equals(feat.getSimpleName())) continue;
                ops.add((JvmOperation)feat);
            }
        }
    }

    private Set<JvmDeclaredType> getFirstParameterTypes(List<JvmOperation> ops) {
        HashSet result = Sets.newHashSet();
        for (JvmOperation op : ops) {
            JvmType type;
            JvmTypeReference paramType;
            if (op.getParameters().size() != 1 || (paramType = ((JvmFormalParameter)op.getParameters().get(0)).getParameterType()) == null || paramType.eIsProxy() || !((type = paramType.getType()) instanceof JvmDeclaredType) || type.eIsProxy()) continue;
            result.add((JvmDeclaredType)type);
        }
        return result;
    }

    public Set<JvmDeclaredType> getValidRootTypes() {
        Iterable<XjmContribution> contributions = this.xjm.getContributions(XpectSetupRoot.class);
        ArrayList ops = Lists.newArrayList();
        for (XjmContribution contribution : contributions) {
            if (!contribution.isActive()) continue;
            JvmDeclaredType jvmClass = contribution.getJvmClass();
            this.collectAdders((JvmType)jvmClass, ops);
        }
        Set<JvmDeclaredType> firstParameterTypes = this.getFirstParameterTypes(ops);
        Set<JvmDeclaredType> compatibleContributions = this.getCompatibleContributions(firstParameterTypes);
        return compatibleContributions;
    }

    public Set<JvmDeclaredType> getValidTypes(Assignment assignment) {
        ArrayList ops = Lists.newArrayList();
        JvmOperation operation = assignment.getDeclaredTarget();
        if (operation != null) {
            if (operation.eIsProxy()) {
                return Collections.emptySet();
            }
        } else {
            AbstractComponent container = assignment.getInstance();
            if (container instanceof Component) {
                JvmDeclaredType type = ((Component)container).getComponentClass();
                if (type != null && !type.eIsProxy()) {
                    this.collectAdders((JvmType)type, ops);
                }
                return this.getCompatibleContributions(this.getFirstParameterTypes(ops));
            }
            if (container instanceof XpectTest) {
                return this.getValidRootTypes();
            }
            return Collections.emptySet();
        }
        ops.add(operation);
        return this.getCompatibleContributions(this.getFirstParameterTypes(ops));
    }
}

