/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TSetter;

public class AccessorTuple {
    private final String name;
    private TGetter getter;
    private TSetter setter;
    private TSetter inheritedSetter;
    private TGetter inheritedGetter;
    private final boolean _static;

    public AccessorTuple(String name, boolean _static) {
        this.name = name;
        this._static = _static;
    }

    public boolean isStatic() {
        return this._static;
    }

    public String getName() {
        return this.name;
    }

    public TGetter getGetter() {
        return this.getter;
    }

    public TSetter getSetter() {
        return this.setter;
    }

    public TGetter getInheritedGetter() {
        return this.inheritedGetter;
    }

    public TSetter getInheritedSetter() {
        return this.inheritedSetter;
    }

    public void setGetter(TGetter getter) {
        if (this.getter != null) {
            throw new IllegalStateException();
        }
        this.getter = getter;
        if (getter != null) {
            this.inheritedGetter = null;
        }
    }

    public void setSetter(TSetter setter) {
        if (this.setter != null) {
            throw new IllegalStateException();
        }
        this.setter = setter;
        if (setter != null) {
            this.inheritedSetter = null;
        }
    }

    public void setInheritedGetter(TGetter inhGetter) {
        if (this.getter != null) {
            throw new IllegalStateException();
        }
        this.inheritedGetter = inhGetter;
    }

    public void setInheritedSetter(TSetter inhSetter) {
        if (this.setter != null) {
            throw new IllegalStateException();
        }
        this.inheritedSetter = inhSetter;
    }

    public void replaceGetterByInheretedGetter_caseIncompletAPI(TGetter inhGetter) {
        if (this.getter == null) {
            throw new IllegalStateException();
        }
        if (this.inheritedGetter != null) {
            throw new IllegalStateException();
        }
        if (inhGetter == null) {
            throw new IllegalStateException();
        }
        this.getter = null;
        this.inheritedGetter = inhGetter;
    }

    public void replaceSetterByInheretedSetter_caseIncompletAPI(TSetter inhSetter) {
        if (this.setter == null) {
            throw new IllegalStateException();
        }
        if (this.inheritedSetter != null) {
            throw new IllegalStateException();
        }
        if (inhSetter == null) {
            throw new IllegalStateException();
        }
        this.setter = null;
        this.inheritedSetter = inhSetter;
    }

    public boolean hasPair() {
        return !(this.getter == null && this.inheritedGetter == null || this.setter == null && this.inheritedSetter == null);
    }

    public Iterable<FieldAccessor> ownedOrMixedIn() {
        if (this.getter != null) {
            if (this.setter != null) {
                return Arrays.asList(this.getter, this.setter);
            }
            return Collections.singletonList(this.getter);
        }
        if (this.setter != null) {
            return Collections.singletonList(this.setter);
        }
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder strb = new StringBuilder("Accessors ");
        if (this.isStatic()) {
            strb.append("static ");
        }
        strb.append(this.name);
        strb.append(": ");
        StringBuilder members = new StringBuilder();
        this.append(members, this.getter, "");
        this.append(members, this.setter, "");
        this.append(members, this.inheritedGetter, "*");
        this.append(members, this.inheritedSetter, "*");
        strb.append((CharSequence)members);
        return strb.toString();
    }

    private StringBuilder append(StringBuilder strb, FieldAccessor fa, String prefix) {
        if (fa != null) {
            if (strb.length() > 0) {
                strb.append(",");
            }
            strb.append(prefix);
            if (fa.getContainingType() != null) {
                strb.append(fa.getContainingType().getTypeAsString());
            } else {
                strb.append("?");
            }
            strb.append(".");
            if (fa instanceof TGetter) {
                strb.append("get");
            } else {
                strb.append("set");
            }
        }
        return strb;
    }
}

