/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.JSXAbstractElement;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXElementName;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.JSXSpreadAttribute;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4jsx.ReactHelper;
import org.eclipse.n4js.organize.imports.ImportSpecifiersUtil;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class N4JSXValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    @Extension
    private ReactHelper reactHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkJSXinN4JS(JSXElement jsxElem) {
        ResourceType resType = ResourceType.getResourceType((EObject)jsxElem);
        if (resType != null) {
            switch (resType) {
                case N4JSX: {
                    return;
                }
                case JSX: {
                    return;
                }
            }
            String message = IssueCodes.getMessageForJSX_JSXELEMENT_IN_NON_JSX_RESOURCE(resType.name());
            this.addIssue(message, (EObject)jsxElem, "JSX_JSXELEMENT_IN_NON_JSX_RESOURCE");
        } else {
            String message = IssueCodes.getMessageForJSX_JSXELEMENT_IN_NON_JSX_RESOURCE(resType.name());
            this.addIssue(message, (EObject)jsxElem, "JSX_JSXELEMENT_IN_NON_JSX_RESOURCE");
        }
    }

    @Check
    public void checkProjectDependsOnReact(Script script) {
        ResourceType resourceType = ResourceType.getResourceType((EObject)script);
        if (ResourceType.N4JSX != resourceType && ResourceType.JSX != resourceType) {
            return;
        }
        Functions.Function1 _function = it -> it instanceof JSXAbstractElement;
        EObject firstJSXAbstractElement = (EObject)IteratorExtensions.findFirst((Iterator)script.eAllContents(), (Functions.Function1)_function);
        if (firstJSXAbstractElement != null && this.reactHelper.getJsxBackendModule(script.eResource()) == null) {
            this.addIssue(IssueCodes.getMessageForJSX_REACT_NOT_RESOLVED(), firstJSXAbstractElement, "JSX_REACT_NOT_RESOLVED");
        }
    }

    @Check
    public void checkReactImport(NamespaceImportSpecifier importSpecifier) {
        Resource resource = importSpecifier.eResource();
        ResourceType resourceType = ResourceType.getResourceType(resource);
        if (ResourceType.N4JSX != resourceType && ResourceType.JSX != resourceType) {
            return;
        }
        TModule reactModule = this.reactHelper.getJsxBackendModule(resource);
        TModule importedModule = ImportSpecifiersUtil.importedModule((ImportSpecifier)importSpecifier);
        if (reactModule != null && importedModule == reactModule) {
            boolean _notEquals;
            String _alias = importSpecifier.getAlias();
            boolean bl = _notEquals = !Objects.equal((Object)_alias, (Object)ReactHelper.REACT_NAMESPACE_NAME);
            if (_notEquals) {
                this.addIssue(IssueCodes.getMessageForJSX_REACT_NAMESPACE_NOT_ALLOWED(), (EObject)importSpecifier, "JSX_REACT_NAMESPACE_NOT_ALLOWED");
            }
        }
    }

    @Check
    public void checkOpeningClosingElementMismatch(JSXElement jsxElem) {
        JSXElementName _jsxElementName = null;
        if (jsxElem != null) {
            _jsxElementName = jsxElem.getJsxElementName();
        }
        Expression _expression = null;
        if (_jsxElementName != null) {
            _expression = _jsxElementName.getExpression();
        }
        String _refName = null;
        if (_expression != null) {
            _refName = this.getRefName(_expression);
        }
        String openingName = _refName;
        JSXElementName _jsxClosingName = null;
        if (jsxElem != null) {
            _jsxClosingName = jsxElem.getJsxClosingName();
        }
        Expression _expression_1 = null;
        if (_jsxClosingName != null) {
            _expression_1 = _jsxClosingName.getExpression();
        }
        String _refName_1 = null;
        if (_expression_1 != null) {
            _refName_1 = this.getRefName(_expression_1);
        }
        String closingName = _refName_1;
        if (jsxElem.getJsxClosingName() != null && !Objects.equal((Object)openingName, (Object)closingName)) {
            String message = IssueCodes.getMessageForJSX_JSXELEMENT_OPENING_CLOSING_ELEMENT_NOT_MATCH(openingName, closingName);
            this.addIssue(message, (EObject)jsxElem, (EStructuralFeature)N4JSPackage.Literals.JSX_ELEMENT__JSX_CLOSING_NAME, "JSX_JSXELEMENT_OPENING_CLOSING_ELEMENT_NOT_MATCH", new String[0]);
        }
    }

    @Check
    public void checkReactElementBinding(JSXElement jsxElem) {
        boolean isClass;
        Expression expr = jsxElem.getJsxElementName().getExpression();
        TypeRef exprTypeRef = this.reactHelper.getJsxElementBindingType(jsxElem);
        boolean isFunction = exprTypeRef instanceof FunctionTypeExprOrRef;
        boolean bl = isClass = exprTypeRef instanceof TypeTypeRef && ((TypeTypeRef)exprTypeRef).isConstructorRef();
        if (!isFunction && !isClass) {
            String refName = this.getRefName(expr);
            if (refName != null && Character.isLowerCase(refName.charAt(0))) {
                if (!N4JSGlobals.HTML_TAGS.contains(refName) && !N4JSGlobals.SVG_TAGS.contains(refName)) {
                    String message = IssueCodes.getMessageForJSX_TAG_UNKNOWN(refName);
                    this.addIssue(message, (EObject)jsxElem, (EStructuralFeature)N4JSPackage.Literals.JSX_ELEMENT__JSX_ELEMENT_NAME, "JSX_TAG_UNKNOWN", new String[0]);
                }
            } else {
                String message_1 = IssueCodes.getMessageForJSX_REACT_ELEMENT_NOT_FUNCTION_OR_CLASS_ERROR(exprTypeRef.getTypeRefAsString());
                this.addIssue(message_1, (EObject)expr, "JSX_REACT_ELEMENT_NOT_FUNCTION_OR_CLASS_ERROR");
            }
            return;
        }
        if (isFunction) {
            this.checkFunctionTypeExprOrRef(jsxElem, (FunctionTypeExprOrRef)exprTypeRef);
            this.checkReactComponentShouldStartWithUppercase(jsxElem, true);
        }
        if (isClass) {
            this.checkTypeTypeRefConstructor(jsxElem, (TypeTypeRef)exprTypeRef);
            this.checkReactComponentShouldStartWithUppercase(jsxElem, false);
        }
        this.checkAllNonOptionalFieldsAreSpecified(jsxElem, exprTypeRef);
    }

    private void checkReactComponentShouldStartWithUppercase(JSXElement jsxElem, boolean isFunctionalComponent) {
        Expression expr = jsxElem.getJsxElementName().getExpression();
        String refName = this.getRefName(expr);
        if (refName != null && !refName.isEmpty() && Character.isLowerCase(refName.charAt(0))) {
            if (isFunctionalComponent) {
                String message = IssueCodes.getMessageForJSX_REACT_FUNCTIONAL_COMPONENT_CANNOT_START_WITH_LOWER_CASE(refName);
                this.addIssue(message, (EObject)jsxElem, (EStructuralFeature)N4JSPackage.Literals.JSX_ELEMENT__JSX_ELEMENT_NAME, "JSX_REACT_FUNCTIONAL_COMPONENT_CANNOT_START_WITH_LOWER_CASE", new String[0]);
            } else {
                String message_1 = IssueCodes.getMessageForJSX_REACT_CLASS_COMPONENT_CANNOT_START_WITH_LOWER_CASE(refName);
                this.addIssue(message_1, (EObject)jsxElem, (EStructuralFeature)N4JSPackage.Literals.JSX_ELEMENT__JSX_ELEMENT_NAME, "JSX_REACT_CLASS_COMPONENT_CANNOT_START_WITH_LOWER_CASE", new String[0]);
            }
        }
    }

    private void checkFunctionTypeExprOrRef(JSXElement jsxElem, FunctionTypeExprOrRef exprTypeRef) {
        TClassifier elementClassTypeRef = this.reactHelper.lookUpReactElement((EObject)jsxElem);
        if (elementClassTypeRef == null) {
            return;
        }
        Expression expr = jsxElem.getJsxElementName().getExpression();
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expr);
        Result result = this.ts.subtype(G, (TypeArgument)exprTypeRef.getReturnTypeRef(), (TypeArgument)TypeUtils.createTypeRef((Type)elementClassTypeRef, (TypeArgument[])new TypeArgument[0]));
        boolean _isFailure = result.isFailure();
        if (_isFailure) {
            String message = IssueCodes.getMessageForJSX_REACT_ELEMENT_FUNCTION_NOT_REACT_ELEMENT_ERROR(exprTypeRef.getReturnTypeRef().getTypeRefAsString());
            this.addIssue(message, (EObject)expr, "JSX_REACT_ELEMENT_FUNCTION_NOT_REACT_ELEMENT_ERROR");
        }
    }

    private void checkTypeTypeRefConstructor(JSXElement jsxElem, TypeTypeRef exprTypeRef) {
        Type tclass;
        ParameterizedTypeRef tclassTypeRef;
        TClassifier componentClassTypeRef = this.reactHelper.lookUpReactComponent((EObject)jsxElem);
        if (componentClassTypeRef == null) {
            return;
        }
        Expression expr = jsxElem.getJsxElementName().getExpression();
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expr);
        Result resultSubType = this.ts.subtype(G, (TypeArgument)(tclassTypeRef = TypeUtils.createTypeRef((Type)(tclass = this.tsh.getStaticType(G, exprTypeRef)), (TypeArgument[])new TypeArgument[0])), (TypeArgument)TypeUtils.createTypeRef((Type)componentClassTypeRef, (TypeArgument[])new TypeArgument[0]));
        boolean _isFailure = resultSubType.isFailure();
        if (_isFailure) {
            String message = IssueCodes.getMessageForJSX_REACT_ELEMENT_CLASS_NOT_REACT_ELEMENT_ERROR();
            this.addIssue(message, (EObject)expr, "JSX_REACT_ELEMENT_CLASS_NOT_REACT_ELEMENT_ERROR");
        }
    }

    @Check
    public void checkUnknownJSXPropertyAttribute(JSXPropertyAttribute propertyAttribute) {
        boolean isClass;
        EObject _eContainer = propertyAttribute.eContainer();
        JSXElement jsxElem = (JSXElement)_eContainer;
        TypeRef exprTypeRef = this.reactHelper.getJsxElementBindingType(jsxElem);
        boolean isFunction = exprTypeRef instanceof FunctionTypeExprOrRef;
        boolean bl = isClass = exprTypeRef instanceof TypeTypeRef && ((TypeTypeRef)exprTypeRef).isConstructorRef();
        if (!isFunction && !isClass) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)propertyAttribute);
        TypeRef result = this.ts.type(G, (TypableElement)propertyAttribute.getProperty());
        if (result instanceof UnknownTypeRef) {
            String _propertyAsText = propertyAttribute.getPropertyAsText();
            JSXElementName _jsxElementName = null;
            if (jsxElem != null) {
                _jsxElementName = jsxElem.getJsxElementName();
            }
            Expression _expression = null;
            if (_jsxElementName != null) {
                _expression = _jsxElementName.getExpression();
            }
            String _refName = null;
            if (_expression != null) {
                _refName = this.getRefName(_expression);
            }
            String message = IssueCodes.getMessageForJSX_JSXSPROPERTYATTRIBUTE_NOT_DECLARED_IN_PROPS(_propertyAsText, _refName);
            this.addIssue(message, (EObject)propertyAttribute, (EStructuralFeature)N4JSPackage.Literals.JSX_PROPERTY_ATTRIBUTE__PROPERTY, "JSX_JSXSPROPERTYATTRIBUTE_NOT_DECLARED_IN_PROPS", new String[0]);
        }
    }

    @Check
    public void checkAttributeAndTypeConformityInJSXSpreadAttribute(JSXSpreadAttribute spreadAttribute) {
        TypeRef propsType;
        Expression _expression = null;
        if (spreadAttribute != null) {
            _expression = spreadAttribute.getExpression();
        }
        Expression expr = _expression;
        EObject _eContainer = null;
        if (spreadAttribute != null) {
            _eContainer = spreadAttribute.eContainer();
        }
        JSXElement jsxElem = (JSXElement)_eContainer;
        TypeRef _propsType = null;
        if (jsxElem != null) {
            _propsType = this.reactHelper.getPropsType(jsxElem);
        }
        if ((propsType = _propsType) == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)spreadAttribute);
        Functions.Function1 _function = m -> m instanceof TField || m instanceof TGetter;
        Iterable fieldsOrGettersInProps = IterableExtensions.filter(this.tsh.getStructuralTypesHelper().collectStructuralMembers(G, propsType, TypingStrategy.STRUCTURAL), (Functions.Function1)_function);
        TypeRef exprTypeResult = this.ts.type(G, (TypableElement)expr);
        Functions.Function1 _function_1 = m -> m instanceof TField || m instanceof TGetter;
        Iterable attributesInSpreadOperatorType = IterableExtensions.filter(this.tsh.getStructuralTypesHelper().collectStructuralMembers(G, exprTypeResult, TypingStrategy.STRUCTURAL), (Functions.Function1)_function_1);
        Consumer<TMember> _function_2 = attributeInSpreadOperator -> {
            TypeRef fieldOrGetterInPropsTypeRef;
            Result result;
            boolean _isFailure;
            TypeRef attributeInSpreadOperatorTypeRef = this.reactHelper.typeRefOfFieldOrGetter((TMember)attributeInSpreadOperator, exprTypeResult);
            Functions.Function1 _function_3 = fieldOrGetter -> {
                String _name = attributeInSpreadOperator.getName();
                String _name_1 = fieldOrGetter.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            TMember fieldOrGetterInProps = (TMember)IterableExtensions.findFirst((Iterable)fieldsOrGettersInProps, (Functions.Function1)_function_3);
            if (fieldOrGetterInProps != null && (_isFailure = (result = this.ts.subtype(G, (TypeArgument)attributeInSpreadOperatorTypeRef, (TypeArgument)(fieldOrGetterInPropsTypeRef = this.ts.tau((TypableElement)fieldOrGetterInProps, propsType)))).isFailure())) {
                String message = IssueCodes.getMessageForJSX_JSXSPREADATTRIBUTE_WRONG_SUBTYPE(attributeInSpreadOperator.getName(), attributeInSpreadOperatorTypeRef.getTypeRefAsString(), fieldOrGetterInPropsTypeRef.getTypeRefAsString());
                this.addIssue(message, (EObject)spreadAttribute, (EStructuralFeature)N4JSPackage.Literals.JSX_SPREAD_ATTRIBUTE__EXPRESSION, "JSX_JSXSPREADATTRIBUTE_WRONG_SUBTYPE", new String[0]);
            }
        };
        attributesInSpreadOperatorType.forEach(_function_2);
    }

    @Check
    public void checkNamedElementNotNamedReact(NamedElement elem) {
        ResourceType resourceType = ResourceType.getResourceType((EObject)elem);
        if (ResourceType.N4JSX != resourceType && ResourceType.JSX != resourceType) {
            return;
        }
        String _name = elem.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)ReactHelper.REACT_NAMESPACE_NAME);
        if (_equals) {
            String message = IssueCodes.getMessageForJSX_NAME_CANNOT_BE_REACT();
            this.addIssue(message, (EObject)elem, (EStructuralFeature)this.findNameFeature((EObject)elem).getValue(), "JSX_NAME_CANNOT_BE_REACT", new String[0]);
        }
    }

    private void checkAllNonOptionalFieldsAreSpecified(JSXElement jsxElem, TypeRef exprTypeRef) {
        boolean _not;
        EList jsxPropertyAttributes = jsxElem.getJsxAttributes();
        Functions.Function1 _function = a -> a.getProperty();
        ArrayList allAttributesInJSXElement = Lists.newArrayList((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)jsxPropertyAttributes, JSXPropertyAttribute.class), (Functions.Function1)_function));
        TypeRef propsType = this.reactHelper.getPropsType(jsxElem);
        if (propsType == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)jsxElem);
        Functions.Function1 _function_1 = spreadAttribute -> {
            TypeRef exprTypeRefResult = this.ts.type(G, (TypableElement)spreadAttribute.getExpression());
            Functions.Function1 _function_2 = m -> m instanceof TField || m instanceof TGetter;
            return IterableExtensions.filter(this.tsh.getStructuralTypesHelper().collectStructuralMembers(G, exprTypeRefResult, TypingStrategy.STRUCTURAL), (Functions.Function1)_function_2);
        };
        Iterable attributesInSpreadOperator = Iterables.concat((Iterable)Lists.newArrayList((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)jsxPropertyAttributes, JSXSpreadAttribute.class), (Functions.Function1)_function_1)));
        Iterables.addAll((Collection)allAttributesInJSXElement, (Iterable)attributesInSpreadOperator);
        Functions.Function1 _function_2 = m -> (m instanceof TField || m instanceof TGetter) && !m.isOptional();
        Iterable nonOptionalFieldsOrGettersInProps = IterableExtensions.filter(this.tsh.getStructuralTypesHelper().collectStructuralMembers(G, propsType, TypingStrategy.STRUCTURAL), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = fieldOrGetter -> {
            Functions.Function1 _function_4 = attribute -> {
                String _name = attribute.getName();
                String _name_1 = fieldOrGetter.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            boolean _exists = IterableExtensions.exists((Iterable)allAttributesInJSXElement, (Functions.Function1)_function_4);
            return !_exists;
        };
        Functions.Function1 _function_4 = fieldOrGetter -> fieldOrGetter.getName();
        String missingFieldsStringRep = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)nonOptionalFieldsOrGettersInProps, (Functions.Function1)_function_3), (Functions.Function1)_function_4), (CharSequence)",");
        boolean _isEmpty = missingFieldsStringRep.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String message = IssueCodes.getMessageForJSX_JSXPROPERTY_ATTRIBUTE_NON_OPTIONAL_PROPERTY_NOT_SPECIFIED(missingFieldsStringRep);
            this.addIssue(message, (EObject)jsxElem, (EStructuralFeature)N4JSPackage.Literals.JSX_ELEMENT__JSX_ELEMENT_NAME, "JSX_JSXPROPERTY_ATTRIBUTE_NON_OPTIONAL_PROPERTY_NOT_SPECIFIED", new String[0]);
        }
    }

    private String getRefName(Expression expr) {
        String refName = null;
        if (expr instanceof IdentifierRef) {
            refName = ((IdentifierRef)expr).getIdAsText();
        } else if (expr instanceof ParameterizedPropertyAccessExpression) {
            refName = ((ParameterizedPropertyAccessExpression)expr).getPropertyAsText();
        }
        return refName;
    }
}

