/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpect.runner.DescriptionFactory;
import org.eclipse.xpect.runner.XpectRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class ErrorReportingRunner
extends Runner {
    private final List<Throwable> causes;
    private final XpectRunner runner;
    private final URI uri;

    public ErrorReportingRunner(XpectRunner runner, URI uri, Throwable cause) {
        this.runner = runner;
        this.uri = uri;
        this.causes = this.getCauses(cause);
    }

    private Description describeCause(Throwable child) {
        return Description.createTestDescription((Class)this.runner.getTestClass().getJavaClass(), (String)"initializationError");
    }

    private List<Throwable> getCauses(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            return this.getCauses(cause.getCause());
        }
        if (cause instanceof InitializationError) {
            return ((InitializationError)cause).getCauses();
        }
        return Arrays.asList(cause);
    }

    public Description getDescription() {
        Description description = DescriptionFactory.createFileDescriptionForError(this.runner.getTestClass().getJavaClass(), this.runner.getUriProvider(), this.uri);
        for (Throwable each : this.causes) {
            description.addChild(this.describeCause(each));
        }
        return description;
    }

    public void run(RunNotifier notifier) {
        for (Throwable each : this.causes) {
            this.runCause(each, notifier);
        }
    }

    private void runCause(Throwable child, RunNotifier notifier) {
        Description description = this.describeCause(child);
        notifier.fireTestStarted(description);
        notifier.fireTestFailure(new Failure(description, child));
        notifier.fireTestFinished(description);
    }
}

