/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import java.util.function.Consumer;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InstallNpmDependencyDialog
extends TitleAreaDialog {
    private static final String EMPTY = "";
    private static final String LN_DASH = "\n - ";
    private static final String PACKAGE_NAME = "Package name";
    private static final String VERSION_OPTIONAL = "Version (optional)";
    private static final String PROPERTIES_OF_NPM_DEPENDENCY = "Properties of npm dependency.";
    private static final String PROVIDE_PROPERTIES_OF_NPM_PACKAGE_TO_INSTALL = "Provide properties of npm package to install.";
    private static final String REVIEW_ISSUES = "Please review following issues:";
    private static final String VERSION_ISSUES = "Version issues: ";
    private final IInputValidator packageNameValidator;
    private final IInputValidator packageVersionValidator;
    private String errPackageName = null;
    private String errVersion = null;
    private String version = "";
    private String packageName;

    public InstallNpmDependencyDialog(Shell parentShell, IInputValidator packageNameValidator, IInputValidator packageVersionValidator) {
        super(parentShell);
        this.packageNameValidator = packageNameValidator;
        this.packageVersionValidator = packageVersionValidator;
    }

    public String getPackageName() {
        if (this.hasErrors()) {
            return null;
        }
        return this.packageName;
    }

    public String getVersionConstraint() {
        if (this.hasErrors()) {
            return null;
        }
        return this.version;
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.setTitle(PROPERTIES_OF_NPM_DEPENDENCY);
        this.setMessage(PROVIDE_PROPERTIES_OF_NPM_PACKAGE_TO_INSTALL, 1);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Group customDialogArea = new Group(parent, 16);
        customDialogArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).create());
        customDialogArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(4, 128).create());
        this.createNameArea((Composite)customDialogArea, PACKAGE_NAME, this::handlePackageNameInput);
        this.createVersionArea(customDialogArea, VERSION_OPTIONAL, this::handleVersionInput);
        return customDialogArea;
    }

    private void createVersionArea(Group parent, String versionLabel, final Consumer<String> textHandler) {
        Composite area = this.createVersionArea((Composite)parent, versionLabel);
        Composite textArea = this.createVersionInputArea(area);
        Text txtUpperVersion = this.getSimpleTextArea(textArea);
        txtUpperVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text textWidget = (Text)e.getSource();
                textHandler.accept(textWidget.getText());
            }
        });
    }

    private Text getSimpleTextArea(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return text;
    }

    private Composite createVersionArea(Composite parent, String label) {
        Group area = new Group(parent, 16);
        area.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        area.setText(label);
        return area;
    }

    private Composite createVersionInputArea(Composite parent) {
        Composite textArea = new Composite(parent, 0);
        textArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).create());
        textArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).create());
        return textArea;
    }

    private void createNameArea(Composite parent, String areaName, final Consumer<String> textHandler) {
        Group area = new Group(parent, 16);
        area.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).create());
        area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        area.setText(areaName);
        Text txtPackageName = this.getSimpleTextArea((Composite)area);
        txtPackageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text textWidget = (Text)e.getSource();
                textHandler.accept(textWidget.getText());
            }
        });
    }

    private void toggleOK(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    private void handlePackageNameInput(String userText) {
        this.errPackageName = this.packageNameValidator.isValid(userText);
        this.packageName = userText;
        this.updateErrors();
    }

    private boolean hasErrors() {
        return this.errPackageName != null || this.errVersion != null;
    }

    private final void updateErrors() {
        boolean hasNoErrors = !this.hasErrors();
        this.toggleOK(hasNoErrors);
        if (hasNoErrors) {
            this.setErrorMessage(null);
        } else {
            StringBuilder sb = new StringBuilder();
            if (this.errPackageName != null) {
                sb.append(LN_DASH).append(this.errPackageName);
            }
            if (this.errVersion != null) {
                sb.append(LN_DASH).append(this.errVersion);
            }
            this.setErrorMessage(REVIEW_ISSUES + sb);
        }
    }

    private void handleVersionInput(String userText) {
        String validateResult;
        String preprocessed;
        this.errVersion = null;
        String string = preprocessed = userText == null ? EMPTY : userText.trim();
        if (!preprocessed.isEmpty() && (validateResult = this.validate(preprocessed)) != null) {
            this.errVersion = VERSION_ISSUES + validateResult;
        }
        this.version = preprocessed;
        this.updateErrors();
    }

    private String validate(String data) {
        String preprocessed;
        String result = null;
        String string = preprocessed = data == null ? EMPTY : data.trim();
        if (!preprocessed.isEmpty()) {
            result = this.packageVersionValidator.isValid(preprocessed);
        }
        return result;
    }
}

