/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import com.google.inject.Inject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.NpmCLI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.ui.utils.InputComposedValidator;
import org.eclipse.n4js.ui.utils.InputFunctionalValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

public class NpmNameAndVersionValidatorHelper {
    @Inject
    private NpmCLI npmCli;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private SemverHelper semverHelper;

    IInputValidator getPackageVersionValidator() {
        return InputFunctionalValidator.from(version -> this.parsingVersionValidator((String)version));
    }

    private String parsingVersionValidator(String data) {
        String result = null;
        IParseResult parseResult = this.semverHelper.getParseResult(data);
        if (parseResult == null) {
            result = "Could not create version from string :" + data + ":\n";
        } else if (parseResult.hasSyntaxErrors()) {
            INode firstErrorNode = (INode)parseResult.getSyntaxErrors().iterator().next();
            result = "Parsing error: " + firstErrorNode.getSyntaxErrorMessage().getMessage();
        }
        return result;
    }

    IInputValidator getPackageNameToInstallValidator() {
        return InputComposedValidator.compose(this.getBasicPackageValidator(), InputFunctionalValidator.from(name -> !this.isNpmWithNameInstalled(new N4JSProjectName(name)) ? null : "The npm package '" + name + "' is already available."));
    }

    IInputValidator getPackageNameToUninstallValidator() {
        return InputComposedValidator.compose(this.getBasicPackageValidator(), InputFunctionalValidator.from(name -> this.isNpmWithNameInstalled(new N4JSProjectName(name)) ? null : "The npm package '" + name + "' is not installed."));
    }

    private IInputValidator getBasicPackageValidator() {
        return InputFunctionalValidator.from(name -> {
            N4JSProjectName projectName = new N4JSProjectName(name);
            if (this.npmCli.invalidPackageName(projectName)) {
                return "The npm package name should be specified.";
            }
            int i = 0;
            while (i < name.length()) {
                if (Character.isWhitespace(name.charAt(i))) {
                    return "The npm package name must not contain any whitespaces.";
                }
                if (Character.isUpperCase(name.charAt(i))) {
                    return "The npm package name must not contain any upper case letter.";
                }
                ++i;
            }
            return null;
        });
    }

    private boolean isNpmWithNameInstalled(N4JSProjectName packageName) {
        return this.externalLibraryWorkspace.getProject(packageName) != null;
    }
}

