/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.typesearch;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.n4js.ui.N4JSEditor;
import org.eclipse.n4js.ui.typesearch.OpenTypeSelectionDialog;
import org.eclipse.n4js.ui.utils.HandlerServiceUtils;
import org.eclipse.n4js.utils.N4JSLanguageHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class OpenTypeSelectionDialogHandler
extends AbstractHandler {
    private static final AtomicBoolean TYPE_SEARCH_IN_USE = new AtomicBoolean();
    private static final Logger LOGGER = Logger.getLogger(OpenTypeSelectionDialogHandler.class);
    @Inject
    private Provider<OpenTypeSelectionDialog> provider;
    @Inject
    private N4JSLanguageHelper languageHelper;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (TYPE_SEARCH_IN_USE.compareAndSet(false, true)) {
            try {
                OpenTypeSelectionDialog typeSelectionDialog = (OpenTypeSelectionDialog)((Object)this.provider.get());
                typeSelectionDialog.setInitialPattern(this.computeInitialPattern());
                typeSelectionDialog.open();
            }
            finally {
                TYPE_SEARCH_IN_USE.set(false);
            }
        }
        return null;
    }

    private String computeInitialPattern() {
        IEditorPart activeEditor = (IEditorPart)HandlerServiceUtils.getActiveEditor().orNull();
        if (activeEditor instanceof N4JSEditor) {
            Point range = ((N4JSEditor)activeEditor).getSourceViewer2().getSelectedRange();
            try {
                String text = ((N4JSEditor)activeEditor).getDocument().get(range.x, range.y);
                if (N4JSLanguageUtils.isValidIdentifier((String)text) && !this.startWithLowercaseLetter(text) && !this.languageHelper.isReservedIdentifier(text)) {
                    return text;
                }
            }
            catch (BadLocationException e) {
                LOGGER.error((Object)"Failed to infer type search pattern from editor selection.", (Throwable)e);
            }
        }
        return "";
    }

    private boolean startWithLowercaseLetter(String string) {
        return !string.isEmpty() && string.charAt(0) == string.toLowerCase().charAt(0);
    }
}

