/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.constraints;

import com.google.common.base.Optional;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.NullType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.UndefinedType;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.constraints.BoundSet;
import org.eclipse.n4js.typesystem.constraints.Reducer;
import org.eclipse.n4js.typesystem.constraints.TypeConstraint;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.CharDiscreteDomain;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

public final class InferenceContext {
    static final boolean DEBUG = false;
    private final N4JSTypeSystem ts;
    private final TypeSystemHelper tsh;
    private final OperationCanceledManager operationCanceledManager;
    private final CancelIndicator cancelIndicator;
    private final RuleEnvironment G;
    private final Set<InferenceVariable> inferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<TypeConstraint> constraints = new ArrayList<TypeConstraint>();
    final Reducer reducer;
    final BoundSet currentBounds;
    private final List<Consumer<Optional<Map<InferenceVariable, TypeRef>>>> onSolvedActions = new ArrayList<Consumer<Optional<Map<InferenceVariable, TypeRef>>>>();
    private boolean isSolved = false;
    private Map<InferenceVariable, TypeRef> solution = null;
    private final UnusedNameGenerator unusedNameGenerator = new UnusedNameGenerator();
    private final UnusedNameGenerator unusedNameGeneratorInternal = new UnusedNameGenerator();

    public InferenceContext(N4JSTypeSystem ts, TypeSystemHelper tsh, OperationCanceledManager operationCanceledManager, CancelIndicator cancelIndicator, RuleEnvironment G, InferenceVariable ... inferenceVariables) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(tsh);
        Objects.requireNonNull(G);
        this.ts = ts;
        this.tsh = tsh;
        this.operationCanceledManager = operationCanceledManager;
        this.cancelIndicator = cancelIndicator;
        this.G = G;
        this.addInferenceVariables(false, inferenceVariables);
        this.reducer = new Reducer(this, G, ts, tsh);
        this.currentBounds = new BoundSet(this, G, ts);
    }

    public void onSolved(Consumer<Optional<Map<InferenceVariable, TypeRef>>> action) {
        this.onSolvedActions.add(action);
    }

    public boolean giveUp() {
        return this.currentBounds.addBound(false);
    }

    public boolean isDoomed() {
        if (this.operationCanceledManager != null && this.cancelIndicator != null) {
            this.operationCanceledManager.checkCanceled(this.cancelIndicator);
        }
        return this.currentBounds.hasBoundFALSE();
    }

    public Set<InferenceVariable> getInferenceVariables() {
        return this.inferenceVariables;
    }

    private void addInferenceVariables(boolean internal, InferenceVariable ... inferenceVariables) {
        if (inferenceVariables == null || inferenceVariables.length == 0) {
            return;
        }
        if (this.isSolved && !internal) {
            throw new IllegalStateException("may not add inference variables after #solve() has been invoked");
        }
        this.inferenceVariables.addAll(Arrays.asList(inferenceVariables));
    }

    public InferenceVariable newInferenceVariable() {
        return this.newInferenceVariable(false);
    }

    private InferenceVariable newInferenceVariable(boolean internal) {
        InferenceVariable iv = TypesFactory.eINSTANCE.createInferenceVariable();
        String name = internal ? "_" + this.unusedNameGeneratorInternal.next() : this.unusedNameGenerator.next();
        iv.setName(name);
        this.addInferenceVariables(internal, iv);
        return iv;
    }

    public InferenceVariable[] newInferenceVariables(int n) {
        return this.newInferenceVariables(n, false);
    }

    private InferenceVariable[] newInferenceVariables(int n, boolean internal) {
        InferenceVariable[] result = new InferenceVariable[n];
        int i = 0;
        while (i < n) {
            result[i] = this.newInferenceVariable(internal);
            ++i;
        }
        return result;
    }

    public FunctionTypeExprOrRef newInferenceVariablesFor(FunctionTypeExprOrRef funTypeRef) {
        if (!funTypeRef.isGeneric()) {
            return funTypeRef;
        }
        EList typeParams = funTypeRef.getTypeVars();
        InferenceVariable[] newInfVars = this.newInferenceVariables(typeParams.size(), true);
        List newInfVarsRefs = Stream.of(newInfVars).map(inferenceVariable -> TypeUtils.createTypeRef((Type)inferenceVariable, (TypeArgument[])new TypeArgument[0])).collect(Collectors.toList());
        RuleEnvironment G_params2infVars = RuleEnvironmentExtensions.newRuleEnvironment(this.G);
        RuleEnvironmentExtensions.addTypeMappings(G_params2infVars, (List<? extends TypeVariable>)typeParams, newInfVarsRefs);
        TypeRef left_withInfVars = this.ts.substTypeVariables(G_params2infVars, (TypeRef)funTypeRef);
        if (left_withInfVars instanceof FunctionTypeExprOrRef) {
            return (FunctionTypeExprOrRef)left_withInfVars;
        }
        return funTypeRef;
    }

    public void addConstraint(TypeArgument left, TypeArgument right, Variance variance) {
        this.addConstraint(new TypeConstraint(left, right, variance));
    }

    public void addConstraint(TypeConstraint constraint) {
        if (this.isSolved) {
            throw new IllegalStateException("may not add constraints after #solve() has been invoked");
        }
        this.constraints.add(constraint);
    }

    public Map<InferenceVariable, TypeRef> solve() {
        if (this.isSolved) {
            return this.solution;
        }
        this.isSolved = true;
        for (TypeConstraint constraint : this.constraints) {
            this.reducer.reduce(constraint);
            if (this.isDoomed()) break;
        }
        this.constraints.clear();
        if (!this.isDoomed()) {
            this.currentBounds.incorporate();
        }
        boolean success = !this.isDoomed() ? this.resolve() : false;
        this.solution = success ? this.currentBounds.getInstantiations() : null;
        for (Consumer<Optional<Map<InferenceVariable, TypeRef>>> action : this.onSolvedActions) {
            action.accept((Optional<Map<InferenceVariable, TypeRef>>)Optional.fromNullable(this.solution));
        }
        return this.solution;
    }

    private boolean resolve() {
        Set<InferenceVariable> currVariableSet;
        while ((currVariableSet = this.getSmallestVariableSet(this.inferenceVariables)) != null) {
            for (InferenceVariable currVariable : currVariableSet) {
                TypeRef instantiation = this.chooseInstantiation(currVariable);
                if (instantiation == null) {
                    return false;
                }
                this.instantiate(currVariable, instantiation);
            }
            this.currentBounds.incorporate();
            if (!this.isDoomed()) continue;
            return false;
        }
        return true;
    }

    private void instantiate(InferenceVariable infVar, TypeRef proper) {
        assert (!this.currentBounds.isInstantiated(infVar)) : "attempt to re-instantiate var " + InferenceContext.str((TypeVariable)infVar);
        assert (TypeUtils.isProper((TypeArgument)proper));
        this.reducer.reduce((TypeArgument)TypeUtils.createTypeRef((Type)infVar, (TypeArgument[])new TypeArgument[0]), (TypeArgument)proper, Variance.INV);
        if (!this.currentBounds.isInstantiated(infVar)) {
            this.giveUp();
        }
    }

    private TypeRef chooseInstantiation(InferenceVariable infVar) {
        boolean preferUpperOverLower;
        TypeRef[] lowerBounds = this.currentBounds.collectLowerBounds(infVar, true, true);
        boolean lowerAreUninteresting = lowerBounds.length > 0 && !this.containsInterestingLowerBound(lowerBounds);
        TypeRef[] upperBoundsPreview = lowerAreUninteresting ? this.currentBounds.collectUpperBounds(infVar, true, true) : null;
        boolean bl = preferUpperOverLower = lowerAreUninteresting && upperBoundsPreview != null && upperBoundsPreview.length > 0;
        if (lowerBounds.length > 0 && !preferUpperOverLower) {
            int i = 0;
            while (i < lowerBounds.length) {
                lowerBounds[i] = this.ts.upperBound(this.G, (TypeArgument)lowerBounds[i]);
                ++i;
            }
            TypeRef result = this.tsh.createUnionType(this.G, lowerBounds);
            assert (TypeUtils.isProper((TypeArgument)result)) : "not a proper LUB: " + InferenceContext.str((TypeArgument)result);
            return result;
        }
        TypeRef[] upperBounds = this.currentBounds.collectUpperBounds(infVar, true, true);
        if (upperBounds.length > 0) {
            TypeRef result = this.tsh.createIntersectionType(this.G, upperBounds);
            assert (TypeUtils.isProper((TypeArgument)result)) : "not a proper GLB: " + InferenceContext.str((TypeArgument)result);
            return result;
        }
        return RuleEnvironmentExtensions.anyTypeRef(this.G);
    }

    private boolean containsInterestingLowerBound(TypeRef[] typeRefs) {
        UndefinedType undefinedType = RuleEnvironmentExtensions.undefinedType(this.G);
        NullType nullType = RuleEnvironmentExtensions.nullType(this.G);
        int i = 0;
        while (i < typeRefs.length) {
            Type currDeclType;
            TypeRef curr = typeRefs[i];
            if (curr instanceof ParameterizedTypeRef ? (currDeclType = curr.getDeclaredType()) != null && currDeclType != undefinedType && currDeclType != nullType : !(curr instanceof UnknownTypeRef)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Set<InferenceVariable> getSmallestVariableSet(Set<InferenceVariable> infVars) {
        LinkedHashSet<InferenceVariable> result = null;
        HashSet<InferenceVariable> deferred = null;
        int min = Integer.MAX_VALUE;
        for (InferenceVariable currentVariable : infVars) {
            boolean defer;
            boolean gotAtLeastOneDependantIV;
            if (this.currentBounds.isInstantiated(currentVariable)) continue;
            if (this.currentBounds.isUnbounded(currentVariable) && (gotAtLeastOneDependantIV = infVars.stream().anyMatch(iv -> this.currentBounds.dependsOnResolutionOf((InferenceVariable)iv, currentVariable))) && (defer = infVars.stream().filter(iv -> this.currentBounds.dependsOnResolutionOf((InferenceVariable)iv, currentVariable)).allMatch(iv -> {
                List bs = this.currentBounds.getBounds((InferenceVariable)iv).stream().filter(b -> b.left != iv || b.right.getDeclaredType() != currentVariable).collect(Collectors.toList());
                return !bs.isEmpty() && bs.stream().allMatch(b -> TypeUtils.isProper((TypeArgument)b.right));
            }))) {
                if (deferred == null) {
                    deferred = new HashSet<InferenceVariable>();
                }
                deferred.add(currentVariable);
                continue;
            }
            LinkedHashSet<InferenceVariable> set = new LinkedHashSet<InferenceVariable>();
            if (!this.addDependencies(currentVariable, min, set)) continue;
            int curr = set.size();
            if (curr == 1) {
                return set;
            }
            if (curr >= min) continue;
            result = set;
            min = curr;
        }
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (deferred != null) {
            result.removeAll(deferred);
        }
        return result;
    }

    private boolean addDependencies(InferenceVariable infVar, int limit, Set<InferenceVariable> addHere) {
        if (addHere.size() >= limit) {
            return false;
        }
        if (!addHere.add(infVar)) {
            return true;
        }
        for (InferenceVariable candidate : this.inferenceVariables) {
            if (candidate == infVar || this.currentBounds.isInstantiated(candidate) || !this.currentBounds.dependsOnResolutionOf(infVar, candidate) || this.addDependencies(candidate, limit, addHere)) continue;
            return false;
        }
        return true;
    }

    private static String str(TypeVariable v) {
        return v.getTypeAsString();
    }

    private static String str(TypeArgument targ) {
        return targ.getTypeRefAsString();
    }

    void log(String message) {
        System.out.println("[" + Integer.toHexString(System.identityHashCode(this)) + "] " + message);
    }

    public String toString() {
        return this.constraints.toString();
    }

    private static final class UnusedNameGenerator {
        private Iterator<Character> unusedNames = null;
        private int unusedNamesOverflows = 0;

        private UnusedNameGenerator() {
        }

        public String next() {
            String next;
            if (this.unusedNames == null) {
                this.unusedNames = ContiguousSet.create((Range)Range.closed((Comparable)Character.valueOf('\u03b1'), (Comparable)Character.valueOf('\u03b9')), (DiscreteDomain)CharDiscreteDomain.chars()).iterator();
            }
            if (this.unusedNamesOverflows == 0) {
                next = this.unusedNames.next().toString();
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(this.unusedNames.next().toString());
                int i = 0;
                while (i < this.unusedNamesOverflows) {
                    sb.append('\'');
                    ++i;
                }
                next = sb.toString();
            }
            if (!this.unusedNames.hasNext()) {
                this.unusedNames = null;
                ++this.unusedNamesOverflows;
            }
            return next;
        }
    }
}

