/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.PlatformResourceURI;
import org.eclipse.n4js.ui.external.OutdatedPackageJsonQueue;
import org.eclipse.xtext.builder.impl.ProjectOpenedOrClosedListener;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;

@Singleton
public class ProjectStateChangeListener
extends ProjectOpenedOrClosedListener {
    private static final Logger LOGGER = Logger.getLogger(ProjectStateChangeListener.class);
    private final ExternalIndexSynchronizer indexSynchronizer;
    private final IN4JSCore n4jsCore;
    private final SyncIndexJob syncIndexJob = new SyncIndexJob();
    private final OutdatedPackageJsonQueue packageJsonQueue;

    @Inject
    public ProjectStateChangeListener(ISharedStateContributionRegistry registry, OutdatedPackageJsonQueue packageJsonQueue) {
        this.indexSynchronizer = (ExternalIndexSynchronizer)registry.getSingleContributedInstance(ExternalIndexSynchronizer.class);
        this.n4jsCore = (IN4JSCore)registry.getSingleContributedInstance(IN4JSCore.class);
        this.packageJsonQueue = packageJsonQueue;
    }

    protected ProjectOpenedOrClosedListener.RemoveProjectsJob createRemoveProjectsJob() {
        return new ProjectOpenedOrClosedListener.RemoveProjectsJob(this){

            public boolean belongsTo(Object family) {
                return super.belongsTo(family) || family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
            }
        };
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IWorkspace workspace = this.getWorkspace();
        if (workspace != null && event.getType() == 1) {
            try {
                LinkedHashSet affectedProjects = Sets.newLinkedHashSet();
                event.getDelta().accept(this.projectCollector(affectedProjects));
                if (!affectedProjects.isEmpty()) {
                    ToBeBuilt toBeBuilt = new ToBeBuilt();
                    Set toBeUpdated = toBeBuilt.getToBeUpdated();
                    LinkedHashSet<String> projectNames = new LinkedHashSet<String>();
                    for (IProject project : affectedProjects) {
                        IFile file = project.getFile("package.json");
                        if (!file.exists()) continue;
                        projectNames.add(project.getName());
                        toBeUpdated.add(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
                    }
                    this.packageJsonQueue.enqueue(projectNames, toBeBuilt, false);
                    this.syncIndexJob.schedule();
                }
            }
            catch (CoreException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        super.resourceChanged(event);
    }

    public void forceIndexSync() {
        this.packageJsonQueue.enqueue(Collections.singleton("npm index sync"), new ToBeBuilt(), true);
    }

    private IResourceDeltaVisitor projectCollector(final Set<IProject> accumutor) {
        return new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                return ProjectStateChangeListener.this.collectAffectedProjects(delta, accumutor);
            }
        };
    }

    private boolean collectAffectedProjects(IResourceDelta delta, Set<IProject> accumulator) {
        IResource resource = delta.getResource();
        if (resource instanceof IProject && "RemoteSystemsTempFiles".equals(resource.getName())) {
            return false;
        }
        if (resource instanceof IWorkspaceRoot) {
            return true;
        }
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            if ("RemoteSystemsTempFiles".equals(resource.getName())) {
                return false;
            }
            if ((delta.getKind() & 4) != 0 && project.isOpen()) {
                if ((delta.getFlags() & 0x4000) != 0) {
                    accumulator.add(project);
                }
                if ((delta.getFlags() & 0x80000) != 0 && delta.findMember((IPath)new Path(".project")) != null && XtextProjectHelper.hasNature((IProject)project) && XtextProjectHelper.hasBuilder((IProject)project)) {
                    accumulator.add(project);
                }
            }
            return true;
        }
        if (resource instanceof IFolder) {
            if ("node_modules".equals(resource.getName())) {
                accumulator.add(resource.getProject());
            } else if ((delta.getKind() == 1 || delta.getKind() == 2) && this.isSourceContainerModification(resource)) {
                accumulator.add(resource.getProject());
            }
        }
        return false;
    }

    private boolean isSourceContainerModification(IResource folder) {
        return ProjectStateChangeListener.isSourceContainerModification(this.n4jsCore, folder.getFullPath());
    }

    public static boolean isSourceContainerModification(IN4JSCore n4jsCore, IPath changedPath) {
        String fullPathStr = changedPath.toString();
        URI folderUri = URI.createPlatformResourceURI((String)fullPathStr, (boolean)true);
        IN4JSProject project = (IN4JSProject)n4jsCore.findProject(folderUri).orNull();
        if (project != null && project.exists()) {
            return FluentIterable.from((Iterable)project.getSourceContainers()).transform(container -> container.getLocation()).filter(PlatformResourceURI.class).transform(uri -> uri.getAbsolutePath()).firstMatch(path -> path.equals(fullPathStr)).isPresent();
        }
        return false;
    }

    private void updateNpmIndex(IProgressMonitor monitor) throws CoreException {
        OutdatedPackageJsonQueue.Task task = this.packageJsonQueue.exhaust();
        if (task.isEmpty()) {
            return;
        }
        try {
            try {
                this.indexSynchronizer.checkAndClearIndex(monitor);
                Set toBeUpdated = task.getToBeBuilt().getToBeUpdated();
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                for (URI touchMe : toBeUpdated) {
                    IFile file;
                    if (!touchMe.isPlatformResource() || !(file = workspaceRoot.getFile((IPath)new Path(touchMe.toPlatformString(true)))).exists()) continue;
                    file.touch(monitor);
                }
            }
            catch (Error | RuntimeException | CoreException e) {
                task.reschedule();
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean visitResourceDelta(IResourceDelta delta, Set<IProject> accumulator) {
        IResource resource = delta.getResource();
        if (resource instanceof IProject && "RemoteSystemsTempFiles".equals(resource.getName())) {
            return false;
        }
        return super.visitResourceDelta(delta, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinRemoveProjectJob() {
        try {
            ProjectStateChangeListener projectStateChangeListener = this;
            synchronized (projectStateChangeListener) {
                ((Object)((Object)this)).wait(1L);
            }
            this.syncIndexJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.joinRemoveProjectJob();
    }

    private class SyncIndexJob
    extends WorkspaceJob {
        public SyncIndexJob() {
            super("Updating npm index");
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ProjectStateChangeListener.this.updateNpmIndex(monitor);
            return Status.OK_STATUS;
        }
    }
}

