/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ShiftOperator implements Enumerator
{
    SHL(0, "shl", "<<"),
    SHR(1, "shr", ">>"),
    USHR(2, "ushr", ">>>");

    public static final int SHL_VALUE = 0;
    public static final int SHR_VALUE = 1;
    public static final int USHR_VALUE = 2;
    private static final ShiftOperator[] VALUES_ARRAY;
    public static final List<ShiftOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ShiftOperator[]{SHL, SHR, USHR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ShiftOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShiftOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShiftOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShiftOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShiftOperator get(int value) {
        switch (value) {
            case 0: {
                return SHL;
            }
            case 1: {
                return SHR;
            }
            case 2: {
                return USHR;
            }
        }
        return null;
    }

    private ShiftOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

