/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist.antlr;

import com.google.common.base.Function;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.contentassist.CompletionPrefixProvider;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.antlr.CallHierarchyHelper;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElementComputer;
import org.eclipse.xtext.ide.editor.contentassist.antlr.IContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.LeafNodeFinder;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
import org.eclipse.xtext.ide.editor.partialEditing.IPartialEditingContentAssistParser;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;

public class ContentAssistContextFactory
implements Function<ContentAssistContext.Builder, ContentAssistContext> {
    private static final Logger log = Logger.getLogger(ContentAssistContextFactory.class);
    private ExecutorService pool;
    @Inject
    protected IContentAssistParser parser;
    @Inject
    @Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.CONTENT_ASSIST")
    protected Lexer lexer;
    @Inject
    protected Provider<ContentAssistContext.Builder> contentAssistContextProvider;
    @Inject
    protected ITokenDefProvider tokenDefProvider;
    @Inject
    protected FollowElementComputer followElementComputer;
    @Inject
    protected CompletionPrefixProvider completionPrefixProvider;
    protected XtextResource resource;
    protected ICompositeNode rootNode;
    protected INode lastCompleteNode;
    protected INode currentNode;
    protected INode lastVisibleNode;
    protected EObject currentModel;
    protected List<ContentAssistContext.Builder> contextBuilders;
    protected IParseResult parseResult;
    protected INode datatypeNode;
    protected int completionOffset;
    protected ITextRegion selection;
    private String document;

    public ContentAssistContext apply(ContentAssistContext.Builder from) {
        return from.toContext();
    }

    public ContentAssistContext[] create(String document, ITextRegion selection, int offset, XtextResource resource) {
        this.document = document;
        this.selection = selection;
        this.resource = resource;
        if (resource instanceof DerivedStateAwareResource) {
            resource.getContents();
        }
        this.parseResult = resource.getParseResult();
        if (this.parseResult == null) {
            throw new NullPointerException("parseResult is null");
        }
        return this.doCreateContexts(offset);
    }

    protected INode getCurrentNode() {
        return this.currentNode;
    }

    public void setPool(ExecutorService pool) {
        this.pool = pool;
    }

    protected ContentAssistContext[] doCreateContexts(int offset) {
        this.initializeFromViewerAndResource(offset);
        ArrayList futures = Lists.newArrayList();
        if (!this.datatypeNode.equals(this.lastCompleteNode)) {
            futures.add(this.pool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ContentAssistContextFactory.this.handleLastCompleteNodeAsPartOfDatatypeNode();
                    return null;
                }
            }));
        }
        if (this.datatypeNode.equals(this.lastCompleteNode) && this.completionOffset != this.lastCompleteNode.getOffset()) {
            futures.add(this.pool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ContentAssistContextFactory.this.handleLastCompleteNodeIsAtEndOfDatatypeNode();
                    return null;
                }
            }));
        }
        if (!(this.lastCompleteNode instanceof ILeafNode) || this.lastCompleteNode.getGrammarElement() != null) {
            futures.add(this.pool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ContentAssistContextFactory.this.handleLastCompleteNodeIsPartOfLookahead();
                    return null;
                }
            }));
        }
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Lists.transform(this.contextBuilders, (Function)this).toArray(new ContentAssistContext[this.contextBuilders.size()]);
    }

    protected void initializeFromViewerAndResource(int offset) {
        this.initializeAndAdjustCompletionOffset(offset);
        this.initializeNodeAndModelData();
        this.contextBuilders = Collections.synchronizedList(Lists.newArrayList());
    }

    protected void initializeNodeAndModelData() {
        this.rootNode = this.parseResult.getRootNode();
        if (this.parser instanceof IPartialEditingContentAssistParser) {
            ((IPartialEditingContentAssistParser)this.parser).initializeFor((AbstractRule)this.resource.getEntryPoint());
        }
        this.lastCompleteNode = new LeafNodeFinder(this.completionOffset, true).searchIn((INode)this.rootNode);
        if (this.lastCompleteNode == null) {
            this.lastCompleteNode = this.rootNode;
        }
        this.currentNode = new LeafNodeFinder(this.completionOffset, false).searchIn((INode)this.rootNode);
        if (this.currentNode == null) {
            this.currentNode = this.lastCompleteNode;
        }
        this.lastVisibleNode = this.getLastCompleteNodeByOffset((INode)this.rootNode, this.completionOffset);
        this.datatypeNode = this.getContainingDatatypeRuleNode(this.lastCompleteNode);
        this.currentModel = NodeModelUtils.findActualSemanticObjectFor((INode)this.lastVisibleNode);
    }

    protected void initializeAndAdjustCompletionOffset(int offset) {
        this.completionOffset = offset;
        if (this.selection.getOffset() + this.selection.getLength() == offset) {
            this.completionOffset = this.selection.getOffset();
        }
    }

    protected void handleLastCompleteNodeIsPartOfLookahead() {
        if (!(this.lastCompleteNode instanceof ILeafNode) || !((ILeafNode)this.lastCompleteNode).isHidden()) {
            this.createContextsForLastCompleteNode(this.currentModel, true);
        }
    }

    protected void handleLastCompleteNodeIsAtEndOfDatatypeNode() {
        String prefix = this.getPrefix(this.lastCompleteNode);
        String completeInput = this.getInputToParse(this.lastCompleteNode);
        INode previousNode = this.getLastCompleteNodeByOffset((INode)this.rootNode, this.lastCompleteNode.getOffset());
        EObject previousModel = previousNode.getSemanticElement();
        INode currentDatatypeNode = this.getContainingDatatypeRuleNode(this.currentNode);
        Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput, false);
        int prevSize = this.contextBuilders.size();
        this.doCreateContexts(previousNode, currentDatatypeNode, prefix, previousModel, followElements);
        if (this.lastCompleteNode instanceof ILeafNode && this.lastCompleteNode.getGrammarElement() == null && this.contextBuilders.size() != prevSize) {
            this.handleLastCompleteNodeHasNoGrammarElement(this.contextBuilders.subList(prevSize, this.contextBuilders.size()), previousModel);
        }
    }

    protected String getInputToParse(INode node) {
        return this.getInputToParse(this.document, node.getOffset());
    }

    protected String getInputToParse(String completeInput, int offset) {
        return this.completionPrefixProvider.getInputToParse(completeInput, offset, this.completionOffset);
    }

    protected void handleLastCompleteNodeHasNoGrammarElement(List<ContentAssistContext.Builder> contextBuilderToCheck, EObject previousModel) {
        List newContexts = Lists.transform(contextBuilderToCheck, (Function)this);
        boolean wasValid = this.isLikelyToBeValidProposal(this.lastCompleteNode, newContexts);
        if (!(!wasValid || this.lastCompleteNode instanceof ILeafNode && ((ILeafNode)this.lastCompleteNode).isHidden())) {
            this.createContextsForLastCompleteNode(previousModel, false);
        }
    }

    protected void handleLastCompleteNodeAsPartOfDatatypeNode() {
        String prefix = this.getPrefix(this.datatypeNode);
        String completeInput = this.getInputToParse(this.datatypeNode);
        Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput, false);
        INode lastCompleteNodeBeforeDatatype = this.getLastCompleteNodeByOffset((INode)this.rootNode, this.datatypeNode.getTotalOffset());
        this.doCreateContexts(lastCompleteNodeBeforeDatatype, this.datatypeNode, prefix, this.currentModel, followElements);
    }

    protected boolean isLikelyToBeValidProposal(INode lastCompleteNode, Iterable<ContentAssistContext> contexts) {
        for (ContentAssistContext context : contexts) {
            for (AbstractElement element : context.getFirstSetGrammarElements()) {
                String lastText;
                String keywordValue;
                if (!(element instanceof Keyword) || !(keywordValue = ((Keyword)element).getValue()).equals(lastText = ((ILeafNode)lastCompleteNode).getText())) continue;
                return true;
            }
        }
        return false;
    }

    protected void createContextsForLastCompleteNode(EObject previousModel, boolean strict) {
        String currentNodePrefix = this.getPrefix(this.currentNode);
        if (!Strings.isEmpty((String)currentNodePrefix) && !this.currentNode.getText().equals(currentNodePrefix)) {
            this.lexer.setCharStream((CharStream)new ANTLRStringStream(currentNodePrefix));
            Token token = this.lexer.nextToken();
            if (token == Token.EOF_TOKEN) {
                return;
            }
            while (token != Token.EOF_TOKEN) {
                if (this.isErrorToken(token)) {
                    return;
                }
                token = this.lexer.nextToken();
            }
        }
        String prefix = "";
        String completeInput = this.getInputToParse(this.document, this.completionOffset);
        Collection<FollowElement> followElements = this.parser.getFollowElements(completeInput, strict);
        this.doCreateContexts(this.lastCompleteNode, this.currentNode, prefix, previousModel, followElements);
    }

    protected boolean isErrorToken(Token token) {
        String tokenTypeName = (String)this.tokenDefProvider.getTokenDefMap().get(token.getType());
        return "RULE_ANY_OTHER".equals(tokenTypeName);
    }

    protected void doCreateContexts(INode lastCompleteNode, INode currentNode, String prefix, EObject previousModel, Collection<FollowElement> followElements) {
        LinkedHashSet followElementAsAbstractElements = Sets.newLinkedHashSet();
        this.followElementComputer.computeFollowElements(followElements, followElementAsAbstractElements);
        Multimap<EObject, AbstractElement> contextMap = this.computeCurrentModel(previousModel, lastCompleteNode, followElementAsAbstractElements);
        currentNode = this.getContainingDatatypeRuleNode(currentNode);
        for (Map.Entry entry : contextMap.asMap().entrySet()) {
            ContentAssistContext.Builder contextBuilder = this.doCreateContext(lastCompleteNode, (EObject)entry.getKey(), previousModel, currentNode, prefix);
            for (AbstractElement element : (Collection)entry.getValue()) {
                contextBuilder.accept(element);
            }
            this.contextBuilders.add(contextBuilder);
        }
    }

    protected Multimap<EObject, AbstractElement> computeCurrentModel(EObject currentModel, INode lastCompleteNode, Collection<AbstractElement> followElements) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        ICompositeNode currentParserNode = NodeModelUtils.getNode((EObject)currentModel);
        if (currentParserNode == null) {
            result.putAll((Object)currentModel, followElements);
            return result;
        }
        EObject currentGrammarElement = currentParserNode.getGrammarElement();
        AbstractRule currentRule = this.getRule(currentGrammarElement);
        for (AbstractElement grammarElement : followElements) {
            AbstractRule rule = currentRule;
            ICompositeNode loopParserNode = currentParserNode;
            EObject loopLastGrammarElement = lastCompleteNode.getGrammarElement();
            while (!this.canBeCalledAfter(rule, loopLastGrammarElement, lastCompleteNode.getText(), (EObject)grammarElement) && loopParserNode.getParent() != null) {
                loopLastGrammarElement = loopParserNode.getGrammarElement();
                loopParserNode = loopParserNode.getParent();
                while (loopParserNode.getGrammarElement() == null && loopParserNode.getParent() != null) {
                    loopParserNode = loopParserNode.getParent();
                }
                EObject loopGrammarElement = loopParserNode.getGrammarElement();
                rule = this.getRule(loopGrammarElement);
            }
            EObject context = loopParserNode.getSemanticElement();
            result.put((Object)context, (Object)grammarElement);
        }
        return result;
    }

    public INode getContainingDatatypeRuleNode(INode node) {
        INode result = node;
        EObject grammarElement = result.getGrammarElement();
        if (grammarElement != null) {
            ParserRule parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            while (parserRule != null && GrammarUtil.isDatatypeRule((ParserRule)parserRule)) {
                result = result.getParent();
                grammarElement = result.getGrammarElement();
                parserRule = GrammarUtil.containingParserRule((EObject)grammarElement);
            }
        }
        return result;
    }

    protected int getCompletionOffset() {
        return this.completionOffset;
    }

    public ContentAssistContext.Builder doCreateContext(INode lastCompleteNode, EObject currentModel, EObject previousModel, INode currentNode, String prefix) {
        ContentAssistContext.Builder context = (ContentAssistContext.Builder)this.contentAssistContextProvider.get();
        context.setRootNode(this.rootNode);
        context.setLastCompleteNode(lastCompleteNode);
        context.setCurrentNode(currentNode);
        context.setRootModel(this.parseResult.getRootASTElement());
        context.setCurrentModel(currentModel);
        context.setPreviousModel(previousModel);
        context.setOffset(this.completionOffset);
        context.setPrefix(prefix);
        int regionLength = prefix.length();
        if (this.selection.getLength() > 0) {
            regionLength += this.selection.getLength();
        }
        TextRegion region = new TextRegion(this.completionOffset - prefix.length(), regionLength);
        if (this.selection.getOffset() >= 0 && this.selection.getLength() >= 0) {
            context.setSelectedText(this.document.substring(this.selection.getOffset(), this.selection.getOffset() + this.selection.getLength()));
        }
        context.setReplaceRegion((ITextRegion)region);
        context.setResource(this.resource);
        return context;
    }

    public String getPrefix(INode prefixNode) {
        if (prefixNode instanceof ILeafNode) {
            if (((ILeafNode)prefixNode).isHidden() && prefixNode.getGrammarElement() != null) {
                return "";
            }
            return this.getNodeTextUpToCompletionOffset(prefixNode);
        }
        StringBuilder result = new StringBuilder(prefixNode.getTotalLength());
        this.doComputePrefix((ICompositeNode)prefixNode, result);
        return result.toString();
    }

    public String getNodeTextUpToCompletionOffset(INode currentNode) {
        String nodeText;
        int startOffset = currentNode.getOffset();
        int length = this.completionOffset - startOffset;
        String trimmedNodeText = length > (nodeText = ((ILeafNode)currentNode).getText()).length() ? nodeText : nodeText.substring(0, length);
        try {
            String text = this.document.substring(startOffset, startOffset + trimmedNodeText.length());
            if (trimmedNodeText.equals(text)) {
                return text;
            }
            return this.document.substring(startOffset, startOffset + length);
        }
        catch (IndexOutOfBoundsException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return trimmedNodeText;
        }
    }

    public boolean doComputePrefix(ICompositeNode node, StringBuilder result) {
        ArrayList hiddens = Lists.newArrayListWithCapacity((int)2);
        for (INode child : node.getChildren()) {
            if (child instanceof ICompositeNode) {
                if (this.doComputePrefix((ICompositeNode)child, result)) continue;
                return false;
            }
            ILeafNode leaf = (ILeafNode)child;
            ITextRegion leafRegion = leaf.getTextRegion();
            if (leafRegion.getOffset() > this.completionOffset) {
                return false;
            }
            if (leaf.isHidden()) {
                if (result.length() == 0) continue;
                hiddens.add((ILeafNode)child);
                continue;
            }
            Iterator iter = hiddens.iterator();
            while (iter.hasNext()) {
                result.append(((ILeafNode)iter.next()).getText());
            }
            hiddens.clear();
            result.append(this.getNodeTextUpToCompletionOffset((INode)leaf));
            if (leafRegion.getOffset() + leafRegion.getLength() <= this.completionOffset) continue;
            return false;
        }
        return true;
    }

    public void setParser(IContentAssistParser parser) {
        this.parser = parser;
    }

    public IContentAssistParser getParser() {
        return this.parser;
    }

    protected boolean canBeCalledAfter(AbstractRule rule, EObject previousGrammarElement, String previousText, EObject nextGrammarElement) {
        Boolean result = (Boolean)this.createCallHierachyHelper(previousGrammarElement, previousText, nextGrammarElement).doSwitch((EObject)rule);
        return result;
    }

    protected CallHierarchyHelper createCallHierachyHelper(EObject previousGrammarElement, String previousText, EObject nextGrammarElement) {
        return new CallHierarchyHelper(nextGrammarElement, previousText, previousGrammarElement);
    }

    protected AbstractRule getRule(EObject currentGrammarElement) {
        AbstractRule rule = null;
        if (currentGrammarElement instanceof RuleCall) {
            rule = ((RuleCall)currentGrammarElement).getRule();
        }
        if (currentGrammarElement instanceof AbstractRule) {
            rule = (AbstractRule)currentGrammarElement;
        }
        if (currentGrammarElement instanceof Action) {
            rule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)currentGrammarElement, AbstractRule.class);
        }
        if (rule == null) {
            throw new IllegalStateException();
        }
        return rule;
    }

    protected INode getLastCompleteNodeByOffset(INode node, int offsetPosition) {
        return this.completionPrefixProvider.getLastCompleteNodeByOffset(node, offsetPosition, this.completionOffset);
    }
}

