/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.util.AllSuperTypeRefsCollector;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeExtensions;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.AbstractJudgment;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.StructuralTypingResult;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

final class SubtypeJudgment
extends AbstractJudgment {
    SubtypeJudgment() {
    }

    public Result apply(RuleEnvironment G, TypeArgument left, TypeArgument right) {
        Result result = this.doApply(G, left, right);
        if (result.isFailure()) {
            String leftMsg = left != null ? left.getTypeRefAsString() : "<null>";
            String rightMsg = right != null ? right.getTypeRefAsString() : "<null>";
            return result.setDefaultFailureMessage(String.valueOf(leftMsg) + " is not a subtype of " + rightMsg);
        }
        return result;
    }

    private Result doApply(RuleEnvironment G, TypeArgument leftArg, TypeArgument rightArg) {
        TypeRef right;
        TypeRef left = leftArg instanceof Wildcard ? this.ts.upperBound(G, leftArg) : (TypeRef)leftArg;
        TypeRef typeRef = right = rightArg instanceof Wildcard ? this.ts.lowerBound(G, rightArg) : (TypeRef)rightArg;
        if (left == null || right == null) {
            return this.failure(new Result[0]);
        }
        if (left instanceof UnionTypeExpression) {
            return this.applyUnion_Left(G, (UnionTypeExpression)left, right);
        }
        if (right instanceof IntersectionTypeExpression) {
            return this.applyIntersection_Right(G, left, (IntersectionTypeExpression)right);
        }
        if (left instanceof IntersectionTypeExpression) {
            return this.applyIntersection_Left(G, (IntersectionTypeExpression)left, right);
        }
        if (right instanceof UnionTypeExpression) {
            return this.applyUnion_Right(G, left, (UnionTypeExpression)right);
        }
        if (left instanceof UnknownTypeRef || right instanceof UnknownTypeRef) {
            return this.success();
        }
        boolean leftIsVoid = TypeUtils.isVoid((TypeArgument)left);
        boolean rightIsVoid = TypeUtils.isVoid((TypeArgument)right);
        if (leftIsVoid || rightIsVoid) {
            return this.resultFromBoolean(leftIsVoid && rightIsVoid);
        }
        if (left.isBottomType() || right.isTopType()) {
            return this.success();
        }
        if (TypeUtils.isNull((TypeArgument)left) && !TypeUtils.isUndefined((TypeArgument)right)) {
            return this.success();
        }
        if (left instanceof ExistentialTypeRef) {
            return this.applyExistentialTypeRef_Left(G, (ExistentialTypeRef)left, (TypeArgument)right);
        }
        if (right instanceof ExistentialTypeRef) {
            return this.applyExistentialTypeRef_Right(G, (TypeArgument)left, (ExistentialTypeRef)right);
        }
        if (left instanceof BoundThisTypeRef) {
            if (right instanceof BoundThisTypeRef) {
                return this.applyBoundThisTypeRef_Both(G, (BoundThisTypeRef)left, (BoundThisTypeRef)right);
            }
            return this.applyBoundThisTypeRef_Left(G, (BoundThisTypeRef)left, (TypeArgument)right);
        }
        if (right instanceof BoundThisTypeRef) {
            return this.applyBoundThisTypeRef_Right(G, (TypeArgument)left, (BoundThisTypeRef)right);
        }
        if (left instanceof TypeTypeRef) {
            if (right instanceof TypeTypeRef) {
                return this.applyTypeTypeRef(G, (TypeTypeRef)left, (TypeTypeRef)right);
            }
            return this.resultFromBoolean(RuleEnvironmentExtensions.isObject(G, (TypeArgument)right) || RuleEnvironmentExtensions.isFunction(G, (TypeArgument)right) && ((TypeTypeRef)left).isConstructorRef());
        }
        if (left instanceof FunctionTypeExprOrRef) {
            if (right instanceof FunctionTypeExprOrRef) {
                return this.applyFunctionTypeExprOrRef(G, (FunctionTypeExprOrRef)left, (FunctionTypeExprOrRef)right);
            }
            if (right instanceof ParameterizedTypeRef && right.getDeclaredType() instanceof TFunction) {
                FunctionTypeRef rightFixed = (FunctionTypeRef)TypeUtils.createTypeRef((Type)right.getDeclaredType(), (TypeArgument[])new TypeArgument[0]);
                TypeUtils.copyTypeModifiers((TypeRef)rightFixed, (TypeRef)right);
                return this.applyFunctionTypeExprOrRef(G, (FunctionTypeExprOrRef)left, (FunctionTypeExprOrRef)rightFixed);
            }
            return this.resultFromBoolean(RuleEnvironmentExtensions.isObject(G, (TypeArgument)right) || RuleEnvironmentExtensions.isFunction(G, (TypeArgument)right));
        }
        if (left instanceof ParameterizedTypeRef && right instanceof ParameterizedTypeRef) {
            return this.applyParameterizedTypeRef(G, (ParameterizedTypeRef)left, (ParameterizedTypeRef)right);
        }
        return this.failure(new Result[0]);
    }

    private Result applyUnion_Left(RuleEnvironment G, UnionTypeExpression U, TypeRef S) {
        return this.requireAllSuccess(U.getTypeRefs().stream().map(T -> this.ts.subtype(G, (TypeArgument)T, (TypeArgument)S))).trimCauses();
    }

    private Result applyUnion_Right(RuleEnvironment G, TypeRef S, UnionTypeExpression U) {
        return this.requireExistsSuccess(U.getTypeRefs().stream().map(T -> this.ts.subtype(G, (TypeArgument)S, (TypeArgument)T))).trimCauses();
    }

    private Result applyIntersection_Left(RuleEnvironment G, IntersectionTypeExpression I, TypeRef S) {
        return this.requireExistsSuccess(I.getTypeRefs().stream().map(T -> this.ts.subtype(G, (TypeArgument)T, (TypeArgument)S))).trimCauses();
    }

    private Result applyIntersection_Right(RuleEnvironment G, TypeRef S, IntersectionTypeExpression I) {
        return this.requireAllSuccess(I.getTypeRefs().stream().map(T -> this.ts.subtype(G, (TypeArgument)S, (TypeArgument)T))).trimCauses();
    }

    private Result applyParameterizedTypeRef(RuleEnvironment G, ParameterizedTypeRef leftOriginal, ParameterizedTypeRef rightOriginal) {
        Pair guardKey;
        Boolean guard;
        TypeRef left = RuleEnvironmentExtensions.getReplacement(G, (TypeRef)leftOriginal);
        TypeRef right = RuleEnvironmentExtensions.getReplacement(G, (TypeRef)rightOriginal);
        Type leftDeclType = left.getDeclaredType();
        Type rightDeclType = right.getDeclaredType();
        if (leftDeclType == null || rightDeclType == null) {
            return this.success();
        }
        if (leftDeclType.eIsProxy() || rightDeclType.eIsProxy()) {
            return this.success();
        }
        if (leftDeclType == RuleEnvironmentExtensions.intType(G) && rightDeclType == RuleEnvironmentExtensions.numberType(G) || leftDeclType == RuleEnvironmentExtensions.numberType(G) && rightDeclType == RuleEnvironmentExtensions.intType(G)) {
            return this.success();
        }
        if (leftDeclType instanceof TEnum && (rightDeclType == RuleEnvironmentExtensions.n4EnumType(G) || rightDeclType == RuleEnvironmentExtensions.objectType(G))) {
            return this.resultFromBoolean(!AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)leftDeclType));
        }
        if (leftDeclType instanceof TEnum && (rightDeclType == RuleEnvironmentExtensions.n4StringBasedEnumType(G) || rightDeclType == RuleEnvironmentExtensions.stringType(G) || rightDeclType == RuleEnvironmentExtensions.stringObjectType(G))) {
            return this.resultFromBoolean(AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)leftDeclType));
        }
        if (leftDeclType == RuleEnvironmentExtensions.n4StringBasedEnumType(G) && (rightDeclType == RuleEnvironmentExtensions.stringType(G) || rightDeclType == RuleEnvironmentExtensions.stringObjectType(G))) {
            return this.success();
        }
        if (leftDeclType instanceof PrimitiveType && ((PrimitiveType)leftDeclType).getAssignmentCompatible() == rightDeclType) {
            return this.success();
        }
        if (rightDeclType instanceof PrimitiveType && leftDeclType == ((PrimitiveType)rightDeclType).getAssignmentCompatible()) {
            return this.success();
        }
        if (leftDeclType instanceof TInterface && !(rightDeclType instanceof TInterface) && right.getTypingStrategy() == TypingStrategy.NOMINAL && rightDeclType != RuleEnvironmentExtensions.n4ObjectType(G) && rightDeclType != RuleEnvironmentExtensions.objectType(G) && rightDeclType != RuleEnvironmentExtensions.anyType(G)) {
            return this.failure(new Result[0]);
        }
        boolean structuralTyping = false;
        if (right.isUseSiteStructuralTyping()) {
            StructuralTypingResult result = this.typeSystemHelper.isStructuralSubtype(G, left, right);
            if (!result.isValue()) {
                return this.failure(result.message, new Result[0]);
            }
            structuralTyping = true;
        } else if (right.isDefSiteStructuralTyping() && ((guard = (Boolean)G.get(guardKey = Pair.of((Object)"subtypeRefParameterizedTypeRef__struct", (Object)Pair.of((Object)left, (Object)right)))) == null || !guard.booleanValue())) {
            StructuralTypingResult result = this.typeSystemHelper.isStructuralSubtype(G, left, right);
            if (!result.isValue()) {
                RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
                G2.put(guardKey, Boolean.TRUE);
                if (result.isN4ObjectOnLeftWithDefSite() && this.ts.subtype(G2, (TypeArgument)left, (TypeArgument)right).isSuccess()) {
                    structuralTyping = true;
                } else {
                    return this.failure(result.message, new Result[0]);
                }
            }
            structuralTyping = result.isValue();
        }
        if (structuralTyping) {
            return this.success();
        }
        if (!(!left.isUseSiteStructuralTyping() && !left.isDefSiteStructuralTyping() || rightDeclType == RuleEnvironmentExtensions.objectType(G) && leftDeclType instanceof TClassifier || leftDeclType instanceof PrimitiveType)) {
            return this.failure("Structural type " + left.getTypeRefAsString() + " is not a subtype of non-structural type " + right.getTypeRefAsString(), new Result[0]);
        }
        if (leftDeclType instanceof TypeVariable || rightDeclType instanceof TypeVariable) {
            if (leftDeclType == rightDeclType) {
                return this.success();
            }
            if (leftDeclType instanceof TypeVariable) {
                TypeRef declUB = ((TypeVariable)leftDeclType).getDeclaredUpperBound();
                TypeRef ub = declUB != null ? declUB : N4JSLanguageUtils.getTypeVariableImplicitUpperBound(G);
                return this.requireAllSuccess(this.ts.subtype(G, (TypeArgument)ub, (TypeArgument)right));
            }
            return this.failure(new Result[0]);
        }
        if (leftDeclType == rightDeclType) {
            EList leftArgs = left.getTypeArgs();
            EList rightArgs = right.getTypeArgs();
            int leftArgsCount = leftArgs.size();
            int rightArgsCount = rightArgs.size();
            if (leftArgsCount > 0 && leftArgsCount <= rightArgsCount) {
                int len = Math.min(Math.min(leftArgsCount, rightArgsCount), rightDeclType.getTypeVars().size());
                int i = 0;
                while (i < len) {
                    RuleEnvironment G2;
                    TypeArgument leftArg = (TypeArgument)left.getTypeArgs().get(i);
                    TypeArgument rightArg = (TypeArgument)right.getTypeArgs().get(i);
                    Variance variance = rightDeclType.getVarianceOfTypeVar(i);
                    TypeRef leftArgUpper = this.ts.upperBound(G, leftArg);
                    TypeRef leftArgLower = this.ts.lowerBound(G, leftArg);
                    TypeRef rightArgUpper = this.ts.upperBound(G, rightArg);
                    TypeRef rightArgLower = this.ts.lowerBound(G, rightArg);
                    if (rightArg instanceof Wildcard && ((Wildcard)rightArg).isImplicitUpperBoundInEffect()) {
                        boolean isGuarded;
                        Pair guardKey2 = Pair.of((Object)"subtypeRefParameterizedTypeRef__args", (Object)rightArg);
                        boolean bl = isGuarded = G.get(guardKey2) != null;
                        if (!isGuarded) {
                            G2 = RuleEnvironmentExtensions.wrap(G);
                            G2.put(guardKey2, Boolean.TRUE);
                        } else {
                            rightArgUpper = RuleEnvironmentExtensions.topTypeRef(G);
                            G2 = G;
                        }
                    } else {
                        G2 = G;
                    }
                    Result tempResult = this.success();
                    if (variance != Variance.CONTRA) {
                        tempResult = this.ts.subtype(G2, (TypeArgument)leftArgUpper, (TypeArgument)rightArgUpper);
                    }
                    if (variance != Variance.CO && tempResult.isSuccess()) {
                        tempResult = this.ts.subtype(G2, (TypeArgument)rightArgLower, (TypeArgument)leftArgLower);
                    }
                    if (tempResult.isFailure()) {
                        if (tempResult.isOrIsCausedByPriority()) {
                            return this.failure(String.valueOf(left.getTypeRefAsString()) + " is not a subtype of " + right.getTypeRefAsString() + " due to incompatible type arguments: " + tempResult.getPriorityFailureMessage(), new Result[0]);
                        }
                        return this.failure(new Result[0]);
                    }
                    ++i;
                }
                return this.success();
            }
            return this.success();
        }
        List allSuperTypeRefs = leftDeclType instanceof ContainerType ? AllSuperTypeRefsCollector.collect((ContainerType)((ContainerType)leftDeclType)) : CollectionLiterals.newArrayList();
        Iterable superTypeRefs = IterableExtensions.operator_plus((Iterable)allSuperTypeRefs, RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, left));
        if (Iterables.any((Iterable)superTypeRefs, str -> str.getDeclaredType() == rightDeclType)) {
            RuleEnvironment localG_left = RuleEnvironmentExtensions.wrap(G);
            this.typeSystemHelper.addSubstitutions(localG_left, left);
            TypeArgument[] syntheticTypeArgs = (TypeArgument[])rightDeclType.getTypeVars().stream().map(tv -> TypeExtensions.ref((Type)tv, (TypeArgument[])new TypeArgument[0])).toArray(TypeArgument[]::new);
            TypeRef syntheticTypeRef = TypeExtensions.ref((Type)rightDeclType, (TypeArgument[])syntheticTypeArgs);
            TypeRef effectiveSuperTypeRef = this.ts.substTypeVariables(localG_left, syntheticTypeRef);
            return this.requireAllSuccess(this.ts.subtype(G, (TypeArgument)effectiveSuperTypeRef, (TypeArgument)right));
        }
        return this.failure(new Result[0]);
    }

    private Result applyFunctionTypeExprOrRef(RuleEnvironment G, FunctionTypeExprOrRef left, FunctionTypeExprOrRef right) {
        return this.resultFromBoolean(this.typeSystemHelper.isSubtypeFunction(G, left, right));
    }

    private Result applyTypeTypeRef(RuleEnvironment G, TypeTypeRef left, TypeTypeRef right) {
        TypeArgument leftTypeArg = left.getTypeArg();
        TypeArgument rightTypeArg = right.getTypeArg();
        boolean leftIsCtorRef = left.isConstructorRef();
        boolean rightIsCtorRef = right.isConstructorRef();
        boolean rightHasTypeRef = rightTypeArg instanceof TypeRef;
        if (!leftIsCtorRef && rightIsCtorRef) {
            return this.failure(new Result[0]);
        }
        if (rightHasTypeRef && !rightIsCtorRef) {
            return this.requireAllSuccess(this.ts.subtype(G, leftTypeArg, rightTypeArg));
        }
        if (rightHasTypeRef && rightIsCtorRef) {
            Result result;
            boolean leftHasCovariantConstructor;
            Type left_staticType = this.typeSystemHelper.getStaticType(G, left);
            Type right_staticType = this.typeSystemHelper.getStaticType(G, right);
            if (left_staticType == null || left_staticType.eIsProxy() || right_staticType == null || right_staticType.eIsProxy()) {
                return this.failure(new Result[0]);
            }
            boolean bl = leftHasCovariantConstructor = left_staticType instanceof TClassifier && N4JSLanguageUtils.hasCovariantConstructor((TClassifier)left_staticType);
            if (!leftHasCovariantConstructor) {
                boolean hasDisallowedArg;
                boolean bl2 = hasDisallowedArg = leftTypeArg instanceof Wildcard || leftTypeArg instanceof ExistentialTypeRef || leftTypeArg instanceof ThisTypeRef;
                if (hasDisallowedArg) {
                    return this.failure(new Result[0]);
                }
            }
            if (!(result = this.ts.subtype(G, leftTypeArg, rightTypeArg)).isSuccess()) {
                return this.failure(result);
            }
            if (left_staticType instanceof TypeVariable || right_staticType instanceof TypeVariable) {
                return this.resultFromBoolean(left_staticType == right_staticType);
            }
            TMethod leftCtor = this.containerTypesHelper.fromContext(RuleEnvironmentExtensions.getContextResource(G)).findConstructor((ContainerType)left_staticType);
            TMethod rightCtor = this.containerTypesHelper.fromContext(RuleEnvironmentExtensions.getContextResource(G)).findConstructor((ContainerType)right_staticType);
            if (leftCtor == null || rightCtor == null) {
                return this.failure(new Result[0]);
            }
            TypeRef leftCtorRef = this.ts.type(G, (TypableElement)leftCtor);
            TypeRef rightCtorRef = this.ts.type(G, (TypableElement)rightCtor);
            RuleEnvironment G_left = RuleEnvironmentExtensions.wrap(G);
            RuleEnvironment G_right = RuleEnvironmentExtensions.wrap(G);
            this.typeSystemHelper.addSubstitutions(G_left, TypeExtensions.ref((Type)left_staticType, (TypeArgument[])new TypeArgument[0]));
            RuleEnvironmentExtensions.addThisType(G_left, TypeExtensions.ref((Type)left_staticType, (TypeArgument[])new TypeArgument[0]));
            this.typeSystemHelper.addSubstitutions(G_right, TypeExtensions.ref((Type)right_staticType, (TypeArgument[])new TypeArgument[0]));
            RuleEnvironmentExtensions.addThisType(G_right, TypeExtensions.ref((Type)right_staticType, (TypeArgument[])new TypeArgument[0]));
            TypeRef leftCtorRefSubst = this.ts.substTypeVariables(G_left, leftCtorRef);
            TypeRef rightCtorRefSubst = this.ts.substTypeVariables(G_right, rightCtorRef);
            return this.requireAllSuccess(this.ts.subtype(G, (TypeArgument)leftCtorRefSubst, (TypeArgument)rightCtorRefSubst));
        }
        TypeRef upperBoundLeft = this.ts.upperBound(G, leftTypeArg);
        TypeRef lowerBoundLeft = this.ts.lowerBound(G, leftTypeArg);
        TypeRef upperBoundRight = this.ts.upperBound(G, rightTypeArg);
        TypeRef lowerBoundRight = this.ts.lowerBound(G, rightTypeArg);
        return this.requireAllSuccess(this.ts.subtype(G, (TypeArgument)upperBoundLeft, (TypeArgument)upperBoundRight), this.ts.subtype(G, (TypeArgument)lowerBoundRight, (TypeArgument)lowerBoundLeft));
    }

    private Result applyExistentialTypeRef_Left(RuleEnvironment G, ExistentialTypeRef existentialTypeRef, TypeArgument right) {
        if (RuleEnvironmentExtensions.isExistentialTypeToBeReopened(G, existentialTypeRef)) {
            Wildcard wildThing = existentialTypeRef.getWildcard();
            TypeRef upperBound = this.ts.upperBound(G, (TypeArgument)wildThing);
            TypeRef lowerBound = this.ts.lowerBound(G, (TypeArgument)wildThing);
            return this.requireAllSuccess(this.ts.subtype(G, right, (TypeArgument)upperBound), this.ts.subtype(G, (TypeArgument)lowerBound, right));
        }
        if (existentialTypeRef == right) {
            return this.success();
        }
        TypeRef upperExt = this.ts.upperBound(G, (TypeArgument)existentialTypeRef);
        return this.requireAllSuccess(this.ts.subtype(G, (TypeArgument)upperExt, right));
    }

    private Result applyExistentialTypeRef_Right(RuleEnvironment G, TypeArgument left, ExistentialTypeRef existentialTypeRef) {
        if (RuleEnvironmentExtensions.isExistentialTypeToBeReopened(G, existentialTypeRef)) {
            Wildcard wildThing = existentialTypeRef.getWildcard();
            TypeRef upperBound = this.ts.upperBound(G, (TypeArgument)wildThing);
            TypeRef lowerBound = this.ts.lowerBound(G, (TypeArgument)wildThing);
            return this.requireAllSuccess(this.ts.subtype(G, left, (TypeArgument)upperBound), this.ts.subtype(G, (TypeArgument)lowerBound, left));
        }
        if (left == existentialTypeRef) {
            return this.success();
        }
        TypeRef lowerExt = this.ts.lowerBound(G, (TypeArgument)existentialTypeRef);
        return this.requireAllSuccess(this.ts.subtype(G, left, (TypeArgument)lowerExt));
    }

    private Result applyBoundThisTypeRef_Both(RuleEnvironment G, BoundThisTypeRef left, BoundThisTypeRef right) {
        if (right.isUseSiteStructuralTyping()) {
            StructuralTypingResult result = this.typeSystemHelper.isStructuralSubtype(G, (TypeRef)left, (TypeRef)right);
            if (!result.isValue()) {
                return this.failure(result.message, new Result[0]);
            }
            return this.success();
        }
        if (left.isUseSiteStructuralTyping() != right.isUseSiteStructuralTyping()) {
            return this.failure(new Result[0]);
        }
        return this.requireAllSuccess(this.ts.subtype(G, (TypeArgument)left.getActualThisTypeRef(), (TypeArgument)right.getActualThisTypeRef()));
    }

    private Result applyBoundThisTypeRef_Left(RuleEnvironment G, BoundThisTypeRef boundThisTypeRef, TypeArgument right) {
        if (boundThisTypeRef == right) {
            return this.success();
        }
        TypeRef upperExt = this.ts.upperBound(G, (TypeArgument)boundThisTypeRef);
        return this.requireAllSuccess(this.ts.subtype(G, (TypeArgument)upperExt, right));
    }

    private Result applyBoundThisTypeRef_Right(RuleEnvironment G, TypeArgument left, BoundThisTypeRef boundThisTypeRef) {
        if (left == boundThisTypeRef) {
            return this.success();
        }
        Type leftType = left.getDeclaredType();
        if (leftType == RuleEnvironmentExtensions.undefinedType(G) || leftType == RuleEnvironmentExtensions.nullType(G)) {
            return this.success();
        }
        if (boundThisTypeRef.isUseSiteStructuralTyping() || boundThisTypeRef.getActualThisTypeRef() != null && boundThisTypeRef.getActualThisTypeRef().getDeclaredType() != null && boundThisTypeRef.getActualThisTypeRef().getDeclaredType().isFinal()) {
            ParameterizedTypeRef resolvedTypeRef = TypeUtils.createResolvedThisTypeRef((BoundThisTypeRef)boundThisTypeRef);
            return this.ts.subtype(G, left, (TypeArgument)resolvedTypeRef);
        }
        return this.failure(new Result[0]);
    }

    private Result resultFromBoolean(boolean result) {
        return result ? this.success() : this.failure(new Result[0]);
    }

    private Result requireAllSuccess(Result ... results) {
        if (results == null || results.length == 0) {
            throw new IllegalArgumentException("no results given");
        }
        return this.requireAllSuccess(Stream.of(results));
    }

    private Result requireAllSuccess(Stream<Result> results) {
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            Result result = (Result)iter.next();
            if (result.isSuccess()) continue;
            return this.failure(result);
        }
        return this.success();
    }

    private Result requireExistsSuccess(Stream<Result> results) {
        Iterator iter = results.iterator();
        Result firstFailure = null;
        while (iter.hasNext()) {
            Result result = (Result)iter.next();
            if (result.isSuccess()) {
                return this.success();
            }
            if (firstFailure != null) continue;
            firstFailure = result;
        }
        return firstFailure != null ? this.failure(firstFailure) : this.failure(new Result[0]);
    }

    private Result success() {
        return Result.success();
    }

    private Result failure(Result ... results) {
        return this.failure((String)null, results);
    }

    private Result failure(String failureMessage, Result ... results) {
        Result firstFailure = Stream.of(results).filter(Result::isFailure).findFirst().orElse(null);
        return Result.failure(failureMessage, failureMessage != null, firstFailure);
    }
}

