/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.utils.RecursionGuard;

public class SuperInterfacesIterable
implements Iterable<TInterface> {
    private final TClassifier root;
    private final boolean ignoreSuperClassInterfaces;

    public static SuperInterfacesIterable of(TClassifier classifier) {
        return new SuperInterfacesIterable(classifier);
    }

    public static SuperInterfacesIterable ofThisOnly(TClass clazz) {
        return new SuperInterfacesIterable(clazz, true);
    }

    protected SuperInterfacesIterable(TClassifier root) {
        this.root = root;
        this.ignoreSuperClassInterfaces = false;
    }

    protected SuperInterfacesIterable(TClass root, boolean ignoreSuperClassInterfaces) {
        this.root = root;
        this.ignoreSuperClassInterfaces = ignoreSuperClassInterfaces;
    }

    public SuperInterfacesIterator iterator() {
        if (this.root instanceof TInterface) {
            return new SuperInterfacesIterator((TInterface)this.root);
        }
        if (this.ignoreSuperClassInterfaces && this.root != null) {
            return new SuperInterfacesIterator((Iterable<ParameterizedTypeRef>)((TClass)this.root).getImplementedInterfaceRefs());
        }
        return new SuperInterfacesIterator((TClass)this.root);
    }

    @Override
    public Spliterator<TInterface> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 257);
    }

    public TClass findClassImplementingInterface(TInterface ifc) {
        SuperInterfacesIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != ifc) continue;
            return iter.getImplementingClass();
        }
        return null;
    }

    static class SuperInterfacesIterator
    implements Iterator<TInterface> {
        private TClass currClass = null;
        private TClass currClassAtLastNextInvocation = null;
        private TInterface next = null;
        private final RecursionGuard<TClassifier> guard = new RecursionGuard();
        private Iterator<ParameterizedTypeRef> currIter;
        private final List<Iterator<ParameterizedTypeRef>> queuedIters = new ArrayList<Iterator<ParameterizedTypeRef>>();

        SuperInterfacesIterator(TClass rootClass) {
            this.currClass = rootClass;
            if (this.currClass != null) {
                this.guard.tryNext((Object)this.currClass);
                this.queuedIters.add(this.currClass.getImplementedInterfaceRefs().iterator());
                this.next = this.retrieveNext();
            }
        }

        SuperInterfacesIterator(TInterface rootRole) {
            this.guard.tryNext((Object)rootRole);
            this.queuedIters.add(rootRole.getSuperInterfaceRefs().iterator());
            this.next = this.retrieveNext();
        }

        SuperInterfacesIterator(Iterable<ParameterizedTypeRef> rootInterfaces) {
            this.queuedIters.add(rootInterfaces.iterator());
            this.next = this.retrieveNext();
        }

        /*
         * Unable to fully structure code
         */
        private TInterface retrieveNext() {
            block0: while (true) {
                if (this.currIter == null || !this.currIter.hasNext()) {
                    if (!this.queuedIters.isEmpty()) {
                        this.currIter = this.queuedIters.remove(this.queuedIters.size() - 1);
                        continue;
                    }
                    if (this.currClass != null) {
                        superType = this.currClass.getSuperClassRef();
                        superClass = superType != null && superType.getDeclaredType() instanceof TClassifier != false ? (TClassifier)superType.getDeclaredType() : null;
                        if (superClass instanceof TClass && this.guard.tryNext((Object)superClass)) {
                            this.currClass = (TClass)superClass;
                            this.queuedIters.add(this.currClass.getImplementedInterfaceRefs().iterator());
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                do {
                    if (this.currIter.hasNext()) ** break;
                    continue block0;
                    typeRef = this.currIter.next();
                    v0 = type = typeRef != null && typeRef.eIsProxy() == false ? typeRef.getDeclaredType() : null;
                } while (!(type instanceof TInterface) || type.eIsProxy() || !this.guard.tryNext((Object)(ifc = (TInterface)type)));
                break;
            }
            this.queuedIters.add(ifc.getSuperInterfaceRefs().iterator());
            return ifc;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public TInterface next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            TInterface returnNext = this.next;
            this.currClassAtLastNextInvocation = this.currClass;
            this.next = this.retrieveNext();
            return returnNext;
        }

        public TClass getImplementingClass() {
            return this.currClassAtLastNextInvocation;
        }
    }
}

