/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.external.ExternalLibraryUriHelper;
import org.eclipse.n4js.generator.CompilerDescriptor;
import org.eclipse.n4js.generator.ICompositeGenerator;
import org.eclipse.n4js.generator.ISubGenerator;
import org.eclipse.n4js.generator.SubGeneratorRegistry;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.xtext.generator.IFileSystemAccess;

@Singleton
public class N4JSCompositeGenerator
implements ICompositeGenerator {
    private static final Logger LOGGER = Logger.getLogger(N4JSCompositeGenerator.class);
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ExternalLibraryUriHelper externalLibraryUriHelper;
    @Inject
    private SubGeneratorRegistry subGeneratorRegistry;
    @Inject
    private XpectAwareFileExtensionCalculator xpectAwareFileExtensionCalculator;

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        if (this.isApplicableTo(input)) {
            String fileExtension = this.xpectAwareFileExtensionCalculator.getXpectAwareFileExtension(input.getURI());
            for (ISubGenerator subgenerator : this.getSubGenerators(fileExtension)) {
                subgenerator.doGenerate(input, fsa);
            }
        }
    }

    @Override
    public Set<CompilerDescriptor> getCompilerDescriptors() {
        HashSet<CompilerDescriptor> descriptors = new HashSet<CompilerDescriptor>();
        this.getSubGenerators().stream().forEachOrdered(subGenerator -> descriptors.add(subGenerator.getCompilerDescriptor()));
        return descriptors;
    }

    @Override
    public boolean isApplicableTo(Resource input) {
        if (this.externalLibraryUriHelper.isExternalLocation(input.getURI())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info((Object)("Skipped generation for external resource: " + input.getURI()));
            }
            return false;
        }
        Optional<? extends IN4JSSourceContainer> n4jsContainer = this.n4jsCore.findN4JSSourceContainer(input.getURI());
        return n4jsContainer.isPresent();
    }

    @Override
    public Collection<ISubGenerator> getSubGenerators() {
        return this.subGeneratorRegistry.getGenerators();
    }

    @Override
    public Collection<ISubGenerator> getSubGenerators(String fileExtension) {
        return this.subGeneratorRegistry.getGenerators(fileExtension);
    }
}

