/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.N4JSLanguageConstants;
import org.eclipse.n4js.conversion.AbstractN4JSStringValueConverter;
import org.eclipse.n4js.n4JS.AbstractCaseClause;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.ArrayBindingPattern;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AssignmentOperator;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FieldAccessor;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IterationStatement;
import org.eclipse.n4js.n4JS.LabelRef;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.LegacyOctalIntLiteral;
import org.eclipse.n4js.n4JS.Literal;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.MethodDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4FieldAccessor;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NewTarget;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PostfixOperator;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertyNameValuePairSingleName;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.StrictModeRelevant;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.Variable;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.n4JS.WithStatement;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.N4JSLanguageHelper;
import org.eclipse.n4js.validation.ASTStructureDiagnosticProducer;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.helper.FunctionValidationHelper;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class ASTStructureValidator {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private N4JSLanguageHelper languageHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void validate(EObject model, IDiagnosticConsumer consumer) {
        boolean _isNoValidate;
        boolean _not;
        boolean _tripleNotEquals;
        boolean _and = false;
        Resource _eResource = null;
        if (model != null) {
            _eResource = model.eResource();
        }
        boolean bl = _tripleNotEquals = _eResource != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isNoValidate = this.n4jsCore.isNoValidate(model.eResource().getURI())));
        if (_and) {
            ASTStructureDiagnosticProducer producer = new ASTStructureDiagnosticProducer(consumer);
            HashSet _newHashSetWithExpectedSize = Sets.newHashSetWithExpectedSize((int)2);
            boolean _isN4JSMode = this.jsVariantHelper.isN4JSMode(model);
            boolean _isExternalMode = this.jsVariantHelper.isExternalMode(model);
            Constraints _constraints = new Constraints(_isN4JSMode, _isExternalMode);
            this.validateASTStructure(model, producer, _newHashSetWithExpectedSize, _constraints);
        }
    }

    private void recursiveValidateASTStructure(EObject model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        Iterator content = model.eContents().iterator();
        boolean newStrict = constraints.isStrict();
        boolean first = true;
        while (content.hasNext()) {
            EObject next = (EObject)content.next();
            newStrict = newStrict || first && this.isUseStrictProlog(model, next);
            boolean bl = first = first && this.isProlog(next);
            if (next instanceof StrictModeRelevant) {
                ((StrictModeRelevant)next).setStrictMode(newStrict);
            }
            this.validateASTStructure(next, producer, validLabels, constraints.strict(newStrict));
        }
    }

    private boolean isProlog(EObject object) {
        if (object instanceof ExpressionStatement) {
            Expression _expression = ((ExpressionStatement)object).getExpression();
            return _expression instanceof StringLiteral;
        }
        return false;
    }

    private boolean isUseStrictProlog(EObject model, EObject next) {
        if (model instanceof Script || model instanceof Block && model.eContainer() instanceof FunctionDefinition) {
            boolean _matched = false;
            if (next instanceof ExpressionStatement) {
                Expression _expression;
                _matched = true;
                Expression it = _expression = ((ExpressionStatement)next).getExpression();
                boolean _matched_1 = false;
                if (it instanceof StringLiteral) {
                    _matched_1 = true;
                    String _value = ((StringLiteral)it).getValue();
                    return Objects.equal((Object)"use strict", (Object)_value);
                }
            }
        }
        return false;
    }

    private void _validateASTStructure(EObject model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure(model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(Script model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.strict(false).allowNestedFunctions(true).allowReturn(false).allowContinue(false).allowBreak(false));
    }

    private void _validateASTStructure(ExportDeclaration model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _isDefaultExport = model.isDefaultExport();
        if (_isDefaultExport) {
            ExportableElement exportedElement = model.getExportedElement();
            boolean cfr_ignored_0 = exportedElement instanceof VariableStatement;
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(N4ClassifierDefinition model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        if (model instanceof N4ClassifierDeclaration && ((N4ClassifierDeclaration)model).getName() == null && !((N4ClassifierDeclaration)model).isExportedAsDefault()) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_TYPE_DECL_MISSING_NAME = IssueCodes.getMessageForAST_TYPE_DECL_MISSING_NAME();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_TYPE_DECL_MISSING_NAME");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_TYPE_DECL_MISSING_NAME, _defaultSeverity, "AST_TYPE_DECL_MISSING_NAME", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.strict(true).allowNestedFunctions(true).allowReturn(false).allowContinue(false).allowBreak(false));
    }

    private void _validateASTStructure(N4EnumDeclaration model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _isEmpty;
        if (model.getName() == null && !model.isExportedAsDefault()) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_TYPE_DECL_MISSING_NAME = IssueCodes.getMessageForAST_TYPE_DECL_MISSING_NAME();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_TYPE_DECL_MISSING_NAME");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_TYPE_DECL_MISSING_NAME, _defaultSeverity, "AST_TYPE_DECL_MISSING_NAME", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        if (_isEmpty = model.getLiterals().isEmpty()) {
            ICompositeNode target_1 = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target_1);
            String _messageForENM_WITHOUT_LITERALS = IssueCodes.getMessageForENM_WITHOUT_LITERALS();
            Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("ENM_WITHOUT_LITERALS");
            DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForENM_WITHOUT_LITERALS, _defaultSeverity_1, "ENM_WITHOUT_LITERALS", new String[0]);
            producer.addDiagnostic(_diagnosticMessage_1);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.strict(true).allowNestedFunctions(true).allowReturn(false).allowContinue(false).allowBreak(false));
    }

    private void _validateASTStructure(LegacyOctalIntLiteral model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _isStrict = constraints.isStrict();
        if (_isStrict) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_STR_NO_OCTALS = IssueCodes.getMessageForAST_STR_NO_OCTALS();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_STR_NO_OCTALS");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_STR_NO_OCTALS, _defaultSeverity, "AST_STR_NO_OCTALS", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(StringLiteral model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _isStrict = constraints.isStrict();
        if (_isStrict) {
            this.addErrorForOctalEscapeSequence(model.getRawValue(), (Literal)model, N4JSPackage.Literals.STRING_LITERAL__VALUE, producer);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(TemplateSegment model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.addErrorForOctalEscapeSequence(model.getRawValue(), (Literal)model, N4JSPackage.Literals.TEMPLATE_SEGMENT__VALUE, producer);
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void addErrorForOctalEscapeSequence(String rawValue, Literal model, EAttribute valueEAttribute, ASTStructureDiagnosticProducer producer) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)valueEAttribute);
        INode target = (INode)IterableExtensions.head((Iterable)nodes);
        SyntaxErrorMessage syntaxError = target.getSyntaxErrorMessage();
        if ((syntaxError == null || Objects.equal((Object)syntaxError.getIssueCode(), (Object)"N4JSStringValueConverter.bad.escapement.warn") || Objects.equal((Object)syntaxError.getIssueCode(), (Object)"InternalSemicolonInjectingParser.ASI")) && AbstractN4JSStringValueConverter.hasOctalEscapeSequence(rawValue)) {
            producer.setNode(target);
            String _messageForAST_STR_NO_OCTALS = IssueCodes.getMessageForAST_STR_NO_OCTALS();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_STR_NO_OCTALS");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_STR_NO_OCTALS, _defaultSeverity, "AST_STR_NO_OCTALS", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
    }

    private void _validateASTStructure(PostfixExpression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _not;
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
        Expression child = model.getExpression();
        boolean _isValidSimpleAssignmentTarget = child.isValidSimpleAssignmentTarget();
        boolean bl = _not = !_isValidSimpleAssignmentTarget;
        if (_not) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)N4JSPackage.Literals.POSTFIX_EXPRESSION__EXPRESSION);
            INode target = (INode)IterableExtensions.head((Iterable)nodes);
            producer.setNode(target);
            String _xifexpression = null;
            PostfixOperator _op = model.getOp();
            boolean _equals = Objects.equal((Object)_op, (Object)PostfixOperator.DEC);
            _xifexpression = _equals ? "decrement" : "increment";
            String operand = _xifexpression;
            String _messageForAST_INVALID_OPERAND = IssueCodes.getMessageForAST_INVALID_OPERAND(operand);
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_OPERAND");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_OPERAND, _defaultSeverity, "AST_INVALID_OPERAND", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
    }

    private void _validateASTStructure(UnaryExpression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        Expression child;
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
        if ((Objects.equal((Object)model.getOp(), (Object)UnaryOperator.DEC) || Objects.equal((Object)model.getOp(), (Object)UnaryOperator.INC)) && (child = model.getExpression()) != null && !child.isValidSimpleAssignmentTarget()) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)N4JSPackage.Literals.POSTFIX_EXPRESSION__EXPRESSION);
            INode target = (INode)IterableExtensions.head((Iterable)nodes);
            producer.setNode(target);
            String _xifexpression = null;
            UnaryOperator _op = model.getOp();
            boolean _equals = Objects.equal((Object)_op, (Object)UnaryOperator.DEC);
            _xifexpression = _equals ? "decrement" : "increment";
            String operand = _xifexpression;
            String _messageForAST_INVALID_OPERAND = IssueCodes.getMessageForAST_INVALID_OPERAND(operand);
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_OPERAND");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_OPERAND, _defaultSeverity, "AST_INVALID_OPERAND", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
    }

    private void _validateASTStructure(YieldExpression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _not;
        boolean _isYieldExpressionAllowed = constraints.isYieldExpressionAllowed();
        boolean bl = _not = !_isYieldExpressionAllowed;
        if (_not) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_INVALID_YIELD_EXPRESSION = IssueCodes.getMessageForAST_INVALID_YIELD_EXPRESSION();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_YIELD_EXPRESSION");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_YIELD_EXPRESSION, _defaultSeverity, "AST_INVALID_YIELD_EXPRESSION", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(AssignmentExpression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
        Expression lhs = model.getLhs();
        if (!(lhs == null || lhs.isValidSimpleAssignmentTarget() || model.getOp() == AssignmentOperator.ASSIGN && DestructureUtils.isTopOfDestructuringAssignment((EObject)model))) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)N4JSPackage.Literals.ASSIGNMENT_EXPRESSION__LHS);
            INode target = (INode)IterableExtensions.head((Iterable)nodes);
            producer.setNode(target);
            String _messageForAST_EXP_INVALID_LHS_ASS = IssueCodes.getMessageForAST_EXP_INVALID_LHS_ASS();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_EXP_INVALID_LHS_ASS");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_EXP_INVALID_LHS_ASS, _defaultSeverity, "AST_EXP_INVALID_LHS_ASS", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
    }

    private void _validateASTStructure(ImportCallExpression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _tripleNotEquals;
        int _size = model.getArguments().size();
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_IMPORT_CALL_WRONG_NUM_OF_ARGS = IssueCodes.getMessageForAST_IMPORT_CALL_WRONG_NUM_OF_ARGS();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_IMPORT_CALL_WRONG_NUM_OF_ARGS");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_IMPORT_CALL_WRONG_NUM_OF_ARGS, _defaultSeverity, "AST_IMPORT_CALL_WRONG_NUM_OF_ARGS", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        if (!model.getArguments().isEmpty() && model.getArgument().isSpread()) {
            ICompositeNode target_1 = NodeModelUtils.findActualNodeFor((EObject)model.getArgument());
            producer.setNode((INode)target_1);
            String _messageForAST_IMPORT_CALL_SPREAD = IssueCodes.getMessageForAST_IMPORT_CALL_SPREAD();
            Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("AST_IMPORT_CALL_SPREAD");
            DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_IMPORT_CALL_SPREAD, _defaultSeverity_1, "AST_IMPORT_CALL_SPREAD", new String[0]);
            producer.addDiagnostic(_diagnosticMessage_1);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(IdentifierRef model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        String name = model.getIdAsText();
        if (name != null && constraints.isStrict() && N4JSLanguageConstants.RESERVED_WORDS_IN_STRICT_MODE.contains(name)) {
            this.issueNameDiagnostic((EObject)model, producer, name, (EStructuralFeature)N4JSPackage.Literals.IDENTIFIER_REF__ID, Severity.ERROR);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(Variable model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        String name = model.getName();
        if (name != null) {
            if (Objects.equal((Object)name, (Object)"arguments") && !(model instanceof LocalArgumentsVariable)) {
                this.issueArgumentsError((EObject)model, name, constraints.isStrict(), producer);
            } else if (!Objects.equal((Object)name, (Object)"yield") && (this.languageHelper.getECMAKeywords().contains(name) || "enum".equals(name) || "await".equals(name) || "let".equals(name) || "true".equals(name) || "false".equals(name) || "null".equals(name))) {
                this.issueNameDiagnostic((EObject)model, producer, name);
            } else {
                boolean _isStrict = constraints.isStrict();
                if (_isStrict && (N4JSLanguageConstants.RESERVED_WORDS_IN_STRICT_MODE.contains(name) || Objects.equal((Object)name, (Object)"eval"))) {
                    this.issueNameDiagnostic((EObject)model, producer, name);
                }
            }
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(WithStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _isStrict = constraints.isStrict();
        if (_isStrict) {
            Functions.Function1 _function = it -> {
                EObject _grammarElement = it.getGrammarElement();
                Keyword _withKeyword_0 = this.grammarAccess.getWithStatementAccess().getWithKeyword_0();
                return Objects.equal((Object)_grammarElement, (Object)_withKeyword_0);
            };
            ILeafNode node = (ILeafNode)IterableExtensions.findFirst((Iterable)NodeModelUtils.findActualNodeFor((EObject)model).getLeafNodes(), (Functions.Function1)_function);
            producer.setNode((INode)node);
            if (node != null) {
                String _messageForAST_STR_NO_WITH_STMT = IssueCodes.getMessageForAST_STR_NO_WITH_STMT();
                Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_STR_NO_WITH_STMT");
                DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_STR_NO_WITH_STMT, _defaultSeverity, "AST_STR_NO_WITH_STMT", new String[0]);
                producer.addDiagnostic(_diagnosticMessage);
            }
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(LabelledStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        String name = model.getName();
        if (name != null && constraints.isStrict() && N4JSLanguageConstants.RESERVED_WORDS_IN_STRICT_MODE.contains(name)) {
            this.issueNameDiagnostic((EObject)model, producer, name);
        }
        try {
            validLabels.add(model);
            boolean _isStrict = constraints.isStrict();
            boolean _not = !_isStrict;
            this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(_not).allowBreak(true));
        }
        finally {
            validLabels.remove(model);
        }
    }

    private void _validateASTStructure(Block model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.validateBlockStructure(model.eContainer(), model, producer, validLabels, constraints);
    }

    private void _validateBlockStructure(IfStatement container, Block model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateBlockStructure(IterationStatement container, Block model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(!constraints.isStrict() && !constraints.isInFunctionDeclaration()));
    }

    private void _validateBlockStructure(FunctionDefinition container, Block model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(true));
    }

    private void _validateBlockStructure(CatchBlock container, Block model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(true));
    }

    private void _validateBlockStructure(EObject container, Block model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _isStrict = constraints.isStrict();
        boolean _not = !_isStrict;
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(_not));
    }

    private void _validateASTStructure(IfStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(!constraints.isStrict() && !constraints.isInFunctionDeclaration()));
    }

    private void _validateASTStructure(AbstractCaseClause model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowBreak(true));
    }

    private void _validateASTStructure(ForStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _not;
        boolean _isForPlain = model.isForPlain();
        boolean bl = _not = !_isForPlain;
        if (_not) {
            boolean _not_1;
            boolean _isEmpty = model.getVarDeclsOrBindings().isEmpty();
            boolean bl2 = _not_1 = !_isEmpty;
            if (_not_1) {
                Consumer<VariableDeclaration> _function = varDecl -> {
                    if (varDecl.getExpression() != null && !(varDecl.eContainer() instanceof BindingElement) && (constraints.isStrict() || model.getVarStmtKeyword() == VariableStatementKeyword.LET)) {
                        List nodes = NodeModelUtils.findNodesForFeature((EObject)varDecl, (EStructuralFeature)N4JSPackage.Literals.VARIABLE_DECLARATION__EXPRESSION);
                        INode _elvis = null;
                        INode _head = (INode)IterableExtensions.head((Iterable)nodes);
                        if (_head != null) {
                            _elvis = _head;
                        } else {
                            ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)varDecl);
                            _elvis = _findActualNodeFor;
                        }
                        INode target = _elvis;
                        producer.setNode(target);
                        if (target != null) {
                            String _messageForAST_VAR_DECL_IN_FOR_INVALID_INIT = IssueCodes.getMessageForAST_VAR_DECL_IN_FOR_INVALID_INIT();
                            Severity _xifexpression = null;
                            _xifexpression = constraints.isStrict() || model.isForIn() ? IssueCodes.getDefaultSeverity("AST_VAR_DECL_IN_FOR_INVALID_INIT") : Severity.WARNING;
                            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_VAR_DECL_IN_FOR_INVALID_INIT, _xifexpression, "AST_VAR_DECL_IN_FOR_INVALID_INIT", new String[0]);
                            producer.addDiagnostic(_diagnosticMessage);
                        }
                    } else if (model.getVarStmtKeyword() == VariableStatementKeyword.LET && Objects.equal((Object)varDecl.getName(), (Object)"let")) {
                        List nodes_1 = NodeModelUtils.findNodesForFeature((EObject)varDecl, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME);
                        INode _elvis_1 = null;
                        INode _head_1 = (INode)IterableExtensions.head((Iterable)nodes_1);
                        if (_head_1 != null) {
                            _elvis_1 = _head_1;
                        } else {
                            ICompositeNode _findActualNodeFor_1 = NodeModelUtils.findActualNodeFor((EObject)varDecl);
                            _elvis_1 = _findActualNodeFor_1;
                        }
                        INode target_1 = _elvis_1;
                        producer.setNode(target_1);
                        if (target_1 != null) {
                            String _messageForAST_RESERVED_IDENTIFIER = IssueCodes.getMessageForAST_RESERVED_IDENTIFIER(varDecl.getName());
                            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_RESERVED_IDENTIFIER");
                            DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_RESERVED_IDENTIFIER, _defaultSeverity, "AST_RESERVED_IDENTIFIER", new String[0]);
                            producer.addDiagnostic(_diagnosticMessage_1);
                        }
                    }
                };
                model.getVarDecl().forEach(_function);
            } else {
                boolean _tripleNotEquals;
                Expression _initExpr = model.getInitExpr();
                boolean bl3 = _tripleNotEquals = _initExpr != null;
                if (_tripleNotEquals) {
                    Expression initExpr = model.getInitExpr();
                    if (initExpr instanceof AssignmentExpression) {
                        List nodes = NodeModelUtils.findNodesForFeature((EObject)initExpr, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME);
                        INode _elvis = null;
                        INode _head = (INode)IterableExtensions.head((Iterable)nodes);
                        if (_head != null) {
                            _elvis = _head;
                        } else {
                            ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)initExpr);
                            _elvis = _findActualNodeFor;
                        }
                        INode target = _elvis;
                        producer.setNode(target);
                        if (target != null) {
                            String _messageForAST_VAR_DECL_IN_FOR_INVALID_INIT = IssueCodes.getMessageForAST_VAR_DECL_IN_FOR_INVALID_INIT();
                            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_VAR_DECL_IN_FOR_INVALID_INIT");
                            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_VAR_DECL_IN_FOR_INVALID_INIT, _defaultSeverity, "AST_VAR_DECL_IN_FOR_INVALID_INIT", new String[0]);
                            producer.addDiagnostic(_diagnosticMessage);
                        }
                    } else if (!initExpr.isValidSimpleAssignmentTarget() && !DestructureUtils.isTopOfDestructuringForStatement((EObject)model)) {
                        List nodes_1 = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)N4JSPackage.Literals.FOR_STATEMENT__INIT_EXPR);
                        INode _elvis_1 = null;
                        INode _head_1 = (INode)IterableExtensions.head((Iterable)nodes_1);
                        if (_head_1 != null) {
                            _elvis_1 = _head_1;
                        } else {
                            ICompositeNode _findActualNodeFor_1 = NodeModelUtils.findActualNodeFor((EObject)initExpr);
                            _elvis_1 = _findActualNodeFor_1;
                        }
                        INode target_1 = _elvis_1;
                        producer.setNode(target_1);
                        if (target_1 != null) {
                            String _messageForAST_EXP_INVALID_LHS_ASS = IssueCodes.getMessageForAST_EXP_INVALID_LHS_ASS();
                            Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("AST_EXP_INVALID_LHS_ASS");
                            DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_EXP_INVALID_LHS_ASS, _defaultSeverity_1, "AST_EXP_INVALID_LHS_ASS", new String[0]);
                            producer.addDiagnostic(_diagnosticMessage_1);
                        }
                    }
                }
            }
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(!constraints.isStrict() && !constraints.isInFunctionDeclaration()).allowBreak(true).allowContinue(true));
    }

    private void _validateASTStructure(IterationStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowNestedFunctions(!constraints.isStrict() && !constraints.isInFunctionDeclaration()).allowBreak(true).allowContinue(true));
    }

    private void _validateASTStructure(FormalParameter model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        EObject container = model.eContainer();
        boolean allowYieldInInit = false;
        if (container instanceof FunctionDefinition) {
            Procedures.Procedure3 _function;
            boolean _not;
            boolean _isGenerator = ((FunctionDefinition)container).isGenerator();
            allowYieldInInit = _not = !_isGenerator;
            final Procedures.Procedure3 issueConsumer = _function = (msg, id, eObj) -> {
                producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)eObj));
                Severity _defaultSeverity = IssueCodes.getDefaultSeverity(id);
                DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(msg, _defaultSeverity, id, new String[0]);
                producer.addDiagnostic(_diagnosticMessage);
            };
            Predicate<FormalParameter> _function_1 = it -> it.isVariadic();
            Predicate<FormalParameter> _function_2 = it -> it.isHasInitializerAssignment();
            FunctionValidationHelper.internalCheckFormalParameter(((FunctionDefinition)container).getFpars(), model, _function_1, _function_2, new FunctionValidationHelper.TripleConsumer<String, String, EObject>(){

                @Override
                public void accept(String arg0, String arg1, EObject arg2) {
                    issueConsumer.apply((Object)arg0, (Object)arg1, (Object)arg2);
                }
            });
        }
        this._validateASTStructure((Variable)model, producer, validLabels, constraints.allowYieldExpression(allowYieldInInit));
    }

    private void _validateASTStructure(NewTarget model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        ICompositeNode target;
        boolean _tripleEquals;
        FunctionDefinition _containerOfType = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)model, FunctionDefinition.class);
        boolean bl = _tripleEquals = _containerOfType == null;
        if (_tripleEquals && (target = NodeModelUtils.findActualNodeFor((EObject)model)) != null) {
            producer.setNode((INode)target);
            String _messageForAST_INVALID_NEW_TARGET = IssueCodes.getMessageForAST_INVALID_NEW_TARGET();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_NEW_TARGET");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_NEW_TARGET, _defaultSeverity, "AST_INVALID_NEW_TARGET", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(SuperLiteral model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        ICompositeNode target;
        boolean _isInvalidSuperLiteral = this.isInvalidSuperLiteral(model, constraints);
        if (_isInvalidSuperLiteral && (target = NodeModelUtils.findActualNodeFor((EObject)model)) != null) {
            boolean _tripleEquals;
            producer.setNode((INode)target);
            EStructuralFeature _eContainingFeature = model.eContainingFeature();
            boolean bl = _tripleEquals = _eContainingFeature == N4JSPackage.Literals.PARAMETERIZED_CALL_EXPRESSION__TARGET;
            if (_tripleEquals) {
                String _messageForKEY_SUP_CTOR_INVALID_LOC = IssueCodes.getMessageForKEY_SUP_CTOR_INVALID_LOC();
                Severity _defaultSeverity = IssueCodes.getDefaultSeverity("KEY_SUP_CTOR_INVALID_LOC");
                DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForKEY_SUP_CTOR_INVALID_LOC, _defaultSeverity, "KEY_SUP_CTOR_INVALID_LOC", new String[0]);
                producer.addDiagnostic(_diagnosticMessage);
            } else {
                boolean _tripleEquals_1;
                N4MethodDeclaration _containerOfType = (N4MethodDeclaration)EcoreUtil2.getContainerOfType((EObject)model, N4MethodDeclaration.class);
                boolean bl2 = _tripleEquals_1 = _containerOfType == null;
                if (_tripleEquals_1) {
                    String _messageForKEY_SUP_ACCESS_INVALID_LOC = IssueCodes.getMessageForKEY_SUP_ACCESS_INVALID_LOC();
                    Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("KEY_SUP_ACCESS_INVALID_LOC");
                    DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForKEY_SUP_ACCESS_INVALID_LOC, _defaultSeverity_1, "KEY_SUP_ACCESS_INVALID_LOC", new String[0]);
                    producer.addDiagnostic(_diagnosticMessage_1);
                } else {
                    N4ClassifierDeclaration containingClass = (N4ClassifierDeclaration)EcoreUtil2.getContainerOfType((EObject)model, N4ClassifierDeclaration.class);
                    if (containingClass instanceof N4InterfaceDeclaration) {
                        String _messageForKEY_SUP_ACCESS_INVALID_LOC_INTERFACE = IssueCodes.getMessageForKEY_SUP_ACCESS_INVALID_LOC_INTERFACE();
                        Severity _defaultSeverity_2 = IssueCodes.getDefaultSeverity("KEY_SUP_ACCESS_INVALID_LOC_INTERFACE");
                        DiagnosticMessage _diagnosticMessage_2 = new DiagnosticMessage(_messageForKEY_SUP_ACCESS_INVALID_LOC_INTERFACE, _defaultSeverity_2, "KEY_SUP_ACCESS_INVALID_LOC_INTERFACE", new String[0]);
                        producer.addDiagnostic(_diagnosticMessage_2);
                    } else if (containingClass != null) {
                        boolean _not;
                        boolean _isN4JS = constraints.isN4JS();
                        boolean bl3 = _not = !_isN4JS;
                        if (_not) {
                            String _messageForKEY_SUP_ACCESS_NO_EXTENDS = IssueCodes.getMessageForKEY_SUP_ACCESS_NO_EXTENDS();
                            Severity _defaultSeverity_3 = IssueCodes.getDefaultSeverity("KEY_SUP_ACCESS_NO_EXTENDS");
                            DiagnosticMessage _diagnosticMessage_3 = new DiagnosticMessage(_messageForKEY_SUP_ACCESS_NO_EXTENDS, _defaultSeverity_3, "KEY_SUP_ACCESS_NO_EXTENDS", new String[0]);
                            producer.addDiagnostic(_diagnosticMessage_3);
                        }
                    } else {
                        throw new IllegalStateException("a");
                    }
                }
            }
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private boolean isInvalidSuperLiteral(SuperLiteral model, Constraints constraints) {
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        boolean _isValidContainment = this.isValidContainment(model);
        boolean bl = _not = !_isValidContainment;
        if (_not) {
            return true;
        }
        boolean _isSuperLiteralAllowed = constraints.isSuperLiteralAllowed();
        boolean bl2 = _not_1 = !_isSuperLiteralAllowed;
        if (_not_1) {
            return true;
        }
        boolean _isSuperCallAllowed = constraints.isSuperCallAllowed();
        boolean bl3 = _not_2 = !_isSuperCallAllowed;
        if (_not_2) {
            EObject _eContainer = model.eContainer();
            return _eContainer instanceof ParameterizedCallExpression;
        }
        return false;
    }

    private boolean isValidContainment(SuperLiteral literal) {
        EObject container = literal.eContainer();
        return container instanceof IndexedAccessExpression || container instanceof ParameterizedCallExpression || container instanceof ParameterizedPropertyAccessExpression;
    }

    private void _validateASTStructure(FunctionDeclaration model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.validateFunctionDefinition((FunctionDefinition)model, N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, constraints.enterFunctionDeclaration(), model.getName(), producer, validLabels);
    }

    private void _validateASTStructure(FunctionExpression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        String name = model.getName();
        if (name != null) {
            boolean _equals = Objects.equal((Object)name, (Object)"arguments");
            if (_equals) {
                this.issueArgumentsError((EObject)model, name, constraints.isStrict(), producer);
            } else {
                boolean _isStrict = constraints.isStrict();
                if (_isStrict && (N4JSLanguageConstants.RESERVED_WORDS_IN_STRICT_MODE.contains(name) || Objects.equal((Object)name, (Object)"eval"))) {
                    this.issueNameDiagnostic((EObject)model, producer, name);
                }
            }
        }
        this.recursiveValidateASTStructure((EObject)model, producer, Sets.newHashSetWithExpectedSize((int)2), constraints.allowNestedFunctions(true).allowReturn(true).allowBreak(false).allowContinue(false));
    }

    private void validateFunctionDefinition(FunctionDefinition model, EAttribute attribute, Constraints constraints, String name, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels) {
        boolean _not;
        boolean _isNestedFunctionAllowed = constraints.isNestedFunctionAllowed();
        boolean bl = _not = !_isNestedFunctionAllowed;
        if (_not) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)attribute);
            INode _elvis = null;
            INode _head = (INode)IterableExtensions.head((Iterable)nodes);
            if (_head != null) {
                _elvis = _head;
            } else {
                ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)model);
                _elvis = _findActualNodeFor;
            }
            INode target = _elvis;
            producer.setNode(target);
            String _messageForAST_STR_FUN_NOT_NESTED = IssueCodes.getMessageForAST_STR_FUN_NOT_NESTED();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_STR_FUN_NOT_NESTED");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_STR_FUN_NOT_NESTED, _defaultSeverity, "AST_STR_FUN_NOT_NESTED", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        } else if (name != null) {
            boolean _equals = Objects.equal((Object)name, (Object)"arguments");
            if (_equals) {
                this.issueArgumentsError((EObject)model, name, constraints.isStrict(), producer);
            } else {
                boolean _isStrict = constraints.isStrict();
                if (_isStrict && (N4JSLanguageConstants.RESERVED_WORDS_IN_STRICT_MODE.contains(name) || Objects.equal((Object)name, (Object)"eval"))) {
                    this.issueNameDiagnostic((EObject)model, producer, name);
                }
            }
        }
        this.recursiveValidateASTStructure((EObject)model, producer, Sets.newHashSetWithExpectedSize((int)2), constraints.allowNestedFunctions(true).allowReturn(true).allowContinue(false).allowBreak(false).allowYieldExpression(true));
    }

    private void validateName(PropertyNameOwner model, Constraints constraints, ASTStructureDiagnosticProducer producer) {
        String name = model.getName();
        if (name != null) {
            boolean _not;
            boolean _isValidName = model.isValidName();
            boolean bl = _not = !_isValidName;
            if (_not) {
                this.issueNameDiagnostic((EObject)model, producer, name);
            } else {
                boolean _isN4JS = constraints.isN4JS();
                if (_isN4JS) {
                    boolean _contains = N4JSLanguageConstants.RESERVED_WORDS_IN_STRICT_MODE.contains(name);
                    if (_contains) {
                        this.issueNameDiagnostic((EObject)model, producer, name);
                    }
                } else {
                    boolean _contains_1;
                    boolean _isStrict = constraints.isStrict();
                    if (_isStrict && (_contains_1 = N4JSLanguageConstants.RESERVED_WORDS_IN_STRICT_MODE.contains(name))) {
                        this.issueNameDiagnostic((EObject)model, producer, name, this.getNameFeature((EObject)model), Severity.WARNING);
                    }
                }
            }
        }
    }

    private void issueArgumentsError(EObject model, String name, boolean strict, ASTStructureDiagnosticProducer producer) {
        EStructuralFeature _nameFeature = this.getNameFeature(model);
        Severity _xifexpression = null;
        _xifexpression = strict ? Severity.ERROR : Severity.WARNING;
        this.issueNameDiagnostic(model, producer, name, _nameFeature, _xifexpression);
    }

    private void issueNameDiagnostic(EObject model, ASTStructureDiagnosticProducer producer, String name) {
        this.issueNameDiagnostic(model, producer, name, this.getNameFeature(model), IssueCodes.getDefaultSeverity("AST_RESERVED_IDENTIFIER"));
    }

    private void issueNameDiagnostic(EObject model, ASTStructureDiagnosticProducer producer, String name, EStructuralFeature feature, Severity severity) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)feature);
        INode _elvis = null;
        INode _head = (INode)IterableExtensions.head((Iterable)nodes);
        if (_head != null) {
            _elvis = _head;
        } else {
            ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)model);
            _elvis = _findActualNodeFor;
        }
        INode target = _elvis;
        producer.setNode(target);
        if (target != null) {
            String _messageForAST_RESERVED_IDENTIFIER = IssueCodes.getMessageForAST_RESERVED_IDENTIFIER(name);
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_RESERVED_IDENTIFIER, severity, "AST_RESERVED_IDENTIFIER", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
    }

    private EStructuralFeature getNameFeature(EObject model) {
        EStructuralFeature _eStructuralFeature_1;
        EStructuralFeature _elvis = null;
        EStructuralFeature _eStructuralFeature = model.eClass().getEStructuralFeature("name");
        _elvis = _eStructuralFeature != null ? _eStructuralFeature : (_eStructuralFeature_1 = model.eClass().getEStructuralFeature("declaredName"));
        return _elvis;
    }

    private void _validateASTStructure(N4FieldAccessor model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.validateName((PropertyNameOwner)model, constraints, producer);
        this.recursiveValidateASTStructure((EObject)model, producer, Sets.newHashSetWithExpectedSize((int)2), constraints.allowReturn(true).allowSuperLiteral(true).allowSuperCall(false));
    }

    private void _validateASTStructure(MethodDeclaration model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.validateName((PropertyNameOwner)model, constraints, producer);
        Constraints _allowSuperLiteral = constraints.allowReturn(true).allowSuperLiteral(true);
        this.recursiveValidateASTStructure((EObject)model, producer, Sets.newHashSetWithExpectedSize((int)2), _allowSuperLiteral.allowSuperCall(Objects.equal((Object)model.getName(), (Object)"constructor") && !model.isStatic() && this.canCallSuperConstructor(model, constraints)));
    }

    private boolean canCallSuperConstructor(MethodDeclaration declaration, Constraints constraints) {
        EObject container = declaration.eContainer();
        if (container instanceof N4ClassDefinition) {
            boolean _isN4JS = constraints.isN4JS();
            if (_isN4JS) {
                return true;
            }
            return ((N4ClassDefinition)container).getSuperClassRef() != null || ((N4ClassDefinition)container).getSuperClassExpression() != null;
        }
        return false;
    }

    private void _validateASTStructure(FieldAccessor model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.validateName((PropertyNameOwner)model, constraints, producer);
        this.recursiveValidateASTStructure((EObject)model, producer, Sets.newHashSetWithExpectedSize((int)2), constraints.allowReturn(true).allowSuperLiteral(true).allowSuperCall(false));
    }

    private void _validateASTStructure(PropertyAssignment model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, Sets.newHashSetWithExpectedSize((int)2), constraints.allowNestedFunctions(false).allowReturn(true).allowContinue(false).allowBreak(false).allowYieldExpression(true));
    }

    private void _validateASTStructure(ReturnStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _not;
        boolean _isReturnAllowed = constraints.isReturnAllowed();
        boolean bl = _not = !_isReturnAllowed;
        if (_not) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_INVALID_RETURN = IssueCodes.getMessageForAST_INVALID_RETURN();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_RETURN");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_RETURN, _defaultSeverity, "AST_INVALID_RETURN", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(ContinueStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _not;
        boolean _isContinueAllowed = constraints.isContinueAllowed();
        boolean bl = _not = !_isContinueAllowed;
        if (_not) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_INVALID_CONTINUE = IssueCodes.getMessageForAST_INVALID_CONTINUE();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_CONTINUE");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_CONTINUE, _defaultSeverity, "AST_INVALID_CONTINUE", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        } else {
            this.validateLabelRef((LabelRef)model, producer, validLabels);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(BreakStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _not;
        boolean _isBreakAllowed = constraints.isBreakAllowed();
        boolean bl = _not = !_isBreakAllowed;
        if (_not) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_INVALID_BREAK = IssueCodes.getMessageForAST_INVALID_BREAK();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_BREAK");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_BREAK, _defaultSeverity, "AST_INVALID_BREAK", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        } else {
            this.validateLabelRef((LabelRef)model, producer, validLabels);
        }
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void validateLabelRef(LabelRef model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels) {
        String labelAsText = model.getLabelAsText();
        if (labelAsText != null && !IterableExtensions.exists(validLabels, it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)labelAsText);
        })) {
            ICompositeNode target = NodeModelUtils.findActualNodeFor((EObject)model);
            producer.setNode((INode)target);
            String _messageForAST_INVALID_LABEL = IssueCodes.getMessageForAST_INVALID_LABEL();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_LABEL");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_LABEL, _defaultSeverity, "AST_INVALID_LABEL", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
    }

    private void _validateASTStructure(Expression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(ArrayElement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
        this.validateExpressionInArrayOrObjectLiteral((EObject)model, constraints, producer);
        this.validateSpreadInArrayLiteral(model, producer);
    }

    private void validateExpressionInArrayOrObjectLiteral(EObject elem, Constraints constraints, ASTStructureDiagnosticProducer producer) {
        if (!(elem instanceof ArrayElement || elem instanceof PropertyNameValuePair || elem instanceof PropertyMethodDeclaration)) {
            throw new IllegalArgumentException();
        }
        if (elem instanceof PropertyNameValuePairSingleName) {
            IdentifierRef identifier = ((PropertyNameValuePairSingleName)elem).getIdentifierRef();
            if (identifier != null && !identifier.isValidSimpleAssignmentTarget()) {
                producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)identifier));
                String _messageForAST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN = IssueCodes.getMessageForAST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN();
                Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN");
                DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN, _defaultSeverity, "AST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN", new String[0]);
                producer.addDiagnostic(_diagnosticMessage);
            }
            return;
        }
        if (elem != null && DestructureUtils.isArrayOrObjectLiteralUsedAsDestructuringPattern((EObject)elem.eContainer())) {
            if (elem instanceof PropertyMethodDeclaration) {
                producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)elem));
                String _messageForAST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN = IssueCodes.getMessageForAST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN();
                Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("AST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN");
                DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN, _defaultSeverity_1, "AST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN", new String[0]);
                producer.addDiagnostic(_diagnosticMessage_1);
            } else {
                Expression expr;
                Expression _switchResult = null;
                boolean _matched = false;
                if (elem instanceof ArrayElement) {
                    _matched = true;
                    _switchResult = ((ArrayElement)elem).getExpression();
                }
                if (!_matched && elem instanceof PropertyNameValuePair) {
                    _matched = true;
                    _switchResult = ((PropertyNameValuePair)elem).getExpression();
                }
                if ((expr = _switchResult) != null && !this.isValidBindingElement(expr, constraints)) {
                    producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)expr));
                    String _messageForAST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN_1 = IssueCodes.getMessageForAST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN();
                    Severity _defaultSeverity_2 = IssueCodes.getDefaultSeverity("AST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN");
                    DiagnosticMessage _diagnosticMessage_2 = new DiagnosticMessage(_messageForAST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN_1, _defaultSeverity_2, "AST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN", new String[0]);
                    producer.addDiagnostic(_diagnosticMessage_2);
                }
            }
        }
    }

    private boolean isValidBindingElement(Expression expr, Constraints constraints) {
        boolean _isN4JS = constraints.isN4JS();
        if (_isN4JS) {
            return expr.isValidSimpleAssignmentTarget() && expr instanceof IdentifierRef || expr instanceof AssignmentExpression || expr instanceof ArrayLiteral || expr instanceof ObjectLiteral;
        }
        return expr.isValidSimpleAssignmentTarget() || expr instanceof AssignmentExpression || expr instanceof ArrayLiteral || expr instanceof ObjectLiteral;
    }

    private void validateSpreadInArrayLiteral(ArrayElement elem, ASTStructureDiagnosticProducer producer) {
        if (elem != null && elem.isSpread()) {
            boolean _not;
            boolean _isArrayOrObjectLiteralUsedAsDestructuringPattern = DestructureUtils.isArrayOrObjectLiteralUsedAsDestructuringPattern((EObject)elem.eContainer());
            boolean bl = _not = !_isArrayOrObjectLiteralUsedAsDestructuringPattern;
            if (_not) {
                List nodes = NodeModelUtils.findNodesForFeature((EObject)elem, (EStructuralFeature)N4JSPackage.eINSTANCE.getArrayElement_Spread());
                INode _elvis = null;
                INode _head = (INode)IterableExtensions.head((Iterable)nodes);
                if (_head != null) {
                    _elvis = _head;
                } else {
                    ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)elem);
                    _elvis = _findActualNodeFor;
                }
                producer.setNode(_elvis);
                String _messageForAST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED = IssueCodes.getMessageForAST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED();
                Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED");
                DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED, _defaultSeverity, "AST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED", new String[0]);
                producer.addDiagnostic(_diagnosticMessage);
            } else {
                EObject lit = elem.eContainer();
                if (lit instanceof ArrayLiteral) {
                    Expression _expression;
                    if (IterableExtensions.last((Iterable)((ArrayLiteral)lit).getElements()) != elem || ((ArrayLiteral)lit).isTrailingComma()) {
                        List nodes_1 = NodeModelUtils.findNodesForFeature((EObject)elem, (EStructuralFeature)N4JSPackage.eINSTANCE.getArrayElement_Spread());
                        INode _elvis_1 = null;
                        INode _head_1 = (INode)IterableExtensions.head((Iterable)nodes_1);
                        if (_head_1 != null) {
                            _elvis_1 = _head_1;
                        } else {
                            ICompositeNode _findActualNodeFor_1 = NodeModelUtils.findActualNodeFor((EObject)elem);
                            _elvis_1 = _findActualNodeFor_1;
                        }
                        producer.setNode(_elvis_1);
                        String _messageForAST_REST_MUST_APPEAR_AT_END = IssueCodes.getMessageForAST_REST_MUST_APPEAR_AT_END();
                        Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("AST_REST_MUST_APPEAR_AT_END");
                        DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_REST_MUST_APPEAR_AT_END, _defaultSeverity_1, "AST_REST_MUST_APPEAR_AT_END", new String[0]);
                        producer.addDiagnostic(_diagnosticMessage_1);
                    }
                    if ((_expression = elem.getExpression()) instanceof AssignmentExpression) {
                        List nodes_2 = NodeModelUtils.findNodesForFeature((EObject)elem.getExpression(), (EStructuralFeature)N4JSPackage.eINSTANCE.getAssignmentExpression_Rhs());
                        INode _elvis_2 = null;
                        INode _head_2 = (INode)IterableExtensions.head((Iterable)nodes_2);
                        if (_head_2 != null) {
                            _elvis_2 = _head_2;
                        } else {
                            ICompositeNode _findActualNodeFor_2 = NodeModelUtils.findActualNodeFor((EObject)elem.getExpression());
                            _elvis_2 = _findActualNodeFor_2;
                        }
                        producer.setNode(_elvis_2);
                        String _messageForAST_REST_WITH_INITIALIZER = IssueCodes.getMessageForAST_REST_WITH_INITIALIZER();
                        Severity _defaultSeverity_2 = IssueCodes.getDefaultSeverity("AST_REST_WITH_INITIALIZER");
                        DiagnosticMessage _diagnosticMessage_2 = new DiagnosticMessage(_messageForAST_REST_WITH_INITIALIZER, _defaultSeverity_2, "AST_REST_WITH_INITIALIZER", new String[0]);
                        producer.addDiagnostic(_diagnosticMessage_2);
                    }
                }
            }
        }
    }

    private void _validateASTStructure(PropertyNameValuePair model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowYieldExpression(true));
        this.validateExpressionInArrayOrObjectLiteral((EObject)model, constraints, producer);
        this.validateSingleNameInObjectLiteral(model, producer);
    }

    private void _validateASTStructure(PropertyMethodDeclaration model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowReturn(true).allowSuperLiteral(true).allowSuperCall(false).allowYieldExpression(true));
        this.validateExpressionInArrayOrObjectLiteral((EObject)model, constraints, producer);
    }

    private void validateSingleNameInObjectLiteral(PropertyNameValuePair elem, ASTStructureDiagnosticProducer producer) {
        if (elem instanceof PropertyNameValuePairSingleName && !DestructureUtils.isArrayOrObjectLiteralUsedAsDestructuringPattern((EObject)elem.eContainer())) {
            producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)elem));
            String _messageForAST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED = IssueCodes.getMessageForAST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED();
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED, _defaultSeverity, "AST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
    }

    private void _validateASTStructure(VariableStatement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        boolean _isEmpty;
        boolean _tripleEquals;
        VariableStatementKeyword _varStmtKeyword = model.getVarStmtKeyword();
        boolean bl = _tripleEquals = _varStmtKeyword == VariableStatementKeyword.CONST;
        if (_tripleEquals) {
            boolean _not;
            boolean _isValidConstOrLetPosition = this.isValidConstOrLetPosition((EObject)model);
            boolean bl2 = _not = !_isValidConstOrLetPosition;
            if (_not) {
                List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)N4JSPackage.Literals.VARIABLE_DECLARATION_CONTAINER__VAR_STMT_KEYWORD);
                INode _elvis = null;
                INode _head = (INode)IterableExtensions.head((Iterable)nodes);
                if (_head != null) {
                    _elvis = _head;
                } else {
                    ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)model);
                    _elvis = _findActualNodeFor;
                }
                producer.setNode(_elvis);
                String _messageForAST_CONST_IN_STATEMENT_POSITION = IssueCodes.getMessageForAST_CONST_IN_STATEMENT_POSITION();
                Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_CONST_IN_STATEMENT_POSITION");
                DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_CONST_IN_STATEMENT_POSITION, _defaultSeverity, "AST_CONST_IN_STATEMENT_POSITION", new String[0]);
                producer.addDiagnostic(_diagnosticMessage);
            }
        } else {
            boolean _tripleEquals_1;
            VariableStatementKeyword _varStmtKeyword_1 = model.getVarStmtKeyword();
            boolean bl3 = _tripleEquals_1 = _varStmtKeyword_1 == VariableStatementKeyword.LET;
            if (_tripleEquals_1) {
                boolean _not_1;
                boolean _isValidConstOrLetPosition_1 = this.isValidConstOrLetPosition((EObject)model);
                boolean bl4 = _not_1 = !_isValidConstOrLetPosition_1;
                if (_not_1) {
                    List nodes_1 = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)N4JSPackage.Literals.VARIABLE_DECLARATION_CONTAINER__VAR_STMT_KEYWORD);
                    INode _elvis_1 = null;
                    INode _head_1 = (INode)IterableExtensions.head((Iterable)nodes_1);
                    if (_head_1 != null) {
                        _elvis_1 = _head_1;
                    } else {
                        ICompositeNode _findActualNodeFor_1 = NodeModelUtils.findActualNodeFor((EObject)model);
                        _elvis_1 = _findActualNodeFor_1;
                    }
                    producer.setNode(_elvis_1);
                    String _messageForAST_LET_IN_STATEMENT_POSITION = IssueCodes.getMessageForAST_LET_IN_STATEMENT_POSITION();
                    Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("AST_LET_IN_STATEMENT_POSITION");
                    DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_LET_IN_STATEMENT_POSITION, _defaultSeverity_1, "AST_LET_IN_STATEMENT_POSITION", new String[0]);
                    producer.addDiagnostic(_diagnosticMessage_1);
                }
            }
        }
        if (_isEmpty = model.getVarDeclsOrBindings().isEmpty()) {
            List nodes_2 = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)N4JSPackage.Literals.VARIABLE_DECLARATION_CONTAINER__VAR_STMT_KEYWORD);
            INode _elvis_2 = null;
            INode _head_2 = (INode)IterableExtensions.head((Iterable)nodes_2);
            if (_head_2 != null) {
                _elvis_2 = _head_2;
            } else {
                ICompositeNode _findActualNodeFor_2 = NodeModelUtils.findActualNodeFor((EObject)model);
                _elvis_2 = _findActualNodeFor_2;
            }
            producer.setNode(_elvis_2);
            String _messageForAST_VAR_STMT_NO_DECL = IssueCodes.getMessageForAST_VAR_STMT_NO_DECL();
            Severity _defaultSeverity_2 = IssueCodes.getDefaultSeverity("AST_VAR_STMT_NO_DECL");
            DiagnosticMessage _diagnosticMessage_2 = new DiagnosticMessage(_messageForAST_VAR_STMT_NO_DECL, _defaultSeverity_2, "AST_VAR_STMT_NO_DECL", new String[0]);
            producer.addDiagnostic(_diagnosticMessage_2);
        }
        EObject directParent = model.eContainer();
        EObject _xifexpression = null;
        _xifexpression = directParent instanceof ExportDeclaration ? ((ExportDeclaration)directParent).eContainer() : directParent;
        EObject parent = _xifexpression;
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowVarWithoutInitializer(model.getVarStmtKeyword() == VariableStatementKeyword.VAR || model.getVarStmtKeyword() == VariableStatementKeyword.LET && (parent instanceof Block || parent instanceof Script || parent instanceof AbstractCaseClause)));
    }

    private boolean isValidConstOrLetPosition(EObject model) {
        if (model.eContainer() instanceof Block || model.eContainer() instanceof Script || model.eContainer() instanceof AbstractCaseClause) {
            return true;
        }
        EObject _eContainer = model.eContainer();
        if (_eContainer instanceof ExportDeclaration) {
            return this.isValidConstOrLetPosition(model.eContainer());
        }
        return false;
    }

    private void _validateASTStructure(VariableDeclaration model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        if (model.getExpression() == null && constraints.isVarInitializerRequired() && !constraints.isExternal()) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME);
            INode _elvis = null;
            INode _head = (INode)IterableExtensions.head((Iterable)nodes);
            if (_head != null) {
                _elvis = _head;
            } else {
                ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)model);
                _elvis = _findActualNodeFor;
            }
            producer.setNode(_elvis);
            String _messageForAST_CONST_HAS_NO_INITIALIZER = IssueCodes.getMessageForAST_CONST_HAS_NO_INITIALIZER(model.getName());
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_CONST_HAS_NO_INITIALIZER");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_CONST_HAS_NO_INITIALIZER, _defaultSeverity, "AST_CONST_HAS_NO_INITIALIZER", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        this._validateASTStructure((Variable)model, producer, validLabels, constraints.allowVarWithoutInitializer(true));
    }

    private void _validateASTStructure(ThisTypeRef thisTypeRef, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)thisTypeRef, producer, validLabels, constraints);
    }

    private void _validateASTStructure(VariableBinding model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints.allowVarWithoutInitializer(true));
    }

    private void _validateASTStructure(BindingElement model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        this.validateRestInBindingPattern(model, producer);
        this.recursiveValidateASTStructure((EObject)model, producer, validLabels, constraints);
    }

    private void _validateASTStructure(Annotation model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        EObject _eContainer = model.eContainer();
        if (_eContainer instanceof Script) {
            ScriptElement firstScriptElement;
            int scriptElementOffset;
            ICompositeNode annotationNode;
            int annotationOffset;
            boolean _greaterThan;
            EObject _eContainer_1 = model.eContainer();
            Script script = (Script)_eContainer_1;
            int _size = script.getScriptElements().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan && (annotationOffset = (annotationNode = NodeModelUtils.findActualNodeFor((EObject)model)).getOffset()) > (scriptElementOffset = NodeModelUtils.findActualNodeFor((EObject)(firstScriptElement = (ScriptElement)script.getScriptElements().get(0))).getOffset())) {
                producer.setNode((INode)annotationNode);
                String _messageForAST_SCRIPT_ANNO_INVALID_PLACEMENT = IssueCodes.getMessageForAST_SCRIPT_ANNO_INVALID_PLACEMENT(model.getName());
                Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_SCRIPT_ANNO_INVALID_PLACEMENT");
                DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_SCRIPT_ANNO_INVALID_PLACEMENT, _defaultSeverity, "AST_SCRIPT_ANNO_INVALID_PLACEMENT", new String[0]);
                producer.addDiagnostic(_diagnosticMessage);
            }
        }
    }

    private void validateRestInBindingPattern(BindingElement elem, ASTStructureDiagnosticProducer producer) {
        if (elem != null && elem.isRest()) {
            Expression _expression;
            boolean _tripleNotEquals_1;
            EObject pattern = elem.eContainer();
            if (pattern instanceof ArrayBindingPattern) {
                boolean _tripleNotEquals;
                BindingElement _last = (BindingElement)IterableExtensions.last((Iterable)((ArrayBindingPattern)pattern).getElements());
                boolean bl = _tripleNotEquals = _last != elem;
                if (_tripleNotEquals) {
                    List nodes = NodeModelUtils.findNodesForFeature((EObject)elem, (EStructuralFeature)N4JSPackage.eINSTANCE.getBindingElement_Rest());
                    INode _elvis = null;
                    INode _head = (INode)IterableExtensions.head((Iterable)nodes);
                    if (_head != null) {
                        _elvis = _head;
                    } else {
                        ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)elem);
                        _elvis = _findActualNodeFor;
                    }
                    producer.setNode(_elvis);
                    String _messageForAST_REST_MUST_APPEAR_AT_END = IssueCodes.getMessageForAST_REST_MUST_APPEAR_AT_END();
                    Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_REST_MUST_APPEAR_AT_END");
                    DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_REST_MUST_APPEAR_AT_END, _defaultSeverity, "AST_REST_MUST_APPEAR_AT_END", new String[0]);
                    producer.addDiagnostic(_diagnosticMessage);
                }
            }
            boolean bl = _tripleNotEquals_1 = (_expression = elem.getExpression()) != null;
            if (_tripleNotEquals_1) {
                List nodes_1 = NodeModelUtils.findNodesForFeature((EObject)elem, (EStructuralFeature)N4JSPackage.eINSTANCE.getBindingElement_Expression());
                INode _elvis_1 = null;
                INode _head_1 = (INode)IterableExtensions.head((Iterable)nodes_1);
                if (_head_1 != null) {
                    _elvis_1 = _head_1;
                } else {
                    ICompositeNode _findActualNodeFor_1 = NodeModelUtils.findActualNodeFor((EObject)elem);
                    _elvis_1 = _findActualNodeFor_1;
                }
                producer.setNode(_elvis_1);
                String _messageForAST_REST_WITH_INITIALIZER = IssueCodes.getMessageForAST_REST_WITH_INITIALIZER();
                Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("AST_REST_WITH_INITIALIZER");
                DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_REST_WITH_INITIALIZER, _defaultSeverity_1, "AST_REST_WITH_INITIALIZER", new String[0]);
                producer.addDiagnostic(_diagnosticMessage_1);
            }
        }
    }

    private void _validateASTStructure(BinaryLogicalExpression model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        BinaryLogicalOperator _op;
        boolean _tripleEquals_2;
        Expression _rhs;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        Expression _lhs = model.getLhs();
        boolean bl = _tripleEquals = _lhs == null;
        if (_tripleEquals) {
            producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)model));
            String _messageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART = IssueCodes.getMessageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART("left operand");
            Severity _defaultSeverity = IssueCodes.getDefaultSeverity("AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART");
            DiagnosticMessage _diagnosticMessage = new DiagnosticMessage(_messageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART, _defaultSeverity, "AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART", new String[0]);
            producer.addDiagnostic(_diagnosticMessage);
        }
        boolean bl2 = _tripleEquals_1 = (_rhs = model.getRhs()) == null;
        if (_tripleEquals_1) {
            producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)model));
            String _messageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART_1 = IssueCodes.getMessageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART("right operand");
            Severity _defaultSeverity_1 = IssueCodes.getDefaultSeverity("AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART");
            DiagnosticMessage _diagnosticMessage_1 = new DiagnosticMessage(_messageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART_1, _defaultSeverity_1, "AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART", new String[0]);
            producer.addDiagnostic(_diagnosticMessage_1);
        }
        boolean bl3 = _tripleEquals_2 = (_op = model.getOp()) == null;
        if (_tripleEquals_2) {
            producer.setNode((INode)NodeModelUtils.findActualNodeFor((EObject)model));
            String _messageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART_2 = IssueCodes.getMessageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART("operator");
            Severity _defaultSeverity_2 = IssueCodes.getDefaultSeverity("AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART");
            DiagnosticMessage _diagnosticMessage_2 = new DiagnosticMessage(_messageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART_2, _defaultSeverity_2, "AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART", new String[0]);
            producer.addDiagnostic(_diagnosticMessage_2);
        }
    }

    private void validateASTStructure(EObject model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        if (model instanceof LegacyOctalIntLiteral) {
            this._validateASTStructure((LegacyOctalIntLiteral)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof N4EnumDeclaration) {
            this._validateASTStructure((N4EnumDeclaration)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof PropertyMethodDeclaration) {
            this._validateASTStructure((PropertyMethodDeclaration)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof PropertyNameValuePair) {
            this._validateASTStructure((PropertyNameValuePair)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof StringLiteral) {
            this._validateASTStructure((StringLiteral)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof TemplateSegment) {
            this._validateASTStructure((TemplateSegment)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof ThisTypeRef) {
            this._validateASTStructure((ThisTypeRef)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof ForStatement) {
            this._validateASTStructure((ForStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof FormalParameter) {
            this._validateASTStructure((FormalParameter)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof FunctionDeclaration) {
            this._validateASTStructure((FunctionDeclaration)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof FunctionExpression) {
            this._validateASTStructure((FunctionExpression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof IdentifierRef) {
            this._validateASTStructure((IdentifierRef)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof MethodDeclaration) {
            this._validateASTStructure((MethodDeclaration)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof N4ClassifierDefinition) {
            this._validateASTStructure((N4ClassifierDefinition)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof N4FieldAccessor) {
            this._validateASTStructure((N4FieldAccessor)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof SuperLiteral) {
            this._validateASTStructure((SuperLiteral)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof VariableDeclaration) {
            this._validateASTStructure((VariableDeclaration)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof AssignmentExpression) {
            this._validateASTStructure((AssignmentExpression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof BinaryLogicalExpression) {
            this._validateASTStructure((BinaryLogicalExpression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof Block) {
            this._validateASTStructure((Block)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof BreakStatement) {
            this._validateASTStructure((BreakStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof ContinueStatement) {
            this._validateASTStructure((ContinueStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof ExportDeclaration) {
            this._validateASTStructure((ExportDeclaration)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof FieldAccessor) {
            this._validateASTStructure((FieldAccessor)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof IfStatement) {
            this._validateASTStructure((IfStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof ImportCallExpression) {
            this._validateASTStructure((ImportCallExpression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof IterationStatement) {
            this._validateASTStructure((IterationStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof LabelledStatement) {
            this._validateASTStructure((LabelledStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof NewTarget) {
            this._validateASTStructure((NewTarget)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof PostfixExpression) {
            this._validateASTStructure((PostfixExpression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof PropertyAssignment) {
            this._validateASTStructure((PropertyAssignment)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof ReturnStatement) {
            this._validateASTStructure((ReturnStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof UnaryExpression) {
            this._validateASTStructure((UnaryExpression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof Variable) {
            this._validateASTStructure((Variable)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof VariableBinding) {
            this._validateASTStructure((VariableBinding)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof VariableStatement) {
            this._validateASTStructure((VariableStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof WithStatement) {
            this._validateASTStructure((WithStatement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof YieldExpression) {
            this._validateASTStructure((YieldExpression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof AbstractCaseClause) {
            this._validateASTStructure((AbstractCaseClause)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof Annotation) {
            this._validateASTStructure((Annotation)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof ArrayElement) {
            this._validateASTStructure((ArrayElement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof BindingElement) {
            this._validateASTStructure((BindingElement)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof Expression) {
            this._validateASTStructure((Expression)model, producer, validLabels, constraints);
            return;
        }
        if (model instanceof Script) {
            this._validateASTStructure((Script)model, producer, validLabels, constraints);
            return;
        }
        if (model != null) {
            this._validateASTStructure(model, producer, validLabels, constraints);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{model, producer, validLabels, constraints}).toString());
    }

    private void validateBlockStructure(EObject container, Block model, ASTStructureDiagnosticProducer producer, Set<LabelledStatement> validLabels, Constraints constraints) {
        if (container instanceof FunctionDefinition) {
            this._validateBlockStructure((FunctionDefinition)container, model, producer, validLabels, constraints);
            return;
        }
        if (container instanceof IfStatement) {
            this._validateBlockStructure((IfStatement)container, model, producer, validLabels, constraints);
            return;
        }
        if (container instanceof IterationStatement) {
            this._validateBlockStructure((IterationStatement)container, model, producer, validLabels, constraints);
            return;
        }
        if (container instanceof CatchBlock) {
            this._validateBlockStructure((CatchBlock)container, model, producer, validLabels, constraints);
            return;
        }
        if (container != null) {
            this._validateBlockStructure(container, model, producer, validLabels, constraints);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{container, model, producer, validLabels, constraints}).toString());
    }

    @ToString
    protected static class Constraints {
        private static final int STRICT = 1;
        private static final int N4JS = 2;
        private static final int EXTERNAL = 4;
        private static final int ALLOW_NESTED_FUNCTION_DECLARATION = 8;
        private static final int ALLOW_RETURN = 16;
        private static final int ALLOW_CONTINUE = 32;
        private static final int ALLOW_BREAK = 64;
        private static final int ALLOW_VAR_WITHOUT_INITIALIZER = 128;
        private static final int ALLOW_YIELD_EXPRESSION = 256;
        private static final int ALLOW_SUPER = 512;
        private static final int ALLOW_SUPER_CALL = 1024;
        private static final int IN_FUNCTION_DECLARATION = 2048;
        private final int bits;

        private static int getIf(int value, boolean b) {
            int _xifexpression = 0;
            _xifexpression = b ? value : 0;
            return _xifexpression;
        }

        public Constraints(boolean n4js, boolean external) {
            this(Constraints.getIf(2, n4js) | Constraints.getIf(4, external) | 0x80 | 0x100);
        }

        public Constraints(int bits) {
            this.bits = bits;
        }

        private boolean is(int bit) {
            return (this.bits & bit) != 0;
        }

        public boolean isN4JS() {
            return this.is(2);
        }

        public boolean isStrict() {
            return this.is(2) || this.is(1);
        }

        public boolean isExternal() {
            return this.is(4);
        }

        public boolean isNestedFunctionAllowed() {
            return this.is(8);
        }

        public boolean isInFunctionDeclaration() {
            return this.is(2048);
        }

        public boolean isReturnAllowed() {
            return this.is(16);
        }

        public boolean isBreakAllowed() {
            return this.is(64);
        }

        public boolean isContinueAllowed() {
            return this.is(32);
        }

        public boolean isVarInitializerRequired() {
            boolean _is = this.is(128);
            return !_is;
        }

        public boolean isYieldExpressionAllowed() {
            return this.is(256);
        }

        public boolean isSuperLiteralAllowed() {
            return this.is(512);
        }

        public boolean isSuperCallAllowed() {
            return this.is(1024);
        }

        public Constraints with(int bit, boolean set) {
            int _xifexpression = 0;
            _xifexpression = set ? this.bits | bit : this.bits & ~bit;
            int newBits = _xifexpression;
            if (newBits == this.bits) {
                return this;
            }
            return new Constraints(newBits);
        }

        public Constraints strict(boolean strict) {
            return this.with(1, strict);
        }

        public Constraints allowNestedFunctions(boolean allow) {
            return this.with(8, allow);
        }

        public Constraints allowBreak(boolean allow) {
            return this.with(64, allow);
        }

        public Constraints allowContinue(boolean allow) {
            return this.with(32, allow);
        }

        public Constraints allowReturn(boolean allow) {
            return this.with(16, allow);
        }

        public Constraints allowVarWithoutInitializer(boolean allow) {
            return this.with(128, allow);
        }

        public Constraints allowYieldExpression(boolean allow) {
            return this.with(256, allow);
        }

        public Constraints allowSuperLiteral(boolean allow) {
            Constraints _xifexpression = null;
            _xifexpression = !allow ? this.allowSuperCall(false).with(512, allow) : this.with(512, allow);
            return _xifexpression;
        }

        public Constraints allowSuperCall(boolean allow) {
            return this.with(1024, allow);
        }

        public Constraints enterFunctionDeclaration() {
            return this.with(2048, true);
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("bits", (Object)this.bits);
            return b.toString();
        }
    }
}

