/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.generator.headless.BuildSet;
import org.eclipse.n4js.generator.headless.BuildSetComputer;
import org.eclipse.n4js.generator.headless.HeadlessHelper;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.lsp.N4JSWorkspaceConfig;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.lsp.IN4JSWorkspaceConfig;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.xtext.ide.server.IWorkspaceConfigFactory;

@Singleton
public class FileBasedWorkspaceInitializer
implements IWorkspaceConfigFactory {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private BuildSetComputer buildSetComputer;
    @Inject
    private HeadlessHelper headlessHelper;
    @Inject
    private FileBasedWorkspace workspace;
    @Inject
    private NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;

    public IN4JSWorkspaceConfig getWorkspaceConfig(URI workspaceBaseURI) {
        try {
            this.workspace.clear();
            File workspaceRoot = new File(workspaceBaseURI.toFileString());
            List<FileURI> allProjects = this.collectAllProjectDirs(workspaceRoot);
            this.headlessHelper.registerProjectsToFileBasedWorkspace(allProjects, this.workspace);
            BuildSet targetPlatformBuildSet = this.computeTargetPlatformBuildSet(allProjects);
            this.headlessHelper.registerProjects(targetPlatformBuildSet, this.workspace);
            return new N4JSWorkspaceConfig(this.n4jsCore);
        }
        catch (N4JSCompileException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private BuildSet computeTargetPlatformBuildSet(Collection<? extends FileURI> workspaceProjects) throws N4JSCompileException {
        LinkedHashSet<N4JSProjectName> namesOfWorkspaceProjects = new LinkedHashSet<N4JSProjectName>();
        LinkedList<Path> n4jsProjectPaths = new LinkedList<Path>();
        for (FileURI fileURI : workspaceProjects) {
            IN4JSProject project = this.n4jsCore.create(fileURI.toURI());
            n4jsProjectPaths.add(project.getLocation().toFileSystemPath());
            namesOfWorkspaceProjects.add(project.getProjectName());
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Path nmPath : this.nodeModulesDiscoveryHelper.findNodeModulesFolders(n4jsProjectPaths)) {
            arrayList.add(nmPath.toFile());
        }
        return this.buildSetComputer.createBuildSet(arrayList, Collections.emptyList(), Collections.emptyList(), namesOfWorkspaceProjects);
    }

    private List<FileURI> collectAllProjectDirs(File workspaceRoot) {
        final ArrayList<FileURI> result = new ArrayList<FileURI>();
        Path start = workspaceRoot.toPath();
        try {
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                int nodeModuleFolderCounter = 0;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.endsWith("node_modules")) {
                        if (this.nodeModuleFolderCounter > 0) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        ++this.nodeModuleFolderCounter;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    File pckJson;
                    if (dir.endsWith("node_modules")) {
                        --this.nodeModuleFolderCounter;
                    }
                    if ((pckJson = dir.resolve("package.json").toFile()).isFile()) {
                        result.add(new FileURI(dir.toFile()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

