/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.Graphene;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public long handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MENU = 32;
    static final int OBSCURED = 64;
    static final int MOVED = 128;
    static final int RESIZED = 256;
    static final int ZERO_WIDTH = 512;
    static final int ZERO_HEIGHT = 1024;
    static final int HIDDEN = 2048;
    static final int FOREGROUND = 4096;
    static final int BACKGROUND = 8192;
    static final int FONT = 16384;
    static final int PARENT_BACKGROUND = 32768;
    static final int THEME_BACKGROUND = 65536;
    static final int LAYOUT_NEEDED = 131072;
    static final int LAYOUT_CHANGED = 262144;
    static final int LAYOUT_CHILD = 524288;
    static final int RELEASED = 0x100000;
    static final int DISPOSE_SENT = 0x200000;
    static final int FOREIGN_HANDLE = 0x400000;
    static final int DRAG_DETECT = 0x800000;
    static final int SKIN_NEEDED = 0x1000000;
    static final int CHECK_SUBWINDOW = 0x2000000;
    static final int HAS_AUTO_DIRECTION = 0;
    static final int AUTO_TEXT_DIRECTION = 0x6000000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ACTIVATE = 1;
    static final int BUTTON_PRESS_EVENT = 2;
    static final int BUTTON_PRESS_EVENT_INVERSE = 3;
    static final int BUTTON_RELEASE_EVENT = 4;
    static final int BUTTON_RELEASE_EVENT_INVERSE = 5;
    static final int CHANGED = 6;
    static final int CHANGE_VALUE = 7;
    static final int CLICKED = 8;
    static final int COMMIT = 9;
    static final int CONFIGURE_EVENT = 10;
    static final int DELETE_EVENT = 11;
    static final int DELETE_RANGE = 12;
    static final int DELETE_TEXT = 13;
    static final int ENTER_NOTIFY_EVENT = 14;
    static final int EVENT = 15;
    static final int EVENT_AFTER = 16;
    static final int EXPAND_COLLAPSE_CURSOR_ROW = 17;
    static final int EXPOSE_EVENT = 18;
    static final int DRAW = 18;
    static final int EXPOSE_EVENT_INVERSE = 19;
    static final int FOCUS = 20;
    static final int FOCUS_IN_EVENT = 21;
    static final int FOCUS_OUT_EVENT = 22;
    static final int GRAB_FOCUS = 23;
    static final int HIDE = 24;
    static final int INPUT = 25;
    static final int INSERT_TEXT = 26;
    static final int KEY_PRESS_EVENT = 27;
    static final int KEY_RELEASE_EVENT = 28;
    static final int LEAVE_NOTIFY_EVENT = 29;
    static final int MAP = 30;
    static final int MAP_EVENT = 31;
    static final int MNEMONIC_ACTIVATE = 32;
    static final int MOTION_NOTIFY_EVENT = 33;
    static final int MOTION_NOTIFY_EVENT_INVERSE = 34;
    static final int MOVE_FOCUS = 35;
    static final int OUTPUT = 36;
    static final int POPULATE_POPUP = 37;
    static final int POPUP_MENU = 38;
    static final int PREEDIT_CHANGED = 39;
    static final int REALIZE = 40;
    static final int ROW_ACTIVATED = 41;
    static final int SCROLL_CHILD = 42;
    static final int SCROLL_EVENT = 43;
    static final int SELECT = 44;
    static final int SHOW = 45;
    static final int SHOW_HELP = 46;
    static final int SIZE_ALLOCATE = 47;
    static final int STYLE_UPDATED = 48;
    static final int SWITCH_PAGE = 49;
    static final int TEST_COLLAPSE_ROW = 50;
    static final int TEST_EXPAND_ROW = 51;
    static final int TEXT_BUFFER_INSERT_TEXT = 52;
    static final int TOGGLED = 53;
    static final int UNMAP = 54;
    static final int UNMAP_EVENT = 55;
    static final int UNREALIZE = 56;
    static final int VALUE_CHANGED = 57;
    static final int WINDOW_STATE_EVENT = 59;
    static final int ACTIVATE_INVERSE = 60;
    static final int DAY_SELECTED = 61;
    static final int MONTH_CHANGED = 62;
    static final int STATUS_ICON_POPUP_MENU = 63;
    static final int ROW_INSERTED = 64;
    static final int ROW_DELETED = 65;
    static final int DAY_SELECTED_DOUBLE_CLICK = 66;
    static final int ICON_RELEASE = 67;
    static final int SELECTION_DONE = 68;
    static final int START_INTERACTIVE_SEARCH = 69;
    static final int BACKSPACE = 70;
    static final int BACKSPACE_INVERSE = 71;
    static final int COPY_CLIPBOARD = 72;
    static final int COPY_CLIPBOARD_INVERSE = 73;
    static final int CUT_CLIPBOARD = 74;
    static final int CUT_CLIPBOARD_INVERSE = 75;
    static final int PASTE_CLIPBOARD = 76;
    static final int PASTE_CLIPBOARD_INVERSE = 77;
    static final int DELETE_FROM_CURSOR = 78;
    static final int DELETE_FROM_CURSOR_INVERSE = 79;
    static final int MOVE_CURSOR = 80;
    static final int MOVE_CURSOR_INVERSE = 81;
    static final int DIRECTION_CHANGED = 82;
    static final int CREATE_MENU_PROXY = 83;
    static final int ROW_HAS_CHILD_TOGGLED = 84;
    static final int POPPED_UP = 85;
    static final int FOCUS_IN = 86;
    static final int FOCUS_OUT = 87;
    static final int IM_UPDATE = 88;
    static final int KEY_PRESSED = 89;
    static final int KEY_RELEASED = 90;
    static final int DECELERATE = 91;
    static final int SCROLL = 92;
    static final int SCROLL_BEGIN = 93;
    static final int SCROLL_END = 94;
    static final int ENTER = 95;
    static final int LEAVE = 96;
    static final int MOTION = 97;
    static final int MOTION_INVERSE = 98;
    static final int CLOSE_REQUEST = 99;
    static final int GESTURE_PRESSED = 100;
    static final int GESTURE_RELEASED = 101;
    static final int NOTIFY_STATE = 102;
    static final int SIZE_ALLOCATE_GTK4 = 103;
    static final int LAST_SIGNAL = 104;
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static final String KEY_GTK_CSS = "org.eclipse.swt.internal.gtk.css";
    static Callback gdkSeatGrabPrepareFunc;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    long paintWindow() {
        return 0L;
    }

    long paintSurface() {
        return 0L;
    }

    long cssHandle() {
        return this.handle;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    long cellDataProc(long tree_column, long cell, long tree_model, long iter, long data) {
        return 0L;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int index) {
    }

    void createWidget(int index) {
        this.createHandle(index);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        long topHandle = this.topHandle();
        this.releaseHandle();
        if (topHandle != 0L && (this.state & 8) != 0) {
            GTK.gtk_widget_destroy(topHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void error(int code) {
        SWT.error(code);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(KEY_CHECK_SUBWINDOW)) {
            if ((this.state & 0x2000000) != 0) {
                return true;
            }
            return false;
        }
        if (key.equals(IS_ACTIVE)) {
            return this.isActive();
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.length();
        while (--index > 0 && string.charAt(index) != '.') {
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    long gtk_activate(long widget) {
        return 0L;
    }

    void gtk_adjustment_get(long hAdjustment, GtkAdjustment adjustment) {
        adjustment.lower = GTK.gtk_adjustment_get_lower(hAdjustment);
        adjustment.upper = GTK.gtk_adjustment_get_upper(hAdjustment);
        adjustment.page_increment = GTK.gtk_adjustment_get_page_increment(hAdjustment);
        adjustment.step_increment = GTK.gtk_adjustment_get_step_increment(hAdjustment);
        adjustment.page_size = GTK.gtk_adjustment_get_page_size(hAdjustment);
        adjustment.value = GTK.gtk_adjustment_get_value(hAdjustment);
    }

    long gtk_button_press_event(long widget, long event) {
        return 0L;
    }

    long gtk_button_release_event(long widget, long event) {
        return 0L;
    }

    long gtk_gesture_press_event(long gesture, int n_press, double x, double y, long event) {
        return 0L;
    }

    long gtk_gesture_release_event(long gesture, int n_press, double x, double y, long event) {
        return 0L;
    }

    long gtk_changed(long widget) {
        return 0L;
    }

    long gtk_change_value(long widget, long scroll, long value1, long value2) {
        return 0L;
    }

    long gtk_clicked(long widget) {
        return 0L;
    }

    long gtk_close_request(long widget) {
        return 0L;
    }

    long gtk_commit(long imcontext, long text) {
        return 0L;
    }

    long gtk_configure_event(long widget, long event) {
        return 0L;
    }

    long gtk_create_menu_proxy(long widget) {
        return 0L;
    }

    long gtk_day_selected(long widget) {
        return 0L;
    }

    long gtk_day_selected_double_click(long widget) {
        return 0L;
    }

    long gtk_delete_event(long widget, long event) {
        return 0L;
    }

    long gtk_delete_range(long widget, long iter1, long iter2) {
        return 0L;
    }

    long gtk_delete_text(long widget, long start_pos, long end_pos) {
        return 0L;
    }

    long gtk_enter_notify_event(long widget, long event) {
        return 0L;
    }

    long gtk_event(long widget, long event) {
        return 0L;
    }

    long gtk_event_after(long widget, long event) {
        return 0L;
    }

    long gtk_expand_collapse_cursor_row(long widget, long logical, long expand, long open_all) {
        return 0L;
    }

    long gtk_draw(long widget, long cairo) {
        return 0L;
    }

    long gtk_focus(long widget, long event) {
        return 0L;
    }

    long gtk_focus_in_event(long widget, long event) {
        return 0L;
    }

    long gtk_focus_out_event(long widget, long event) {
        return 0L;
    }

    long gtk_grab_focus(long widget) {
        return 0L;
    }

    long gtk_hide(long widget) {
        return 0L;
    }

    long gtk_icon_release(long widget, long icon_pos, long event) {
        return 0L;
    }

    long gtk_input(long widget, long arg1) {
        return 0L;
    }

    long gtk_insert_text(long widget, long new_text, long new_text_length, long position) {
        return 0L;
    }

    long gtk_key_press_event(long widget, long event) {
        return this.sendKeyEvent(1, event) ? 0 : 1;
    }

    long gtk_key_release_event(long widget, long event) {
        return this.sendKeyEvent(2, event) ? 0 : 1;
    }

    long gtk_leave_notify_event(long widget, long event) {
        return 0L;
    }

    long gtk_map(long widget) {
        return 0L;
    }

    long gtk_map_event(long widget, long event) {
        return 0L;
    }

    long gtk_menu_popped_up(long widget, long flipped_rect, long final_rect, long flipped_x, long flipped_y) {
        return 0L;
    }

    long gtk_mnemonic_activate(long widget, long arg1) {
        return 0L;
    }

    long gtk_month_changed(long widget) {
        return 0L;
    }

    long gtk_motion_notify_event(long widget, long event) {
        return 0L;
    }

    long gtk_move_focus(long widget, long event) {
        return 0L;
    }

    long gtk_output(long widget) {
        return 0L;
    }

    long gtk_populate_popup(long widget, long menu) {
        return 0L;
    }

    long gtk_popup_menu(long widget) {
        return 0L;
    }

    long gtk_preedit_changed(long imcontext) {
        return 0L;
    }

    long gtk_realize(long widget) {
        return 0L;
    }

    long gtk_row_activated(long tree, long path, long column) {
        return 0L;
    }

    long gtk_row_deleted(long model, long path) {
        return 0L;
    }

    long gtk_row_inserted(long model, long path, long iter) {
        return 0L;
    }

    long gtk_row_has_child_toggled(long model, long path, long iter) {
        return 0L;
    }

    long gtk_scroll_child(long widget, long scrollType, long horizontal) {
        return 0L;
    }

    long gtk_scroll_event(long widget, long event) {
        return 0L;
    }

    long gtk_select(long item) {
        return 0L;
    }

    long gtk_selection_done(long menushell) {
        return 0L;
    }

    long gtk_show(long widget) {
        return 0L;
    }

    long gtk_show_help(long widget, long helpType) {
        return 0L;
    }

    long gtk_size_allocate(long widget, long allocation) {
        return 0L;
    }

    long gtk_status_icon_popup_menu(long handle, long button, long activate_time) {
        return 0L;
    }

    long gtk_start_interactive_search(long widget) {
        return 0L;
    }

    long gtk_style_updated(long widget) {
        return 0L;
    }

    long gtk_switch_page(long widget, long page, long page_num) {
        return 0L;
    }

    long gtk_test_collapse_row(long tree, long iter, long path) {
        return 0L;
    }

    long gtk_test_expand_row(long tree, long iter, long path) {
        return 0L;
    }

    long gtk_text_buffer_insert_text(long widget, long iter, long text, long length) {
        return 0L;
    }

    long gtk_timer() {
        return 0L;
    }

    long gtk_toggled(long renderer, long pathStr) {
        return 0L;
    }

    boolean gtk_tree_view_column_cell_get_position(long column, long cell_renderer, int[] start_pos, int[] width) {
        Callback.setEnabled(false);
        boolean result = GTK.gtk_tree_view_column_cell_get_position(column, cell_renderer, start_pos, width);
        Callback.setEnabled(true);
        return result;
    }

    long gtk_unmap(long widget) {
        return 0L;
    }

    long gtk_unmap_event(long widget, long event) {
        return 0L;
    }

    long gtk_unrealize(long widget) {
        return 0L;
    }

    long gtk_value_changed(long adjustment) {
        return 0L;
    }

    long gtk_window_state_event(long widget, long event) {
        return 0L;
    }

    int fontHeight(long font, long widgetHandle) {
        long context = GTK.gtk_widget_get_pango_context(widgetHandle);
        long lang = OS.pango_context_get_language(context);
        long metrics = OS.pango_context_get_metrics(context, font, lang);
        int ascent = OS.pango_font_metrics_get_ascent(metrics);
        int descent = OS.pango_font_metrics_get_descent(metrics);
        OS.pango_font_metrics_unref(metrics);
        return OS.PANGO_PIXELS(ascent + descent);
    }

    long filterProc(long xEvent, long gdkEvent, long data2) {
        return 0L;
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, true);
    }

    char[] fixMnemonic(String string, boolean replace) {
        return this.fixMnemonic(string, replace, false);
    }

    char[] fixMnemonic(String string, boolean replace, boolean removeAppended) {
        int length = string.length();
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        int i = 0;
        int j = 0;
        char[] result = new char[length * 2];
        while (i < length) {
            switch (text[i]) {
                case '&': {
                    if (i + 1 < length && text[i + 1] == '&') {
                        result[j++] = text[i++];
                    } else if (replace) {
                        result[j++] = 95;
                    }
                    ++i;
                    break;
                }
                case '(': {
                    if (removeAppended && i + 4 == string.length() && text[i + 1] == '&' && text[i + 3] == ')') {
                        if (replace) {
                            result[j++] = 32;
                        }
                        i += 4;
                        break;
                    }
                }
                case '_': {
                    if (replace) {
                        result[j++] = 95;
                    }
                }
                default: {
                    result[j++] = text[i++];
                }
            }
        }
        return result;
    }

    boolean isActive() {
        return true;
    }

    public boolean isAutoDirection() {
        return false;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    long hoverProc(long widget) {
        return 0L;
    }

    boolean mnemonicHit(long mnemonicHandle, char key) {
        if (!this.mnemonicMatch(mnemonicHandle, key)) {
            return false;
        }
        OS.g_signal_handlers_block_matched(mnemonicHandle, 16, 0, 0, 0L, 0L, 32L);
        boolean result = GTK.gtk_widget_mnemonic_activate(mnemonicHandle, false);
        OS.g_signal_handlers_unblock_matched(mnemonicHandle, 16, 0, 0, 0L, 0L, 32L);
        return result;
    }

    boolean mnemonicMatch(long mnemonicHandle, char key) {
        long keyval2;
        long keyval1 = GDK.gdk_keyval_to_lower(GDK.gdk_unicode_to_keyval(key));
        return keyval1 == (keyval2 = GDK.gdk_keyval_to_lower(GTK.gtk_label_get_mnemonic_keyval(mnemonicHandle)));
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void register() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void release(boolean destroy) {
        if ((this.state & 0x200000) == 0) {
            this.state |= 0x200000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x100000) == 0) {
            this.state |= 0x100000;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.handle = 0L;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    long rendererGetPreferredWidthProc(long cell, long handle, long minimun_size, long natural_size) {
        return 0L;
    }

    long rendererRenderProc(long cell, long cr, long handle, long background_area, long cell_area, long flags) {
        return 0L;
    }

    long rendererSnapshotProc(long cell, long snapshot, long handle, long background_area, long cell_area, long flags) {
        return 0L;
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x1000000) != 0x1000000) {
            this.state |= 0x1000000;
            this.display.addSkinnableWidget(this);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            display.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int type, long event) {
        int length;
        long string;
        if (GTK.GTK4) {
            long[] eventString = new long[1];
            GDK.gdk_event_get_string(event, eventString);
            string = eventString[0];
            length = (int)OS.g_utf16_strlen(string, -1L);
        } else {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
            length = gdkEvent.length;
            string = gdkEvent.string;
        }
        if (string == 0L || OS.g_utf16_strlen(string, length) <= 1L) {
            Event javaEvent = new Event();
            javaEvent.time = GDK.gdk_event_get_time(event);
            if (!this.setKeyState(javaEvent, event)) {
                return true;
            }
            this.sendEvent(type, javaEvent);
            if (this.isDisposed()) {
                return false;
            }
            return javaEvent.doit;
        }
        byte[] buffer = new byte[length];
        C.memmove(buffer, string, (long)length);
        char[] chars = Converter.mbcsToWcs(buffer);
        return this.sendIMKeyEvent(type, event, chars) != null;
    }

    char[] sendIMKeyEvent(int type, long event, char[] chars) {
        int index = 0;
        int count = 0;
        int state = 0;
        long ptr = 0L;
        if (event == 0L) {
            ptr = GTK.gtk_get_current_event();
            if (ptr != 0L) {
                int eventType = GDK.gdk_event_get_event_type(ptr);
                eventType = Control.fixGdkEventTypeValues(eventType);
                switch (eventType) {
                    case 8: 
                    case 9: {
                        int[] eventState = new int[1];
                        GDK.gdk_event_get_state(ptr, eventState);
                        state = eventState[0];
                        break;
                    }
                    default: {
                        event = 0L;
                        break;
                    }
                }
            } else {
                int[] buffer = new int[1];
                GTK.gtk_get_current_event_state(buffer);
                state = buffer[0];
            }
        } else {
            ptr = event;
        }
        while (index < chars.length) {
            Event javaEvent = new Event();
            if (ptr != 0L && chars.length <= 1) {
                this.setKeyState(javaEvent, ptr);
            } else {
                this.setInputState(javaEvent, state);
            }
            javaEvent.character = chars[index];
            this.sendEvent(type, javaEvent);
            if (this.isDisposed()) {
                if (ptr != 0L && ptr != event) {
                    this.gdk_event_free(ptr);
                }
                return null;
            }
            if (javaEvent.doit) {
                chars[count++] = chars[index];
            }
            ++index;
        }
        if (ptr != 0L && ptr != event) {
            this.gdk_event_free(ptr);
        }
        if (count == 0) {
            return null;
        }
        if (index != count) {
            char[] result = new char[count];
            System.arraycopy(chars, 0, result, 0, count);
            return result;
        }
        return chars;
    }

    void sendSelectionEvent(int eventType) {
        this.sendSelectionEvent(eventType, null, false);
    }

    void sendSelectionEvent(int eventType, Event event, boolean send) {
        long ptr;
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((ptr = GTK.gtk_get_current_event()) != 0L) {
            int currentEventType = GDK.gdk_event_get_event_type(ptr);
            currentEventType = Control.fixGdkEventTypeValues(currentEventType);
            switch (currentEventType) {
                case 4: 
                case 5: 
                case 7: {
                    int[] eventButton = new int[1];
                    GDK.gdk_event_get_button(ptr, eventButton);
                    this.setButtonState(event, eventButton[0]);
                }
                case 8: 
                case 9: {
                    int[] state = new int[1];
                    GDK.gdk_event_get_state(ptr, state);
                    this.setInputState(event, state[0]);
                }
            }
            this.gdk_event_free(ptr);
        }
        this.sendEvent(eventType, event, send);
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(KEY_CHECK_SUBWINDOW)) {
            if (value != null && value instanceof Boolean) {
                this.state = ((Boolean)value).booleanValue() ? (this.state |= 0x2000000) : (this.state &= 0xFDFFFFFF);
            }
            return;
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) && key.equals(KEY_GTK_CSS) && value instanceof String) {
            long context = GTK.gtk_widget_get_style_context(this.cssHandle());
            long provider = GTK.gtk_css_provider_new();
            if (context != 0L && provider != 0L) {
                GTK.gtk_style_context_add_provider(context, provider, 800);
                if (GTK.GTK4) {
                    GTK.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs((String)value, true), -1L);
                } else {
                    GTK.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs((String)value, true), -1L, null);
                }
                OS.g_object_unref(provider);
            }
        }
    }

    void setFontDescription(long widget, long font) {
        GTK.gtk_widget_override_font(widget, font);
        long context = GTK.gtk_widget_get_style_context(widget);
        GTK.gtk_style_context_invalidate(context);
    }

    void setButtonState(Event event, int eventButton) {
        switch (eventButton) {
            case 1: {
                event.stateMask |= 0x80000;
                break;
            }
            case 2: {
                event.stateMask |= 0x100000;
                break;
            }
            case 3: {
                event.stateMask |= 0x200000;
                break;
            }
            case 4: {
                event.stateMask |= 0x800000;
                break;
            }
            case 5: {
                event.stateMask |= 0x2000000;
            }
        }
    }

    boolean setInputState(Event event, int state) {
        if ((state & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((state & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((state & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event javaEvent, long event) {
        int group;
        int length;
        long string;
        int[] eventKeyval = new int[1];
        GDK.gdk_event_get_keyval(event, eventKeyval);
        int[] eventState = new int[1];
        GDK.gdk_event_get_state(event, eventState);
        if (GTK.GTK4) {
            long[] eventString = new long[1];
            GDK.gdk_event_get_string(event, eventString);
            string = eventString[0];
            length = (int)OS.g_utf16_strlen(string, -1L);
            int[] eventGroup = new int[1];
            GDK.gdk_event_get_key_group(event, eventGroup);
            group = eventGroup[0];
        } else {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
            length = gdkEvent.length;
            string = gdkEvent.string;
            group = gdkEvent.group;
        }
        if (string != 0L && OS.g_utf16_strlen(string, length) > 1L) {
            return false;
        }
        boolean isNull = false;
        javaEvent.keyCode = Display.translateKey(eventKeyval[0]);
        switch (eventKeyval[0]) {
            case 65288: {
                javaEvent.character = (char)8;
                break;
            }
            case 65290: {
                javaEvent.character = (char)10;
                break;
            }
            case 65293: 
            case 65421: {
                javaEvent.character = (char)13;
                break;
            }
            case 65439: 
            case 65535: {
                javaEvent.character = (char)127;
                break;
            }
            case 65307: {
                javaEvent.character = (char)27;
                break;
            }
            case 65056: 
            case 65289: {
                javaEvent.character = (char)9;
                break;
            }
            default: {
                if (javaEvent.keyCode == 0) {
                    int[] keyval = new int[1];
                    int[] effective_group = new int[1];
                    int[] level = new int[1];
                    int[] consumed_modifiers = new int[1];
                    Map<Integer, Integer> groupLatinKeysCount = this.display.getGroupKeysCount();
                    if (!groupLatinKeysCount.containsKey(group)) {
                        group = this.display.getLatinKeyGroup();
                    }
                    long keymap = 0L;
                    long display = GDK.gdk_display_get_default();
                    keymap = GTK.GTK4 ? GDK.gdk_display_get_keymap(display) : GDK.gdk_keymap_get_for_display(display);
                    short[] keyCode = new short[1];
                    GDK.gdk_event_get_keycode(event, keyCode);
                    if (GDK.gdk_keymap_translate_keyboard_state(keymap, keyCode[0], 0, group, keyval, effective_group, level, consumed_modifiers)) {
                        javaEvent.keyCode = (int)GDK.gdk_keyval_to_unicode(keyval[0]);
                    }
                }
                int key = eventKeyval[0];
                if ((eventState[0] & 4) != 0 && key >= 0 && key <= 127) {
                    if (97 <= key && key <= 122) {
                        key -= 32;
                    }
                    if (64 <= key && key <= 95) {
                        key -= 64;
                    }
                    javaEvent.character = (char)key;
                    isNull = eventKeyval[0] == 64 && key == 0;
                    break;
                }
                javaEvent.character = (char)GDK.gdk_keyval_to_unicode(key);
            }
        }
        this.setLocationState(javaEvent, event);
        if (javaEvent.keyCode == 0 && javaEvent.character == '\u0000' && !isNull) {
            return false;
        }
        return this.setInputState(javaEvent, eventState[0]);
    }

    void setLocationState(Event event, long eventPtr) {
        int[] eventKeyval = new int[1];
        GDK.gdk_event_get_keyval(eventPtr, eventKeyval);
        switch (eventKeyval[0]) {
            case 65505: 
            case 65507: 
            case 65513: {
                event.keyLocation = 16384;
                break;
            }
            case 65506: 
            case 65508: 
            case 65514: {
                event.keyLocation = 131072;
                break;
            }
            case 65407: 
            case 65421: 
            case 65429: 
            case 65430: 
            case 65431: 
            case 65432: 
            case 65433: 
            case 65434: 
            case 65435: 
            case 65436: 
            case 65438: 
            case 65439: 
            case 65450: 
            case 65451: 
            case 65453: 
            case 65454: 
            case 65455: 
            case 65456: 
            case 65457: 
            case 65458: 
            case 65459: 
            case 65460: 
            case 65461: 
            case 65462: 
            case 65463: 
            case 65464: 
            case 65465: 
            case 65469: {
                event.keyLocation = 2;
            }
        }
    }

    void setOrientation(boolean create) {
    }

    boolean setTabGroupFocus(boolean next) {
        return this.setTabItemFocus(next);
    }

    boolean setTabItemFocus(boolean next) {
        return false;
    }

    long shellMapProc(long handle, long arg0, long user_data) {
        return 0L;
    }

    long sizeAllocateProc(long handle, long arg0, long user_data) {
        return 0L;
    }

    long sizeRequestProc(long handle, long arg0, long user_data) {
        return 0L;
    }

    void snapshotToDraw(long handle, long snapshot) {
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(handle, allocation);
        long rect = Graphene.graphene_rect_alloc();
        Graphene.graphene_rect_init(rect, 0.0f, 0.0f, allocation.width, allocation.height);
        long cairo = GTK.gtk_snapshot_append_cairo(snapshot, rect);
        if (cairo != 0L) {
            this.gtk_draw(handle, cairo);
        }
        Graphene.graphene_rect_free(rect);
    }

    long gtk_widget_get_window(long widget) {
        GTK.gtk_widget_realize(widget);
        return GTK.gtk_widget_get_window(widget);
    }

    long gtk_widget_get_surface(long widget) {
        GTK.gtk_widget_realize(widget);
        return GTK.gtk_widget_get_surface(widget);
    }

    void gtk_widget_set_has_surface_or_window(long widget, boolean has) {
        if (GTK.GTK4) {
            if (has && OS.G_OBJECT_TYPE(widget) == OS.swt_fixed_get_type()) {
                return;
            }
            GTK.gtk_widget_set_has_surface(widget, has);
        } else {
            GTK.gtk_widget_set_has_window(widget, has);
        }
    }

    boolean gtk_widget_get_has_surface_or_window(long widget) {
        if (GTK.GTK4) {
            return GTK.gtk_widget_get_has_surface(widget);
        }
        return GTK.gtk_widget_get_has_window(widget);
    }

    void gtk_widget_set_visible(long widget, boolean visible) {
        GTK.gtk_widget_set_visible(widget, visible);
    }

    void gdk_window_get_size(long drawable, int[] width, int[] height) {
        width[0] = GDK.gdk_window_get_width(drawable);
        height[0] = GDK.gdk_window_get_height(drawable);
    }

    void gdk_surface_get_size(long surface, int[] width, int[] height) {
        width[0] = GDK.gdk_surface_get_width(surface);
        height[0] = GDK.gdk_surface_get_height(surface);
    }

    void gdk_event_free(long event) {
        if (event == 0L) {
            return;
        }
        if (GTK.GTK4) {
            OS.g_object_unref(event);
        } else {
            GDK.gdk_event_free(event);
        }
    }

    long gdk_event_get_surface_or_window(long event) {
        if (event == 0L) {
            return 0L;
        }
        if (GTK.GTK4) {
            return GDK.gdk_event_get_surface(event);
        }
        return GDK.gdk_event_get_window(event);
    }

    long gdk_event_peek() {
        if (GTK.GTK4) {
            long display = GDK.gdk_display_get_default();
            return GDK.gdk_display_peek_event(display);
        }
        return GDK.gdk_event_peek();
    }

    int gdk_event_get_state(long event) {
        int[] state = new int[1];
        GDK.gdk_event_get_state(event, state);
        return state[0];
    }

    long gtk_box_new(int orientation, boolean homogeneous, int spacing) {
        long box = GTK.gtk_box_new(orientation, spacing);
        GTK.gtk_box_set_homogeneous(box, homogeneous);
        return box;
    }

    void gtk_box_set_child_packing(long box, long child, boolean expand, boolean fill, int padding, int pack_type) {
        if (GTK.GTK4) {
            GTK.gtk_widget_set_hexpand(child, expand);
            GTK.gtk_widget_set_vexpand(child, expand);
            if (fill) {
                GTK.gtk_widget_set_halign(child, 0);
                GTK.gtk_widget_set_valign(child, 0);
            }
            GTK.gtk_box_set_child_packing(box, child, pack_type);
            OS.g_object_set(box, OS.margin, padding, 0L);
        } else {
            GTK.gtk_box_set_child_packing(box, child, expand, fill, padding, pack_type);
        }
    }

    void gtk_box_pack_end(long box, long child, boolean expand, boolean fill, int padding) {
        if (GTK.GTK4) {
            GTK.gtk_widget_set_hexpand(child, expand);
            GTK.gtk_widget_set_vexpand(child, expand);
            if (fill) {
                GTK.gtk_widget_set_halign(child, 0);
                GTK.gtk_widget_set_valign(child, 0);
            }
            OS.g_object_set(box, OS.margin, padding, 0L);
            GTK.gtk_box_pack_end(box, child);
        } else {
            GTK.gtk_box_pack_end(box, child, expand, fill, padding);
        }
    }

    int gdk_pointer_grab(long gdkResource, int grab_ownership, boolean owner_events, int event_mask, long confine_to, long cursor, int time_) {
        long display = 0L;
        if (GTK.GTK4) {
            if (gdkResource != 0L) {
                display = GDK.gdk_surface_get_display(gdkResource);
            }
        } else if (gdkResource != 0L) {
            display = GDK.gdk_window_get_display(gdkResource);
        } else {
            gdkResource = GDK.gdk_get_default_root_window();
            display = GDK.gdk_window_get_display(gdkResource);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
            long gdkSeatGrabPrepareFuncAddress;
            long seat = GDK.gdk_display_get_default_seat(display);
            if (gdkSeatGrabPrepareFunc == null) {
                gdkSeatGrabPrepareFunc = new Callback(Widget.class, "GdkSeatGrabPrepareFunc", 3);
            }
            if ((gdkSeatGrabPrepareFuncAddress = gdkSeatGrabPrepareFunc.getAddress()) == 0L) {
                SWT.error(3);
            }
            return GDK.gdk_seat_grab(seat, gdkResource, 7, owner_events, cursor, 0L, gdkSeatGrabPrepareFuncAddress, gdkResource);
        }
        long pointer = GDK.gdk_get_pointer(display);
        return GDK.gdk_device_grab(pointer, gdkResource, grab_ownership, owner_events, event_mask, cursor, time_);
    }

    void gdk_pointer_ungrab(long gdkResource, int time_) {
        long display;
        long l = display = GTK.GTK4 ? GDK.gdk_surface_get_display(gdkResource) : GDK.gdk_window_get_display(gdkResource);
        if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
            long seat = GDK.gdk_display_get_default_seat(display);
            GDK.gdk_seat_ungrab(seat);
        } else {
            long pointer = GDK.gdk_get_pointer(display);
            GDK.gdk_device_ungrab(pointer, time_);
        }
    }

    static long GdkSeatGrabPrepareFunc(long gdkSeat, long gdkResource, long userData_gdkResource) {
        if (userData_gdkResource != 0L) {
            if (GTK.GTK4) {
                GDK.gdk_surface_show(userData_gdkResource);
            } else {
                GDK.gdk_window_show(userData_gdkResource);
            }
        }
        return 0L;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    long topHandle() {
        return this.handle;
    }

    long timerProc(long widget) {
        return 0L;
    }

    boolean translateTraversal(int event) {
        return false;
    }

    long enterMotionScrollProc(long handle, double x, double y, long user_data) {
        long event = GTK.gtk_get_current_event();
        long result = 0L;
        switch ((int)user_data) {
            case 95: {
                result = this.gtk_enter_notify_event(handle, event);
                break;
            }
            case 97: {
                result = this.gtk_motion_notify_event(handle, event);
                break;
            }
            case 98: {
                result = 1L;
                break;
            }
            case 92: {
                result = this.gtk_scroll_event(handle, event);
            }
        }
        this.gdk_event_free(event);
        return result;
    }

    long focusProc(long handle, long user_data) {
        long event = GTK.gtk_get_current_event();
        long result = 0L;
        switch ((int)user_data) {
            case 86: {
                result = this.gtk_focus_in_event(handle, event);
                break;
            }
            case 87: {
                result = this.gtk_focus_out_event(handle, event);
            }
        }
        this.gdk_event_free(event);
        return result;
    }

    long keyPressReleaseProc(long handle, int keyval, int keycode, int state, long user_data) {
        long event = GTK.gtk_get_current_event();
        long result = 0L;
        switch ((int)user_data) {
            case 89: {
                result = this.gtk_key_press_event(handle, event);
                break;
            }
            case 90: {
                result = this.gtk_key_release_event(handle, event);
            }
        }
        this.gdk_event_free(event);
        return result;
    }

    long getsurePressReleaseProc(long gesture, int n_press, double x, double y, long user_data) {
        long event = GTK.gtk_get_current_event();
        long result = 0L;
        switch ((int)user_data) {
            case 100: {
                result = this.gtk_gesture_press_event(gesture, n_press, x, y, event);
                break;
            }
            case 101: {
                result = this.gtk_gesture_release_event(gesture, n_press, x, y, event);
            }
        }
        this.gdk_event_free(event);
        return result;
    }

    long leaveProc(long handle, long user_data) {
        long event = GTK.gtk_get_current_event();
        long result = 0L;
        switch ((int)user_data) {
            case 96: {
                result = this.gtk_leave_notify_event(handle, event);
            }
        }
        this.gdk_event_free(event);
        return result;
    }

    long notifyStateProc(long gdk_handle, long handle) {
        return 0L;
    }

    long windowProc(long handle, long user_data) {
        switch ((int)user_data) {
            case 1: {
                return this.gtk_activate(handle);
            }
            case 6: {
                return this.gtk_changed(handle);
            }
            case 8: {
                return this.gtk_clicked(handle);
            }
            case 99: {
                return this.gtk_close_request(handle);
            }
            case 83: {
                return this.gtk_create_menu_proxy(handle);
            }
            case 61: {
                return this.gtk_day_selected(handle);
            }
            case 66: {
                return this.gtk_day_selected_double_click(handle);
            }
            case 24: {
                return this.gtk_hide(handle);
            }
            case 23: {
                return this.gtk_grab_focus(handle);
            }
            case 30: {
                return this.gtk_map(handle);
            }
            case 62: {
                return this.gtk_month_changed(handle);
            }
            case 36: {
                return this.gtk_output(handle);
            }
            case 38: {
                return this.gtk_popup_menu(handle);
            }
            case 39: {
                return this.gtk_preedit_changed(handle);
            }
            case 40: {
                return this.gtk_realize(handle);
            }
            case 69: {
                return this.gtk_start_interactive_search(handle);
            }
            case 48: {
                return this.gtk_style_updated(handle);
            }
            case 44: {
                return this.gtk_select(handle);
            }
            case 68: {
                return this.gtk_selection_done(handle);
            }
            case 45: {
                return this.gtk_show(handle);
            }
            case 57: {
                return this.gtk_value_changed(handle);
            }
            case 54: {
                return this.gtk_unmap(handle);
            }
            case 56: {
                return this.gtk_unrealize(handle);
            }
        }
        return 0L;
    }

    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 19: {
                if (GTK.GTK_IS_CONTAINER(handle)) {
                    return this.gtk_draw(handle, arg0);
                }
                return 0L;
            }
            case 3: 
            case 5: 
            case 34: {
                return 1L;
            }
            case 2: {
                return this.gtk_button_press_event(handle, arg0);
            }
            case 4: {
                return this.gtk_button_release_event(handle, arg0);
            }
            case 9: {
                return this.gtk_commit(handle, arg0);
            }
            case 10: {
                return this.gtk_configure_event(handle, arg0);
            }
            case 11: {
                return this.gtk_delete_event(handle, arg0);
            }
            case 14: {
                return this.gtk_enter_notify_event(handle, arg0);
            }
            case 15: {
                return this.gtk_event(handle, arg0);
            }
            case 16: {
                return this.gtk_event_after(handle, arg0);
            }
            case 18: {
                if (!GTK.GTK_IS_CONTAINER(handle)) {
                    return this.gtk_draw(handle, arg0);
                }
                return 0L;
            }
            case 20: {
                return this.gtk_focus(handle, arg0);
            }
            case 21: {
                return this.gtk_focus_in_event(handle, arg0);
            }
            case 22: {
                return this.gtk_focus_out_event(handle, arg0);
            }
            case 27: {
                return this.gtk_key_press_event(handle, arg0);
            }
            case 28: {
                return this.gtk_key_release_event(handle, arg0);
            }
            case 25: {
                return this.gtk_input(handle, arg0);
            }
            case 29: {
                return this.gtk_leave_notify_event(handle, arg0);
            }
            case 31: {
                return this.gtk_map_event(handle, arg0);
            }
            case 32: {
                return this.gtk_mnemonic_activate(handle, arg0);
            }
            case 33: {
                return this.gtk_motion_notify_event(handle, arg0);
            }
            case 35: {
                return this.gtk_move_focus(handle, arg0);
            }
            case 37: {
                return this.gtk_populate_popup(handle, arg0);
            }
            case 43: {
                return this.gtk_scroll_event(handle, arg0);
            }
            case 46: {
                return this.gtk_show_help(handle, arg0);
            }
            case 47: {
                return this.gtk_size_allocate(handle, arg0);
            }
            case 53: {
                return this.gtk_toggled(handle, arg0);
            }
            case 55: {
                return this.gtk_unmap_event(handle, arg0);
            }
            case 59: {
                return this.gtk_window_state_event(handle, arg0);
            }
            case 65: {
                return this.gtk_row_deleted(handle, arg0);
            }
        }
        return 0L;
    }

    long windowProc(long handle, long arg0, long arg1, long user_data) {
        switch ((int)user_data) {
            case 12: {
                return this.gtk_delete_range(handle, arg0, arg1);
            }
            case 13: {
                return this.gtk_delete_text(handle, arg0, arg1);
            }
            case 67: {
                return this.gtk_icon_release(handle, arg0, arg1);
            }
            case 41: {
                return this.gtk_row_activated(handle, arg0, arg1);
            }
            case 42: {
                return this.gtk_scroll_child(handle, arg0, arg1);
            }
            case 63: {
                return this.gtk_status_icon_popup_menu(handle, arg0, arg1);
            }
            case 49: {
                return this.gtk_switch_page(handle, arg0, arg1);
            }
            case 50: {
                return this.gtk_test_collapse_row(handle, arg0, arg1);
            }
            case 51: {
                return this.gtk_test_expand_row(handle, arg0, arg1);
            }
            case 64: {
                return this.gtk_row_inserted(handle, arg0, arg1);
            }
            case 84: {
                return this.gtk_row_has_child_toggled(handle, arg0, arg1);
            }
            case 103: {
                return this.gtk_size_allocate(handle, arg0);
            }
        }
        return 0L;
    }

    long windowProc(long handle, long arg0, long arg1, long arg2, long user_data) {
        switch ((int)user_data) {
            case 7: {
                return this.gtk_change_value(handle, arg0, arg1, arg2);
            }
            case 17: {
                return this.gtk_expand_collapse_cursor_row(handle, arg0, arg1, arg2);
            }
            case 26: {
                return this.gtk_insert_text(handle, arg0, arg1, arg2);
            }
            case 52: {
                return this.gtk_text_buffer_insert_text(handle, arg0, arg1, arg2);
            }
        }
        return 0L;
    }

    long windowProc(long handle, long arg0, long arg1, long arg2, long arg3, long user_data) {
        switch ((int)user_data) {
            case 85: {
                return this.gtk_menu_popped_up(handle, arg0, arg1, arg2, arg3);
            }
        }
        return 0L;
    }

    void gtk_cell_renderer_get_preferred_size(long cell, long widget, int[] width, int[] height) {
        GtkRequisition minimum_size = new GtkRequisition();
        GTK.gtk_cell_renderer_get_preferred_size(cell, widget, minimum_size, null);
        if (width != null) {
            width[0] = minimum_size.width;
        }
        if (height != null) {
            height[0] = minimum_size.height;
        }
    }

    void gtk_widget_get_preferred_size(long widget, GtkRequisition requisition) {
        GTK.gtk_widget_get_preferred_size(widget, requisition, null);
    }

    void gtk_image_set_from_gicon(long imageHandle, long pixbuf) {
        GTK.gtk_image_set_from_gicon(imageHandle, pixbuf, 2);
    }

    int gtk_container_get_border_width_or_margin(long handle) {
        if (GTK.GTK4) {
            int marginTop = GTK.gtk_widget_get_margin_top(handle);
            int marginBottom = GTK.gtk_widget_get_margin_bottom(handle);
            int marginStart = GTK.gtk_widget_get_margin_start(handle);
            int marginEnd = GTK.gtk_widget_get_margin_end(handle);
            return Math.max(Math.max(marginTop, marginBottom), Math.max(marginStart, marginEnd));
        }
        return GTK.gtk_container_get_border_width(handle);
    }

    void gtk_container_set_border_width(long handle, int border_width) {
        if (GTK.GTK4) {
            GTK.gtk_widget_set_margin_top(handle, border_width);
            GTK.gtk_widget_set_margin_bottom(handle, border_width);
            GTK.gtk_widget_set_margin_start(handle, border_width);
            GTK.gtk_widget_set_margin_end(handle, border_width);
        } else {
            GTK.gtk_container_set_border_width(handle, border_width);
        }
    }
}

