/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CloseUnrelatedProjectsAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class N4JSProjectActionGroup
extends ActionGroup {
    private static final int CLOSED_PROJECTS_SELECTED = 1;
    private static final int NON_PROJECT_SELECTED = 2;
    private final OpenProjectAction openAction;
    private final CloseResourceAction closeAction;
    private final CloseResourceAction closeUnrelatedAction;
    private final ISelectionChangedListener selectionChangedListener;
    private ISelectionProvider selectionProvider;
    private boolean enableOpenInContextMenu = true;
    private boolean enableContribution = true;

    public N4JSProjectActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getSelectionProvider());
    }

    public N4JSProjectActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        ISelection selection = selectionProvider.getSelection();
        this.closeAction = new CloseResourceAction((IShellProvider)site);
        this.closeAction.setActionDefinitionId("org.eclipse.ui.project.closeProject");
        this.closeUnrelatedAction = new CloseUnrelatedProjectsAction((IShellProvider)site);
        this.closeUnrelatedAction.setActionDefinitionId("org.eclipse.ui.project.closeUnrelatedProjects");
        this.openAction = new OpenProjectAction(site);
        this.openAction.setActionDefinitionId("org.eclipse.ui.project.openProject");
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)selection;
            this.openAction.selectionChanged(s);
            this.closeAction.selectionChanged(s);
            this.closeUnrelatedAction.selectionChanged(s);
        }
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    N4JSProjectActionGroup.this.performSelectionChanged((IStructuredSelection)s);
                }
            }
        };
        selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.openAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.closeAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.closeUnrelatedAction);
    }

    private void performSelectionChanged(IStructuredSelection structuredSelection) {
        Object[] array = structuredSelection.toArray();
        ArrayList<IProject> openProjects = new ArrayList<IProject>();
        int selectionStatus = this.evaluateSelection(array, openProjects);
        StructuredSelection sel = new StructuredSelection(openProjects);
        this.enableContribution = (selectionStatus & 2) != 0;
        this.openAction.setEnabled(this.hasClosedProjectsInWorkspace());
        this.enableOpenInContextMenu = (selectionStatus & 1) != 0 || selectionStatus == 0 && array.length == 0 && this.hasClosedProjectsInWorkspace();
        this.closeAction.selectionChanged((IStructuredSelection)sel);
        this.closeUnrelatedAction.selectionChanged((IStructuredSelection)sel);
    }

    private int evaluateSelection(Object[] array, List<IProject> allOpenProjects) {
        int status = 0;
        int i = 0;
        while (i < array.length) {
            Object curr = array[i];
            if (curr instanceof IProject) {
                IProject project = (IProject)curr;
                if (project.isOpen()) {
                    allOpenProjects.add(project);
                } else {
                    status |= 1;
                }
            } else {
                status |= 2;
                if (curr instanceof WorkingSet) {
                    int res = this.evaluateSelection(((WorkingSet)curr).getElements(), allOpenProjects);
                    status |= res;
                }
            }
            ++i;
        }
        return status;
    }

    private boolean hasClosedProjectsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].isOpen()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), (IAction)this.closeUnrelatedAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.enableContribution) {
            return;
        }
        if (this.openAction.isEnabled() && this.enableOpenInContextMenu) {
            menu.appendToGroup("group.build", (IAction)this.openAction);
        }
        if (this.closeAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.closeAction);
        }
        if (this.closeUnrelatedAction.isEnabled() && this.areOnlyProjectsSelected(this.closeUnrelatedAction.getStructuredSelection())) {
            menu.appendToGroup("group.build", (IAction)this.closeUnrelatedAction);
        }
    }

    public OpenProjectAction getOpenProjectAction() {
        return this.openAction;
    }

    private boolean areOnlyProjectsSelected(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object obj : selection) {
            if (!(obj instanceof IAdaptable) || ((IAdaptable)obj).getAdapter(IProject.class) != null) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
        this.selectionProvider = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.openAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.closeAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.closeUnrelatedAction);
        super.dispose();
    }
}

