/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.ProblemLog;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.VersionExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeComponentTypeRef {
    private static final String ATTR_ID = "id";
    private static final String ATTR_VERSION = "version";
    private final IRuntimeComponentType rct;
    private final VersionExpr<IRuntimeComponentVersion> vexpr;

    public RuntimeComponentTypeRef(IRuntimeComponentType rct, IVersionExpr vexpr) {
        this(rct, (VersionExpr)vexpr);
    }

    public RuntimeComponentTypeRef(IRuntimeComponentType rct, VersionExpr<IRuntimeComponentVersion> vexpr) {
        this.rct = rct;
        this.vexpr = vexpr;
    }

    public boolean check(Set<IRuntimeComponentVersion> rcvs) {
        for (IRuntimeComponentVersion rcv : rcvs) {
            if (this.rct != rcv.getRuntimeComponentType()) continue;
            if (this.vexpr != null) {
                return this.vexpr.check(rcv);
            }
            return true;
        }
        return false;
    }

    public static RuntimeComponentTypeRef read(IConfigurationElement config) {
        return RuntimeComponentTypeRef.read(config, ProblemLog.DEFAULT_POLICY);
    }

    public static RuntimeComponentTypeRef read(IConfigurationElement config, ProblemLog.Policy problemLoggingPolicy) {
        String pluginId = config.getContributor().getName();
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_ID);
            return null;
        }
        if (!RuntimeManager.isRuntimeComponentTypeDefined(id)) {
            ProblemLog.reportMissingRuntimeComponentType(id, pluginId, problemLoggingPolicy);
            return null;
        }
        IRuntimeComponentType rct = RuntimeManager.getRuntimeComponentType(id);
        String v = config.getAttribute(ATTR_VERSION);
        VersionExpr vexpr = null;
        if (v != null) {
            try {
                vexpr = new VersionExpr(rct, v, pluginId);
            }
            catch (CoreException e) {
                FacetCorePlugin.log(e.getStatus());
                return null;
            }
        }
        return new RuntimeComponentTypeRef(rct, (IVersionExpr)vexpr);
    }
}

