/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.search;

import java.util.regex.Pattern;
import org.eclipse.rse.services.clientserver.search.ISystemSearchMatcher;
import org.eclipse.rse.services.clientserver.search.SystemNonRegexMatcher;

public class SystemSearchStringMatcher
implements ISystemSearchMatcher {
    private String searchString;
    private boolean isRegex;
    private Pattern regexPattern;
    private SystemNonRegexMatcher nonRegexMatcher;

    public SystemSearchStringMatcher(String searchString, boolean isCaseSensitive, boolean isRegex) {
        block6: {
            if (searchString == null) {
                throw new NullPointerException();
            }
            this.searchString = searchString;
            this.isRegex = isRegex;
            if (isRegex) {
                try {
                    if (isCaseSensitive) {
                        this.regexPattern = Pattern.compile(searchString);
                        break block6;
                    }
                    this.regexPattern = Pattern.compile(searchString, 2);
                }
                catch (Exception exception) {}
            } else {
                this.nonRegexMatcher = new SystemNonRegexMatcher(searchString, !isCaseSensitive, false);
            }
        }
    }

    public boolean isSearchStringEmpty() {
        return this.searchString.length() == 0;
    }

    public boolean isSearchStringAsterisk() {
        return this.searchString.equals("*");
    }

    public boolean matches(String input) {
        if (this.isSearchStringEmpty()) {
            return true;
        }
        if (this.isRegex) {
            return this.regexPattern.matcher(input).find();
        }
        return this.nonRegexMatcher.find(input, 0, input.length()) != null;
    }
}

