/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.GraphUtils;
import org.eclipse.n4js.smith.ui.graph.Point;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class Node {
    private static final float BORDER = 4.0f;
    private static final float DEFAULT_WIDTH = 200.0f;
    private static final float DEFAULT_HEIGHT = 30.0f;
    private static final float SIZE_CROSS_LINKS_MARKER = 6.0f;
    protected Object element;
    protected String title;
    protected String description;
    protected Color color;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected boolean hasOutgoingCrossLinksInternal = false;
    protected boolean hasOutgoingCrossLinksExternal = false;
    protected boolean hasIncomingCrossLinksInternal = false;
    protected Node parent;
    protected final List<Node> children = new ArrayList<Node>();

    public Node(Object element, String title, String description) {
        this(element, title, description, 10.0f, 10.0f, 200.0f, 30.0f);
    }

    public Node(Object element, String title, String description, Color color) {
        this(element, title, description, color, 10.0f, 10.0f, 200.0f, 30.0f);
    }

    public Node(Object element, String title, String description, float x, float y, float width, float height) {
        this(element, title, description, GraphUtils.getColor(200, 200, 255), x, y, width, height);
    }

    public Node(Object element, String title, String description, Color color, float x, float y, float width, float height) {
        this.element = element;
        this.title = title;
        this.description = description;
        this.color = color;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Object getElement() {
        return this.element;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public Color getBackgroundColor() {
        return this.color;
    }

    public boolean contains(float x, float y) {
        return this.getBounds().contains(x, y);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2.0f, this.y + this.height / 2.0f);
    }

    public Point getAnchor(Edge edge, Point referencePoint) {
        return this.getBounds().getIntersectionLocation(referencePoint);
    }

    public void move(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void trim(GC gc) {
        if (this.title != null) {
            org.eclipse.swt.graphics.Point size = gc.stringExtent(this.title);
            this.width = (float)size.x + 8.0f;
            this.height = (float)size.y + 8.0f;
        } else {
            this.width = 200.0f;
            this.height = 30.0f;
        }
    }

    public void paint(GC gc) {
        gc.setBackground(this.getBackgroundColor());
        gc.setForeground(gc.getDevice().getSystemColor(2));
        gc.fillRoundRectangle(Math.round(this.x), Math.round(this.y), Math.round(this.width), Math.round(this.height), 5, 5);
        GraphUtils.drawString(gc, this.title, this.x, this.y, this.width, this.height, 0);
        if (this.hasOutgoingCrossLinksInternal || this.hasOutgoingCrossLinksExternal) {
            Color colorRed = gc.getDevice().getSystemColor(3);
            gc.setBackground(colorRed);
            gc.setForeground(colorRed);
            int ovalX = Math.round(this.x + this.width - 6.0f - 2.0f);
            int ovalY = Math.round(this.y + 2.0f);
            int ovalSize = Math.round(6.0f);
            if (this.hasOutgoingCrossLinksInternal) {
                gc.fillOval(ovalX, ovalY, ovalSize, ovalSize);
            } else {
                gc.drawOval(ovalX, ovalY, ovalSize, ovalSize);
            }
        }
        gc.setBackground(Display.getDefault().getSystemColor(1));
    }

    public String toString() {
        String toString = this.title != null ? this.title : super.toString();
        return toString;
    }
}

