/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.console;

import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;
import org.eclipse.n4js.transpiler.sourcemap.SourceMap;
import org.eclipse.n4js.transpiler.sourcemap.SourceMapFileLocator;
import org.eclipse.n4js.ui.console.ConsoleMessages;
import org.eclipse.n4js.ui.console.JSStackTraceLocationText;
import org.eclipse.n4js.ui.internal.N4JSGracefulActivator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class N4JSStackTraceHyperlink
implements IHyperlink {
    @Inject
    private SourceMapFileLocator sourceMapFileLocator;
    private TextConsole console;

    public void setTextConsole(TextConsole console) {
        this.console = console;
    }

    protected TextConsole getConsole() {
        return this.console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        JSStackTraceLocationText locationText;
        try {
            String linkText = this.getLinkText();
            locationText = new JSStackTraceLocationText(linkText);
        }
        catch (CoreException e1) {
            ErrorDialog.openError((Shell)N4JSGracefulActivator.getActiveWorkbenchShell(), (String)ConsoleMessages.msgHyperlinkError(), (String)ConsoleMessages.msgHyperlinkError(), (IStatus)e1.getStatus());
            return;
        }
        this.startSourceSearch(locationText);
    }

    protected void startSourceSearch(final JSStackTraceLocationText jsLink) {
        Job search = new Job(ConsoleMessages.msgHyperlinkSearching()){

            protected IStatus run(IProgressMonitor monitor) {
                File file = new File(jsLink.fileName);
                if (file.exists() && file.isFile()) {
                    try {
                        Path path = file.toPath();
                        File sourceMapFile = N4JSStackTraceHyperlink.this.sourceMapFileLocator.resolveSourceMapFromGen(path);
                        SourceMap sourceMap = SourceMap.loadAndResolve((Path)sourceMapFile.toPath());
                        MappingEntry mappingEntry = sourceMap.findMappingForGenPosition(jsLink.line - 1, jsLink.column - 1);
                        Path sourcePath = (Path)sourceMap.getResolvedSources().get(mappingEntry.srcIndex);
                        N4JSStackTraceHyperlink.this.searchCompleted(sourcePath.toFile().getAbsolutePath(), mappingEntry.srcLine, mappingEntry.srcColumn);
                    }
                    catch (Exception ex) {
                        N4JSStackTraceHyperlink.this.searchCompleted(jsLink.fileName, jsLink.line - 1, jsLink.column - 1);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        search.schedule();
    }

    protected void searchCompleted(final String fileName, final int line, final int column) {
        UIJob job = new UIJob("link search complete"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                File file = new File(fileName);
                if (!file.exists()) {
                    MessageDialog.openInformation((Shell)N4JSGracefulActivator.getActiveWorkbenchShell(), (String)ConsoleMessages.msgSourceNotFoundTitle(), (String)ConsoleMessages.msgSourceNotFoundFor(fileName));
                } else {
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        N4JSStackTraceHyperlink.this.revealLocationInFile(fileName, line, column, editorPart);
                    }
                    catch (PartInitException editorPart) {
                    }
                    catch (CoreException e) {
                        N4JSGracefulActivator.statusDialog(e.getStatus());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void revealLocationInFile(String typeName, int line, int column, IEditorPart editorPart) throws CoreException {
        if (editorPart instanceof ITextEditor && line >= 0) {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IEditorInput editorInput = editorPart.getEditorInput();
            provider.connect((Object)editorInput);
            IDocument document = provider.getDocument((Object)editorInput);
            try {
                IRegion regionOfLine = document.getLineInformation(line);
                textEditor.selectAndReveal(regionOfLine.getOffset(), regionOfLine.getLength());
                int startOffset = regionOfLine.getOffset() + column;
                int length = regionOfLine.getLength() - column;
                if (startOffset >= document.getLength()) {
                    startOffset = document.getLength() - 1;
                }
                if (length + startOffset >= document.getLength()) {
                    length = document.getLength() - startOffset - 1;
                }
                textEditor.setHighlightRange(startOffset, length, true);
            }
            catch (BadLocationException e) {
                MessageDialog.openInformation((Shell)N4JSGracefulActivator.getActiveWorkbenchShell(), (String)ConsoleMessages.msgInvalidLineNumberTitle(), (String)ConsoleMessages.msgInvalidLineNumberIn(String.valueOf(line + 1), typeName));
            }
            provider.disconnect((Object)editorInput);
        }
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            int regionOffsetInLine = regionOffset - lineOffset;
            int linkEnd = line.indexOf(41, regionOffsetInLine);
            int linkStart = line.lastIndexOf(32, regionOffsetInLine);
            return line.substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, "org.eclipse.n4js.ui", 0, ConsoleMessages.msgUnableToParseLinkText(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

