/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.handler;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.fileextensions.FileExtensionType;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.handler.FileExtensionBasedPropertTester;
import org.eclipse.n4js.utils.ResourceNameComputer;

public class GeneratedJsFileLocator {
    @Inject
    private IN4JSCore core;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private FileExtensionBasedPropertTester tester;
    @Inject
    private FileExtensionsRegistry fileExtensionRegistry;

    public Optional<IFile> tryGetGeneratedSourceForN4jsFile(IFile file) {
        IFile generatedFile;
        if (file == null || !file.exists()) {
            return Optional.absent();
        }
        if (this.tester.test(file, null, null, this.fileExtensionRegistry.getFileExtensions(FileExtensionType.TRANSPILABLE_FILE_EXTENSION)) && (generatedFile = this.tryLocateGeneratedFile(file)) != null && generatedFile.exists()) {
            return Optional.fromNullable((Object)generatedFile);
        }
        return Optional.absent();
    }

    private IFile tryLocateGeneratedFile(IFile file) {
        Optional project;
        URI fileUri = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
        if (fileUri.isPlatform() && (project = this.core.findProject(fileUri)).isPresent()) {
            try {
                String targetFileName = this.resourceNameComputer.generateFileDescriptor(fileUri, "js");
                String targetFileRelativeLocation = String.valueOf(((IN4JSProject)project.get()).getOutputPath()) + "/" + targetFileName;
                IFile targetFile = file.getProject().getFile(targetFileRelativeLocation);
                if (targetFile.exists()) {
                    return targetFile;
                }
                IFile targetFile2 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(targetFileRelativeLocation));
                if (targetFile2.exists()) {
                    return targetFile2;
                }
                String projectNameSegment = String.valueOf(file.getProject().getName()) + "/";
                if (targetFileRelativeLocation.startsWith(projectNameSegment)) {
                    String targetFileRelativeLocation3 = targetFileRelativeLocation.substring(projectNameSegment.length() - 1);
                    IFile targetFile3 = file.getProject().getFile(targetFileRelativeLocation3);
                    if (targetFile3.exists()) {
                        return targetFile3;
                    }
                }
            }
            catch (RuntimeException re) {
                return null;
            }
        }
        return null;
    }
}

