/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.event.EventHandlerWrapper;
import org.eclipse.equinox.internal.event.LogTracker;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class EventHandlerTracker
extends ServiceTracker<EventHandler, EventHandlerWrapper>
implements EventDispatcher<EventHandlerWrapper, Permission, Event> {
    private final LogTracker log;
    private final List<EventHandlerWrapper> globalWildcard;
    private final Map<String, List<EventHandlerWrapper>> partialWildcard;
    private final Map<String, List<EventHandlerWrapper>> topicName;

    public EventHandlerTracker(BundleContext context, LogTracker log) {
        super(context, EventHandler.class.getName(), null);
        this.log = log;
        this.globalWildcard = new ArrayList<EventHandlerWrapper>();
        this.partialWildcard = new HashMap<String, List<EventHandlerWrapper>>();
        this.topicName = new HashMap<String, List<EventHandlerWrapper>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventHandlerWrapper addingService(ServiceReference<EventHandler> reference) {
        EventHandlerWrapper wrapper = new EventHandlerWrapper(reference, this.context, this.log);
        EventHandlerTracker eventHandlerTracker = this;
        synchronized (eventHandlerTracker) {
            if (wrapper.init()) {
                this.bucket(wrapper);
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<EventHandler> reference, EventHandlerWrapper service) {
        EventHandlerTracker eventHandlerTracker = this;
        synchronized (eventHandlerTracker) {
            this.unbucket(service);
            if (service.init()) {
                this.bucket(service);
                return;
            }
        }
        service.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<EventHandler> reference, EventHandlerWrapper service) {
        EventHandlerTracker eventHandlerTracker = this;
        synchronized (eventHandlerTracker) {
            this.unbucket(service);
        }
        service.flush();
    }

    private void bucket(EventHandlerWrapper wrapper) {
        String[] topics = wrapper.getTopics();
        int length = topics == null ? 0 : topics.length;
        int i = 0;
        while (i < length) {
            String topic = topics[i];
            if (topic.equals("*")) {
                this.globalWildcard.add(wrapper);
            } else if (topic.endsWith("/*")) {
                String key = topic.substring(0, topic.length() - 2);
                List<EventHandlerWrapper> wrappers = this.partialWildcard.get(key);
                if (wrappers == null) {
                    wrappers = new ArrayList<EventHandlerWrapper>();
                    this.partialWildcard.put(key, wrappers);
                }
                wrappers.add(wrapper);
            } else {
                List<EventHandlerWrapper> wrappers = this.topicName.get(topic);
                if (wrappers == null) {
                    wrappers = new ArrayList<EventHandlerWrapper>();
                    this.topicName.put(topic, wrappers);
                }
                wrappers.add(wrapper);
            }
            ++i;
        }
    }

    private void unbucket(EventHandlerWrapper wrapper) {
        String[] topics = wrapper.getTopics();
        int length = topics == null ? 0 : topics.length;
        int i = 0;
        while (i < length) {
            String topic = topics[i];
            if (topic.equals("*")) {
                this.globalWildcard.remove(wrapper);
            } else if (topic.endsWith("/*")) {
                String key = topic.substring(0, topic.length() - 2);
                List<EventHandlerWrapper> wrappers = this.partialWildcard.get(key);
                if (wrappers != null) {
                    wrappers.remove(wrapper);
                    if (wrappers.isEmpty()) {
                        this.partialWildcard.remove(key);
                    }
                }
            } else {
                List<EventHandlerWrapper> wrappers = this.topicName.get(topic);
                if (wrappers != null) {
                    wrappers.remove(wrapper);
                    if (wrappers.isEmpty()) {
                        this.topicName.remove(topic);
                    }
                }
            }
            ++i;
        }
    }

    public synchronized Set<EventHandlerWrapper> getHandlers(String topic) {
        List<EventHandlerWrapper> wrappers;
        HashSet<EventHandlerWrapper> handlers = new HashSet<EventHandlerWrapper>();
        handlers.addAll(this.globalWildcard);
        if (this.partialWildcard.size() > 0) {
            int index = topic.lastIndexOf(47);
            while (index >= 0) {
                String subTopic = topic.substring(0, index);
                List<EventHandlerWrapper> wrappers2 = this.partialWildcard.get(subTopic);
                if (wrappers2 != null) {
                    handlers.addAll(wrappers2);
                }
                index = subTopic.lastIndexOf(47);
            }
        }
        if ((wrappers = this.topicName.get(topic)) != null) {
            handlers.addAll(wrappers);
        }
        return handlers;
    }

    public void dispatchEvent(EventHandlerWrapper eventListener, Permission listenerObject, int eventAction, Event eventObject) {
        eventListener.handleEvent(eventObject, listenerObject);
    }
}

