/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.n4js.smith.DataPoint;

public class DataSeries {
    public final String name;
    public final Long sum;
    private final List<DataPoint> data = new LinkedList<DataPoint>();
    private final List<DataSeries> children = new LinkedList<DataSeries>();

    public DataSeries(String name, List<DataPoint> data) {
        this.name = name;
        this.data.addAll(data);
        this.sum = this.data.stream().map(d -> d.nanos).reduce(0L, Long::sum);
    }

    public void addChild(DataSeries child) {
        this.children.add(child);
    }

    public boolean hasNoChildren() {
        return this.children.isEmpty();
    }

    public boolean hasNoData() {
        return this.data.isEmpty();
    }

    public Stream<DataSeries> getChildren() {
        return this.children.stream();
    }

    public List<DataPoint> getData() {
        return new LinkedList<DataPoint>(this.data);
    }
}

