/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc;

import java.util.HashSet;
import java.util.Set;

public class ThreadsUtil {
    private static String NL = String.format("%n", new Object[0]);

    public static int getIdentifiedThredsCount(String descriptionToken) {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        int threadCount = 0;
        for (Thread next : threadSet) {
            String threadDesc = next.toString();
            if (!ThreadsUtil.containsToken(threadDesc, descriptionToken)) continue;
            ++threadCount;
        }
        return threadCount;
    }

    public static String getThreadsInfo(String descriptionToken) {
        StringBuilder info = new StringBuilder();
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        HashSet<Thread> equinoxThreads = new HashSet<Thread>();
        info.append("threads").append(NL);
        for (Thread next : threadSet) {
            String threadDesc = next.toString();
            if (ThreadsUtil.containsToken(threadDesc, descriptionToken)) {
                equinoxThreads.add(next);
                continue;
            }
            info.append(" thread :: " + next.getId() + " : " + next.toString()).append(NL);
        }
        info.append("threads described by " + descriptionToken).append(NL);
        for (Thread next : equinoxThreads) {
            info.append(" thread :: " + next.getId() + " : " + next.toString()).append(NL);
        }
        info.append(NL);
        return info.toString();
    }

    private static boolean containsToken(String message, String token) {
        return message.toLowerCase().contains(token);
    }
}

