/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.viewer;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.ui.views.features.support.FeatureInput;

public abstract class AbstractFeatureTreeContentProvider
implements ITreeContentProvider,
IFeatureModelListener {
    protected final FeatureModelManager fFeatureModelManager;
    protected FeatureInput fInput;
    private Viewer fViewer;

    public AbstractFeatureTreeContentProvider(FeatureModelManager featureModelManager) {
        this.fFeatureModelManager = featureModelManager;
        this.fFeatureModelManager.addFeatureModelListener((IFeatureModelListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
        if (newInput instanceof FeatureInput) {
            this.fInput = (FeatureInput)newInput;
        }
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
        this.fFeatureModelManager.removeFeatureModelListener((IFeatureModelListener)this);
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.refreshViewer();
    }

    private void refreshViewer() {
        if (this.fViewer.getControl().isDisposed()) {
            return;
        }
        this.fViewer.getControl().getDisplay().asyncExec(() -> {
            if (!this.fViewer.getControl().isDisposed()) {
                this.fViewer.refresh();
            }
        });
    }
}

