/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDDirectivesManager {
    protected static final String XMLNS = "xmlns";
    protected List unusedDirectives = new ArrayList();
    protected List usedIncludeSchemas = new ArrayList();
    protected List usedIndirectIncludes = new ArrayList();
    protected List usedDirectIncludes = new ArrayList();
    protected List analyzedIncludeSchemas = new ArrayList();
    protected List usedSchemas = new ArrayList();
    protected Map usedIndirectIncludesMap = new HashMap();
    protected Set unusedPrefixes;
    protected Set usedPrefixes;
    protected Map schemaToPrefixMap;

    public static void removeUnusedXSDImports(XSDSchema schema) {
        if (XSDEditorPlugin.getDefault().getRemoveImportSetting()) {
            XSDDirectivesManager mgr = new XSDDirectivesManager();
            mgr.performRemoval(schema);
            mgr.cleanup();
        }
    }

    public void performRemoval(XSDSchema schema) {
        this.computeUnusedImports(schema);
        this.removeUnusedImports();
        this.removeUnusedPrefixes();
    }

    public void cleanup() {
        this.clearMaps();
    }

    public List getUnusedXSDDirectives() {
        return this.unusedDirectives;
    }

    public Map getSchemaToPrefixMap() {
        return this.schemaToPrefixMap;
    }

    public Set getUnusedPrefixes() {
        return this.unusedPrefixes;
    }

    public Set getUsedPrefixes() {
        return this.usedPrefixes;
    }

    protected void clearMaps() {
        if (this.schemaToPrefixMap != null) {
            this.schemaToPrefixMap.clear();
        }
    }

    protected void removeUnusedImports() {
        Iterator iter = this.unusedDirectives.iterator();
        while (iter.hasNext()) {
            XSDSchemaDirective xsdDirective = (XSDSchemaDirective)iter.next();
            this.removeXSDDirective(xsdDirective);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeXSDDirective(XSDSchemaDirective xsdImport) {
        XSDSchema schema = xsdImport.getSchema();
        Element element = xsdImport.getElement();
        Document doc = element.getOwnerDocument();
        if (doc instanceof IDOMNode) {
            ((IDOMNode)doc).getModel().aboutToChangeModel();
        }
        try {
            if (!this.removeTextNodesBetweenNextElement(element)) {
                this.removeTextNodeBetweenPreviousElement(element);
            }
            element.getParentNode().removeChild(element);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (doc instanceof IDOMNode) {
                ((IDOMNode)doc).getModel().changedModel();
            }
            schema.update(true);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        if (doc instanceof IDOMNode) {
            ((IDOMNode)doc).getModel().changedModel();
        }
        schema.update(true);
    }

    protected void computeUnusedImports(XSDSchema schema) {
        this.unusedDirectives = new ArrayList();
        this.usedSchemas = new ArrayList();
        this.usedPrefixes = new HashSet();
        this.schemaToPrefixMap = new HashMap();
        try {
            Map xsdNamedComponentUsage = TopLevelComponentCrossReferencer.find((EObject)schema);
            this.doCrossReferencer(schema, this.usedSchemas, xsdNamedComponentUsage);
            this.addToUnusedImports(schema, this.usedSchemas);
            this.computeUnusedPrefixes(schema);
        }
        catch (Exception exception) {
            this.unusedDirectives.clear();
            this.schemaToPrefixMap.clear();
        }
    }

    protected void computeUnusedPrefixes(XSDSchema schema) {
        Map prefixMap = schema.getQNamePrefixToNamespaceMap();
        Set definedPrefixes = prefixMap.keySet();
        HashSet<String> actualSet = new HashSet<String>();
        NamedNodeMap attributes = schema.getElement().getAttributes();
        Iterator iter = definedPrefixes.iterator();
        while (iter.hasNext()) {
            String pref = (String)iter.next();
            if (pref == null) {
                if (attributes.getNamedItem(XMLNS) == null) continue;
                actualSet.add(null);
                continue;
            }
            if (attributes.getNamedItem("xmlns:" + pref) == null) continue;
            actualSet.add(pref);
        }
        this.unusedPrefixes = new HashSet(actualSet);
        this.usedPrefixes.add(schema.getSchemaForSchemaQNamePrefix());
        Element element = schema.getElement();
        NodeList childElements = element.getChildNodes();
        int length = childElements.getLength();
        int i = 0;
        while (i < length) {
            Node node = childElements.item(i);
            if (node instanceof Element) {
                this.traverseDOMElement((Element)node, schema);
            }
            ++i;
        }
        this.computeUsedXSDPrefixes(schema);
        this.unusedPrefixes.removeAll(this.usedPrefixes);
        this.doAdditionalProcessing(schema);
        this.schemaToPrefixMap.put(schema, this.unusedPrefixes);
    }

    protected void removeUnusedPrefixes() {
        Set schemaSet = this.schemaToPrefixMap.keySet();
        Iterator iter = schemaSet.iterator();
        while (iter.hasNext()) {
            XSDSchema schema = (XSDSchema)iter.next();
            Map prefixMap = schema.getQNamePrefixToNamespaceMap();
            Set prefixesToRemove = (Set)this.schemaToPrefixMap.get(schema);
            Iterator iter2 = prefixesToRemove.iterator();
            while (iter2.hasNext()) {
                String string = (String)iter2.next();
                if (!prefixMap.containsKey(string)) continue;
                prefixMap.remove(string);
            }
        }
    }

    protected void doAdditionalProcessing(XSDSchema schema) {
    }

    private void computeUsedXSDPrefixes(XSDSchema schema) {
        String value;
        String key;
        Map prefixMap = schema.getQNamePrefixToNamespaceMap();
        Set definedPrefixes = prefixMap.keySet();
        boolean foundEntryForTargetNamespace = false;
        String targetNamespace = schema.getTargetNamespace();
        Iterator<Object> iter = this.usedPrefixes.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            value = (String)prefixMap.get(key);
            if (targetNamespace == null && value == null) {
                foundEntryForTargetNamespace = true;
                break;
            }
            if (targetNamespace == null || value == null || !targetNamespace.equals(value)) continue;
            foundEntryForTargetNamespace = true;
            break;
        }
        if (!foundEntryForTargetNamespace) {
            iter = definedPrefixes.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = (String)prefixMap.get(key);
                if (targetNamespace == null && value == null) {
                    this.usedPrefixes.add(null);
                    break;
                }
                if (targetNamespace == null || value == null || !targetNamespace.equals(value)) continue;
                this.usedPrefixes.add(key);
                break;
            }
        }
    }

    private void traverseDOMElement(Element element, XSDSchema schema) {
        String prefix = element.getPrefix();
        this.usedPrefixes.add(prefix);
        NamedNodeMap attrs = element.getAttributes();
        int numOfAttrs = attrs.getLength();
        int i = 0;
        while (i < numOfAttrs) {
            String value;
            String attr;
            Node node = attrs.item(i);
            String attrPrefix = node.getPrefix();
            if (attrPrefix != null) {
                this.usedPrefixes.add(attrPrefix);
            }
            if ((attr = node.getLocalName()) != null && (value = node.getNodeValue()) != null) {
                if (attr.equals("ref") || attr.equals("refer") || attr.equals("type") || attr.equals("base") || attr.equals("substitutionGroup") || attr.equals("itemType")) {
                    try {
                        this.usedPrefixes.add(this.extractPrefix(value));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                } else if (attr.equals("memberTypes")) {
                    StringTokenizer tokenizer = new StringTokenizer(value);
                    while (tokenizer.hasMoreTokens()) {
                        try {
                            String token = tokenizer.nextToken();
                            this.usedPrefixes.add(this.extractPrefix(token));
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    }
                }
            }
            ++i;
        }
        NodeList childElements = element.getChildNodes();
        int length = childElements.getLength();
        int i2 = 0;
        while (i2 < length) {
            Node node = childElements.item(i2);
            if (node instanceof Element) {
                this.traverseDOMElement((Element)node, schema);
            }
            ++i2;
        }
    }

    protected String extractPrefix(String value) {
        int index = value.indexOf(58);
        if (index < 0) {
            return null;
        }
        return value.substring(0, index);
    }

    protected void doCrossReferencer(XSDSchema schema, List usedSchemas, Map xsdNamedComponentUsage) {
        Iterator iterator = xsdNamedComponentUsage.keySet().iterator();
        while (iterator.hasNext()) {
            XSDNamedComponent namedComponent = (XSDNamedComponent)iterator.next();
            XSDSchema namedComponentSchema = namedComponent.getSchema();
            if (namedComponentSchema == schema) continue;
            Collection collection = (Collection)xsdNamedComponentUsage.get(namedComponent);
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iterator2.next();
                EObject obj = setting.getEObject();
                if (!this.isComponentUsed(obj, schema, namedComponentSchema) || usedSchemas.contains(namedComponentSchema)) continue;
                usedSchemas.add(namedComponentSchema);
            }
        }
    }

    protected boolean isComponentUsed(Object obj, XSDSchema schema, XSDSchema targetSchema) {
        if (obj instanceof XSDConcreteComponent) {
            XSDConcreteComponent component = (XSDConcreteComponent)obj;
            if (component == schema || component instanceof XSDSchema) {
                return false;
            }
            if (!this.usedIncludeSchemas.contains(targetSchema)) {
                this.usedIncludeSchemas.add(targetSchema);
            }
            return true;
        }
        return false;
    }

    protected void addToUnusedImports(XSDSchema schema, List usedSchemas) {
        Iterator iter = schema.getContents().iterator();
        while (iter.hasNext()) {
            XSDInclude inc;
            XSDSchema incSchema;
            Object o = iter.next();
            if (!(o instanceof XSDSchemaDirective)) continue;
            XSDSchemaDirective directive = (XSDSchemaDirective)o;
            boolean isUsed = false;
            Iterator iter2 = usedSchemas.iterator();
            while (iter2.hasNext()) {
                XSDSchema usedSchema = (XSDSchema)iter2.next();
                if (directive instanceof XSDImport && directive.getResolvedSchema() == usedSchema) {
                    isUsed = true;
                    break;
                }
                if (directive instanceof XSDInclude && ((XSDInclude)directive).getIncorporatedSchema() == usedSchema) {
                    isUsed = true;
                    this.usedDirectIncludes.add(usedSchema);
                    break;
                }
                if (!(directive instanceof XSDRedefine)) continue;
                isUsed = true;
                break;
            }
            if (directive instanceof XSDInclude && !isUsed && (incSchema = (inc = (XSDInclude)directive).getIncorporatedSchema()) != null) {
                XSDSchema usedSchema = this.getUsedIncludeSchema(incSchema, inc);
                if (usedSchema != null) {
                    this.usedIndirectIncludes.add(directive);
                    this.usedIndirectIncludesMap.put(directive, usedSchema);
                    isUsed = true;
                } else {
                    isUsed = false;
                }
            }
            if (isUsed || this.unusedDirectives.contains(directive) || directive instanceof XSDRedefine) continue;
            this.unusedDirectives.add(directive);
        }
        Iterator iter3 = this.usedIndirectIncludes.iterator();
        while (iter3.hasNext()) {
            Object o = iter3.next();
            if (!(o instanceof XSDInclude)) continue;
            XSDInclude inc = (XSDInclude)o;
            XSDSchema targetSchema = (XSDSchema)this.usedIndirectIncludesMap.get(inc);
            if (this.usedIncludeSchemas.contains(targetSchema) && this.usedDirectIncludes.contains(targetSchema)) {
                this.unusedDirectives.add(inc);
                continue;
            }
            this.usedDirectIncludes.add(targetSchema);
        }
    }

    private XSDSchema getUsedIncludeSchema(XSDSchema schema, XSDInclude xsdInclude) {
        XSDSchema refSchema = null;
        boolean isUsed = false;
        Iterator iter = schema.getContents().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XSDInclude)) break;
            XSDInclude inc = (XSDInclude)o;
            XSDSchema incSchema = inc.getIncorporatedSchema();
            if (incSchema == null) continue;
            Iterator iter2 = this.usedIncludeSchemas.iterator();
            while (iter2.hasNext()) {
                XSDSchema xsdSch = (XSDSchema)iter2.next();
                if (incSchema != xsdSch) continue;
                isUsed = true;
                refSchema = incSchema;
                break;
            }
            if (!isUsed && !this.analyzedIncludeSchemas.contains(incSchema)) {
                this.analyzedIncludeSchemas.add(incSchema);
                refSchema = this.getUsedIncludeSchema(incSchema, inc);
            }
            if (!isUsed && refSchema == null) continue;
            return refSchema;
        }
        return refSchema;
    }

    protected boolean removeTextNodesBetweenNextElement(Element element) {
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        Node node = element.getNextSibling();
        while (node != null) {
            if (node.getNodeType() == 3) {
                nodesToRemove.add(node);
            } else if (node.getNodeType() == 1) {
                Iterator j = nodesToRemove.iterator();
                while (j.hasNext()) {
                    Node nodeToRemove = (Node)j.next();
                    nodeToRemove.getParentNode().removeChild(nodeToRemove);
                }
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    protected boolean removeTextNodeBetweenPreviousElement(Element element) {
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        Node node = element.getPreviousSibling();
        while (node != null) {
            if (node.getNodeType() == 3) {
                nodesToRemove.add(node);
            } else if (node.getNodeType() == 1) {
                Iterator j = nodesToRemove.iterator();
                while (j.hasNext()) {
                    Node nodeToRemove = (Node)j.next();
                    nodeToRemove.getParentNode().removeChild(nodeToRemove);
                }
                return true;
            }
            node = node.getPreviousSibling();
        }
        return false;
    }

    public static void removeUnusedXSDImports(IFile iFile, boolean checkPreference) throws CoreException, IOException {
        IDOMDocument document;
        IDOMModel model;
        if ((!checkPreference || XSDEditorPlugin.getDefault().getRemoveImportSetting()) && (model = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(iFile)) != null && (document = model.getDocument()) != null) {
            XSDSchema schema = XSDModelAdapter.lookupOrCreateSchema((Document)document);
            XSDDirectivesManager mgr = new XSDDirectivesManager();
            mgr.performRemoval(schema);
            mgr.cleanup();
            model.save();
        }
    }

    protected static class TopLevelComponentCrossReferencer
    extends XSDUtil.XSDNamedComponentCrossReferencer {
        private static final long serialVersionUID = 1L;
        XSDSchema schemaForSchema = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        XSDSchema schemaForXSI = XSDSchemaImpl.getSchemaInstance((String)"http://www.w3.org/2001/XMLSchema-instance");

        protected TopLevelComponentCrossReferencer(EObject arg0) {
            super(arg0);
        }

        public static Map find(EObject eObject) {
            TopLevelComponentCrossReferencer result = new TopLevelComponentCrossReferencer(eObject);
            result.crossReference();
            result.done();
            return result;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            if (crossReferencedEObject instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)crossReferencedEObject;
                if (namedComponent.getContainer() == this.schemaForSchema || namedComponent.getContainer() == this.schemaForXSI || crossReferencedEObject.eContainer() == eObject || namedComponent.getName() == null) {
                    return false;
                }
                if (namedComponent instanceof XSDTypeDefinition) {
                    XSDTypeDefinition typeDefinition = (XSDTypeDefinition)namedComponent;
                    if (!(typeDefinition.getContainer() instanceof XSDSchema)) {
                        return false;
                    }
                    if (typeDefinition.getName() == null) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

