/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.scoping.builtin.GlobalObjectScope;
import org.eclipse.n4js.scoping.builtin.VirtualBaseTypeScope;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.types.AnyType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.NullType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.UndefinedType;
import org.eclipse.n4js.ts.types.VirtualBaseType;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.ITypeReplacementProvider;
import org.eclipse.n4js.typesystem.utils.PredefinedTypes;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class RuleEnvironmentExtensions {
    private static final String KEY__CANCEL_INDICATOR = "cancelIndicator";
    private static final String KEY__THIS_BINDING = "this";
    private static final String KEY__INCONSISTENT_SUBSTITUTIONS = "inconsistentSubstitutions";
    private static final String KEY__TYPE_REPLACEMENT = "typeReplacement";
    private static final String KEY__FIXED_CAPTURE_ID = "fixedCaptureId";
    public static final String GUARD_VARIABLE_DECLARATION = "varDecl";
    public static final String GUARD_TYPE_CALL_EXPRESSION = "typeCallExpression";
    public static final String GUARD_TYPE_PROPERTY_ACCESS_EXPRESSION = "typePropertyAccessExpression";
    public static final String GUARD_SUBTYPE_PARAMETERIZED_TYPE_REF__STRUCT = "subtypeRefParameterizedTypeRef__struct";
    public static final String GUARD_SUBST_TYPE_VARS = "substTypeVariablesInParameterizedTypeRef";
    public static final String GUARD_SUBST_TYPE_VARS__IMPLICIT_UPPER_BOUND_OF_WILDCARD = "substTypeVars_implicitUpperBoundOfWildcard";
    public static final String GUARD_STRUCTURAL_TYPING_COMPUTER = "StructuralTypingComputer";
    public static final String GUARD_CHECK_TYPE_ARGUMENT_COMPATIBILITY = "N4JSTypeSystem#checkTypeArgumentCompatibility";
    public static final String GUARD_REDUCER_IS_SUBTYPE_OF = "Reducer#isSubtypeOf";

    public static RuleEnvironment newRuleEnvironment(EObject context) {
        Resource res = context.eResource();
        if (res == null && context instanceof BoundThisTypeRef) {
            res = ((BoundThisTypeRef)context).getActualThisTypeRef().getDeclaredType().eResource();
        }
        RuleEnvironment G = new RuleEnvironment();
        RuleEnvironmentExtensions.setPredefinedTypesFromObjectsResourceSet(G, res.getResourceSet());
        G.put(Resource.class, res);
        return G;
    }

    public static RuleEnvironment newRuleEnvironment(Resource resource) {
        RuleEnvironment G = new RuleEnvironment();
        RuleEnvironmentExtensions.setPredefinedTypesFromObjectsResourceSet(G, resource.getResourceSet());
        G.put(Resource.class, resource);
        return G;
    }

    public static RuleEnvironment newRuleEnvironment(RuleEnvironment G) {
        RuleEnvironment Gnew = new RuleEnvironment();
        RuleEnvironmentExtensions.setPredefinedTypes(Gnew, RuleEnvironmentExtensions.getPredefinedTypes(G));
        Gnew.put(Resource.class, G.get(Resource.class));
        RuleEnvironmentExtensions.addCancelIndicator(Gnew, RuleEnvironmentExtensions.getCancelIndicator(G));
        return Gnew;
    }

    public static RuleEnvironment wrap(RuleEnvironment G) {
        return new RuleEnvironment(G);
    }

    public static boolean setPredefinedTypesFromObjectsResourceSet(RuleEnvironment G, ResourceSet resourceSet) {
        boolean _xblockexpression = false;
        if (resourceSet == null) {
            throw new IllegalArgumentException("Resource set used to load predefined types must not be null at org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions.setPredefinedTypesFromObjectsResourceSet(RuleEnvironment, ResourceSet)");
        }
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)resourceSet);
        GlobalObjectScope globalObjectTypeScope = GlobalObjectScope.get(resourceSet);
        VirtualBaseTypeScope virtualBaseTypeScope = VirtualBaseTypeScope.get(resourceSet);
        PredefinedTypes _predefinedTypes = new PredefinedTypes(builtInTypeScope, globalObjectTypeScope, virtualBaseTypeScope);
        _xblockexpression = G.put(PredefinedTypes.PREDEFINED_TYPES_KEY, _predefinedTypes);
        return _xblockexpression;
    }

    public static boolean setPredefinedTypes(RuleEnvironment G, PredefinedTypes predefinedTypes) {
        return G.put(PredefinedTypes.PREDEFINED_TYPES_KEY, predefinedTypes);
    }

    public static PredefinedTypes getPredefinedTypes(RuleEnvironment G) {
        Object _get = G.get(PredefinedTypes.PREDEFINED_TYPES_KEY);
        PredefinedTypes predefinedTypes = (PredefinedTypes)_get;
        if (predefinedTypes == null) {
            throw new IllegalStateException("Predefined types not set, call type system with configured rule environment");
        }
        return predefinedTypes;
    }

    public static BuiltInTypeScope getBuiltInTypeScope(RuleEnvironment G) {
        PredefinedTypes _predefinedTypes = null;
        if (G != null) {
            _predefinedTypes = RuleEnvironmentExtensions.getPredefinedTypes(G);
        }
        BuiltInTypeScope _builtInTypeScope = null;
        if (_predefinedTypes != null) {
            _builtInTypeScope = _predefinedTypes.builtInTypeScope;
        }
        return _builtInTypeScope;
    }

    public static GlobalObjectScope getGlobalObjectScope(RuleEnvironment G) {
        PredefinedTypes _predefinedTypes = null;
        if (G != null) {
            _predefinedTypes = RuleEnvironmentExtensions.getPredefinedTypes(G);
        }
        GlobalObjectScope _globalObjectScope = null;
        if (_predefinedTypes != null) {
            _globalObjectScope = _predefinedTypes.globalObjectScope;
        }
        return _globalObjectScope;
    }

    public static Resource getContextResource(RuleEnvironment G) {
        Object _get = G.get(Resource.class);
        return (Resource)_get;
    }

    public static void addCancelIndicator(RuleEnvironment G, CancelIndicator cancelIndicator) {
        G.put(KEY__CANCEL_INDICATOR, cancelIndicator);
    }

    public static CancelIndicator getCancelIndicator(RuleEnvironment G) {
        Object _get = G.get(KEY__CANCEL_INDICATOR);
        return (CancelIndicator)_get;
    }

    public static boolean isCanceled(RuleEnvironment G) {
        CancelIndicator cancelIndicator = RuleEnvironmentExtensions.getCancelIndicator(G);
        return cancelIndicator != null && cancelIndicator.isCanceled();
    }

    public static void addThisType(RuleEnvironment G, TypeRef actualThisTypeRef) {
        boolean _matched = false;
        if (actualThisTypeRef instanceof TypeTypeRef) {
            _matched = true;
            TypeArgument _typeArg = ((TypeTypeRef)actualThisTypeRef).getTypeArg();
            if (_typeArg instanceof TypeRef) {
                TypeArgument _typeArg_1 = ((TypeTypeRef)actualThisTypeRef).getTypeArg();
                RuleEnvironmentExtensions.addThisType(G, (TypeRef)_typeArg_1);
            }
        }
        if (!_matched && actualThisTypeRef instanceof ParameterizedTypeRef) {
            _matched = true;
            G.put(KEY__THIS_BINDING, TypeUtils.createBoundThisTypeRef((ParameterizedTypeRef)((ParameterizedTypeRef)actualThisTypeRef)));
        }
        if (!_matched && actualThisTypeRef instanceof BoundThisTypeRef) {
            _matched = true;
            G.put(KEY__THIS_BINDING, actualThisTypeRef);
        }
    }

    public static TypeRef getThisType(RuleEnvironment G) {
        Object _get = G.get(KEY__THIS_BINDING);
        return (TypeRef)_get;
    }

    public static void recordInconsistentSubstitutions(RuleEnvironment G) {
        G.put(KEY__INCONSISTENT_SUBSTITUTIONS, ArrayListMultimap.create());
    }

    public static void addInconsistentSubstitutions(RuleEnvironment G, TypeVariable typeVar, Collection<? extends TypeRef> substitutions) {
        Object _get = G.get(KEY__INCONSISTENT_SUBSTITUTIONS);
        ListMultimap storage = (ListMultimap)_get;
        if (storage != null) {
            storage.putAll((Object)typeVar, substitutions);
        }
    }

    public static List<TypeRef> getInconsistentSubstitutions(RuleEnvironment G, TypeVariable typeVar) {
        Object _get = G.get(KEY__INCONSISTENT_SUBSTITUTIONS);
        ListMultimap storage = (ListMultimap)_get;
        List _xifexpression = null;
        _xifexpression = storage != null ? storage.get((Object)typeVar) : Collections.emptyList();
        return _xifexpression;
    }

    public static void setTypeReplacement(RuleEnvironment G, ITypeReplacementProvider replacementProvider) {
        G.put(KEY__TYPE_REPLACEMENT, replacementProvider);
    }

    public static TypeRef getReplacement(RuleEnvironment G, TypeRef typeRef) {
        Type type;
        Type replacement;
        if (typeRef instanceof ParameterizedTypeRef && !(typeRef instanceof FunctionTypeRef) && (replacement = RuleEnvironmentExtensions.getReplacement(G, type = ((ParameterizedTypeRef)typeRef).getDeclaredType())) != type) {
            ParameterizedTypeRef cpy = (ParameterizedTypeRef)TypeUtils.copyWithProxies((EObject)((ParameterizedTypeRef)typeRef));
            cpy.setDeclaredType(replacement);
            return cpy;
        }
        return typeRef;
    }

    public static <T extends Type> T getReplacement(RuleEnvironment G, T type) {
        Object _get = G.get(KEY__TYPE_REPLACEMENT);
        ITypeReplacementProvider replacementProvider = (ITypeReplacementProvider)_get;
        T _replacement = null;
        if (replacementProvider != null) {
            _replacement = replacementProvider.getReplacement(type);
        }
        T replacement = _replacement;
        T _xifexpression = null;
        _xifexpression = replacement != null ? replacement : (T)type;
        return _xifexpression;
    }

    public static void addFixedCapture(RuleEnvironment G, ExistentialTypeRef etr) {
        UUID id = etr.getId();
        if (id != null) {
            Pair _mappedTo = Pair.of((Object)KEY__FIXED_CAPTURE_ID, (Object)id);
            G.put(_mappedTo, Boolean.TRUE);
        }
    }

    public static boolean isFixedCapture(RuleEnvironment G, ExistentialTypeRef etr) {
        UUID _id = etr.getId();
        Pair _mappedTo = Pair.of((Object)KEY__FIXED_CAPTURE_ID, (Object)_id);
        Object _get = G.get(_mappedTo);
        return _get != null;
    }

    public static TypeRef createTypeRefFromUpperBound(TypeVariable typeVar) {
        return (TypeRef)TypeUtils.copyIfContained((EObject)typeVar.getDeclaredUpperBound());
    }

    public static AnyType topType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.anyType(G);
    }

    public static ParameterizedTypeRef topTypeRef(RuleEnvironment G) {
        return RuleEnvironmentExtensions.anyTypeRef(G);
    }

    public static UndefinedType bottomType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.undefinedType(G);
    }

    public static ParameterizedTypeRef bottomTypeRef(RuleEnvironment G) {
        return RuleEnvironmentExtensions.undefinedTypeRef(G);
    }

    public static PrimitiveType booleanType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getBooleanType();
    }

    public static ParameterizedTypeRef booleanTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.booleanType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static PrimitiveType stringType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getStringType();
    }

    public static ParameterizedTypeRef stringTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.stringType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TObjectPrototype stringObjectType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getStringObjectType();
    }

    public static ParameterizedTypeRef stringObjectTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.stringObjectType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static PrimitiveType numberType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getNumberType();
    }

    public static ParameterizedTypeRef numberTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.numberType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static PrimitiveType intType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getIntType();
    }

    public static ParameterizedTypeRef intTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.intType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static PrimitiveType symbolType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getSymbolType();
    }

    public static ParameterizedTypeRef symbolTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.symbolType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TObjectPrototype symbolObjectType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getSymbolObjectType();
    }

    public static ParameterizedTypeRef symbolObjectTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.symbolObjectType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static AnyType anyType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getAnyType();
    }

    public static ParameterizedTypeRef anyTypeRef(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getAnyTypeRef();
    }

    public static ParameterizedTypeRef anyTypeRefDynamic(RuleEnvironment G) {
        ParameterizedTypeRef result = TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.anyType(G), (TypeArgument[])new TypeArgument[0]);
        result.setDynamic(true);
        return result;
    }

    public static ParameterizedTypeRef nullTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.nullType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static UndefinedType undefinedType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getUndefinedType();
    }

    public static NullType nullType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getNullType();
    }

    public static ParameterizedTypeRef undefinedTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.undefinedType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static VoidType voidType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getVoidType();
    }

    public static ParameterizedTypeRef voidTypeRef(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getVoidTypeRef();
    }

    public static TObjectPrototype regexpType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getRegexpType();
    }

    public static ParameterizedTypeRef regexpTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.regexpType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TObjectPrototype arrayType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getArrayType();
    }

    public static ParameterizedTypeRef arrayTypeRef(RuleEnvironment G, TypeArgument ... typeArgs) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.arrayType(G), (TypeArgument[])typeArgs);
    }

    public static TClassifier objectType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getObjectType();
    }

    public static ParameterizedTypeRef objectTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.objectType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TClass globalObjectType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).globalObjectScope.getGlobalObject();
    }

    public static ParameterizedTypeRef globalObjectTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.globalObjectType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TObjectPrototype functionType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getFunctionType();
    }

    public static ParameterizedTypeRef structuralFunctionTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.functionType(G), (TypingStrategy)TypingStrategy.STRUCTURAL, (TypeArgument[])new TypeArgument[0]);
    }

    public static ParameterizedTypeRef functionTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.functionType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TClass n4ObjectType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getN4ObjectType();
    }

    public static ParameterizedTypeRef n4ObjectTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.n4ObjectType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TObjectPrototype n4EnumType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getN4EnumType();
    }

    public static ParameterizedTypeRef n4EnumTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.n4EnumType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TObjectPrototype n4StringBasedEnumType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getN4StringBasedEnumType();
    }

    public static ParameterizedTypeRef n4StringBasedEnumTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.n4StringBasedEnumType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static PrimitiveType i18nKeyType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getI18nKeyType();
    }

    public static PrimitiveType pathSelectorType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getPathSelectorType();
    }

    public static PrimitiveType typeNameType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getTypeNameType();
    }

    public static TInterface n4ProviderType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getN4ProviderType();
    }

    public static TObjectPrototype errorType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getErrorType();
    }

    public static ParameterizedTypeRef errorTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.errorType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static VirtualBaseType argumentsType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).virtualBaseTypeScope.getArgumentsType();
    }

    public static ParameterizedTypeRef argumentsTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.argumentsType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TInterface migrationContextType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getMigrationContextType();
    }

    public static ParameterizedTypeRef migrationContextTypeRef(RuleEnvironment G) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.migrationContextType(G), (TypeArgument[])new TypeArgument[0]);
    }

    public static TInterface iterableType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getIterableType();
    }

    public static ParameterizedTypeRef iterableTypeRef(RuleEnvironment G, TypeArgument ... typeArgs) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.iterableType(G), (TypeArgument[])typeArgs);
    }

    public static TInterface iterableNType(RuleEnvironment G, int n) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getIterableNType(n);
    }

    public static ParameterizedTypeRef iterableNTypeRef(RuleEnvironment G, int n, TypeArgument ... typeArgs) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.iterableNType(G, n), (TypeArgument[])typeArgs);
    }

    public static List<TInterface> iterableNTypes(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getIterableNTypes();
    }

    public static boolean isIterableN(RuleEnvironment G, EObject obj) {
        Type type;
        Type _switchResult = null;
        boolean _matched = false;
        if (obj instanceof Type) {
            _matched = true;
            _switchResult = (Type)obj;
        }
        if (!_matched && obj instanceof TypeRef) {
            _matched = true;
            _switchResult = ((TypeRef)obj).getDeclaredType();
        }
        return (type = _switchResult) != null && RuleEnvironmentExtensions.iterableNTypes(G).contains(type);
    }

    public static TClass promiseType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getPromiseType();
    }

    public static ParameterizedTypeRef promiseTypeRef(RuleEnvironment G, TypeArgument ... typeArgs) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.promiseType(G), (TypeArgument[])typeArgs);
    }

    public static TInterface generatorType(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getGeneratorType();
    }

    public static ParameterizedTypeRef generatorTypeRef(RuleEnvironment G, TypeArgument ... typeArgs) {
        return TypeUtils.createTypeRef((Type)RuleEnvironmentExtensions.generatorType(G), (TypeArgument[])typeArgs);
    }

    public static boolean isNumeric(RuleEnvironment G, Type type) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.isNumeric(type);
    }

    public static boolean isAny(RuleEnvironment G, TypeArgument typeArg) {
        return typeArg != null && Objects.equal((Object)typeArg.getDeclaredType(), (Object)RuleEnvironmentExtensions.anyType(G));
    }

    public static boolean isObject(RuleEnvironment G, TypeArgument typeArg) {
        return typeArg != null && Objects.equal((Object)typeArg.getDeclaredType(), (Object)RuleEnvironmentExtensions.objectType(G));
    }

    public static boolean isFunction(RuleEnvironment G, TypeArgument typeArg) {
        return typeArg != null && Objects.equal((Object)typeArg.getDeclaredType(), (Object)RuleEnvironmentExtensions.functionType(G));
    }

    public static boolean isSymbol(RuleEnvironment G, TypeArgument typeArg) {
        return typeArg != null && Objects.equal((Object)typeArg.getDeclaredType(), (Object)RuleEnvironmentExtensions.symbolType(G));
    }

    public static boolean isNumeric(RuleEnvironment G, TypeArgument typeArg) {
        if (typeArg == null) {
            return false;
        }
        boolean _isNumeric = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.isNumeric(typeArg.getDeclaredType());
        if (_isNumeric) {
            return true;
        }
        if (typeArg instanceof UnionTypeExpression) {
            Functions.Function1 _function = e -> RuleEnvironmentExtensions.isNumeric(G, (TypeArgument)e);
            return IterableExtensions.forall((Iterable)((UnionTypeExpression)typeArg).getTypeRefs(), (Functions.Function1)_function);
        }
        if (typeArg instanceof IntersectionTypeExpression) {
            Functions.Function1 _function_1 = e -> RuleEnvironmentExtensions.isNumeric(G, (TypeArgument)e);
            return IterableExtensions.exists((Iterable)((IntersectionTypeExpression)typeArg).getTypeRefs(), (Functions.Function1)_function_1);
        }
        return false;
    }

    public static boolean containsNumericOperand(RuleEnvironment G, TypeRef typeRef) {
        if (typeRef instanceof UnionTypeExpression) {
            Functions.Function1 _function = e -> RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)ruleEnvironment).builtInTypeScope.isNumericOperand(e.getDeclaredType()) || RuleEnvironmentExtensions.containsNumericOperand(G, e);
            return IterableExtensions.exists((Iterable)((UnionTypeExpression)typeRef).getTypeRefs(), (Functions.Function1)_function);
        }
        return false;
    }

    public static boolean isNumericOperand(RuleEnvironment G, TypeRef typeRef) {
        if (typeRef == null) {
            return false;
        }
        boolean _isNumericOperand = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.isNumericOperand(typeRef.getDeclaredType());
        if (_isNumericOperand) {
            return true;
        }
        if (typeRef instanceof UnionTypeExpression) {
            Functions.Function1 _function = e -> RuleEnvironmentExtensions.isNumericOperand(G, e);
            return IterableExtensions.forall((Iterable)((UnionTypeExpression)typeRef).getTypeRefs(), (Functions.Function1)_function);
        }
        if (typeRef instanceof IntersectionTypeExpression) {
            Functions.Function1 _function_1 = e -> RuleEnvironmentExtensions.isNumericOperand(G, e);
            return IterableExtensions.exists((Iterable)((IntersectionTypeExpression)typeRef).getTypeRefs(), (Functions.Function1)_function_1);
        }
        return false;
    }

    public static TypeRef wrapTypeInTypeRef(RuleEnvironment G, Type type, TypeArgument ... typeArgs) {
        return TypeUtils.wrapTypeInTypeRef((BuiltInTypeScope)RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope, (Type)type, (TypeArgument[])typeArgs);
    }

    public static Set<TypeVariable> getTypeMappingKeys(RuleEnvironment G) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        RuleEnvironment env = G;
        while (env != null) {
            Iterable _filter = Iterables.filter(env.getEnvironment().keySet(), TypeVariable.class);
            Iterables.addAll((Collection)result, (Iterable)_filter);
            env = env.getNext();
        }
        return result;
    }

    public static void addTypeMappings(RuleEnvironment G, List<? extends TypeVariable> keys, List<? extends TypeArgument> values) {
        if (keys == null || values == null) {
            return;
        }
        int size = Math.min(keys.size(), values.size());
        int idx = 0;
        while (idx < size) {
            RuleEnvironmentExtensions.addTypeMapping(G, keys.get(idx), values.get(idx));
            ++idx;
        }
    }

    public static void addTypeMapping(RuleEnvironment G, TypeVariable key, TypeArgument value) {
        boolean _not;
        boolean _isValidTypeMapping = RuleEnvironmentExtensions.isValidTypeMapping(G, key, value);
        boolean bl = _not = !_isValidTypeMapping;
        if (_not) {
            return;
        }
        G.put(key, value);
    }

    public static boolean hasSubstitutionFor(RuleEnvironment G, Object typeVariable) {
        Object _xifexpression = null;
        _xifexpression = typeVariable instanceof TypeRef ? ((TypeRef)typeVariable).getDeclaredType() : typeVariable;
        Object key = _xifexpression;
        if (key instanceof TypeVariable) {
            Object value = G.get(key);
            return value != null && (!(value instanceof TypeRef) || ((TypeRef)value).getDeclaredType() != key);
        }
        return false;
    }

    public static boolean isValidTypeMapping(RuleEnvironment G, TypeVariable key, TypeArgument value) {
        Type _declaredType;
        boolean _isOrContainsRefToTypeVar = TypeUtils.isOrContainsRefToTypeVar((EObject)value, (TypeVariable[])new TypeVariable[]{key});
        if (_isOrContainsRefToTypeVar) {
            return false;
        }
        if (value instanceof DeferredTypeRef) {
            return false;
        }
        return !(value instanceof ParameterizedTypeRef) || !((_declaredType = ((ParameterizedTypeRef)value).getDeclaredType()) instanceof VoidType);
    }

    public static TClassifier getDeclaredOrImplicitSuperType(RuleEnvironment G, TClass tClass) {
        if (tClass.getSuperClassRef() != null && tClass.getSuperClassRef().getDeclaredType() instanceof TClassifier) {
            Type _declaredType = tClass.getSuperClassRef().getDeclaredType();
            return (TClassifier)_declaredType;
        }
        boolean _isExternal = tClass.isExternal();
        if (_isExternal) {
            return RuleEnvironmentExtensions.objectType(G);
        }
        return RuleEnvironmentExtensions.n4ObjectType(G);
    }

    public static List<ParameterizedTypeRef> collectAllImplicitSuperTypesOfType(RuleEnvironment G, Type declaredType) {
        RecursionGuard _recursionGuard = new RecursionGuard();
        return RuleEnvironmentExtensions.collectAllImplicitSuperTypesOfType(G, declaredType, (RecursionGuard<Type>)_recursionGuard);
    }

    private static List<ParameterizedTypeRef> collectAllImplicitSuperTypesOfType(RuleEnvironment G, Type declaredType, RecursionGuard<Type> guard) {
        List<Object> _xifexpression;
        boolean _not;
        List<ParameterizedTypeRef> _xblockexpression = null;
        if (declaredType == null) {
            return CollectionLiterals.emptyList();
        }
        boolean _tryNext = guard.tryNext((Object)declaredType);
        boolean bl = _not = !_tryNext;
        if (_not) {
            if (declaredType instanceof TClass) {
                if (Objects.equal((Object)declaredType, (Object)RuleEnvironmentExtensions.n4ObjectType(G)) || ((TClass)declaredType).isExternal() && !((TClass)declaredType).isDeclaredN4JS() || Objects.equal((Object)((TClass)declaredType).getTypingStrategy(), (Object)TypingStrategy.STRUCTURAL)) {
                    return RuleEnvironmentExtensions.getObjectPrototypesAllImplicitSuperTypeRefs(G);
                }
                return RuleEnvironmentExtensions.getN4ClassifiersAllImplicitSuperTypeRefs(G);
            }
            return CollectionLiterals.emptyList();
        }
        List<ParameterizedTypeRef> _switchResult = null;
        boolean _matched = false;
        if (declaredType instanceof TClass) {
            _matched = true;
            _xifexpression = null;
            if (Objects.equal((Object)declaredType, (Object)RuleEnvironmentExtensions.n4ObjectType(G)) || ((TClass)declaredType).isExternal() && !((TClass)declaredType).isDeclaredN4JS() || Objects.equal((Object)((TClass)declaredType).getTypingStrategy(), (Object)TypingStrategy.STRUCTURAL)) {
                _xifexpression = RuleEnvironmentExtensions.getObjectPrototypesAllImplicitSuperTypeRefs(G);
            } else {
                List<ParameterizedTypeRef> _xifexpression_1 = null;
                ParameterizedTypeRef _superClassRef = ((TClass)declaredType).getSuperClassRef();
                boolean _tripleEquals = _superClassRef == null;
                _xifexpression_1 = _tripleEquals ? RuleEnvironmentExtensions.getN4ClassifiersAllImplicitSuperTypeRefs(G) : RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, (TypeRef)((TClass)declaredType).getSuperClassRef(), guard);
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && declaredType instanceof TN4Classifier) {
            _matched = true;
            _switchResult = RuleEnvironmentExtensions.getN4ClassifiersAllImplicitSuperTypeRefs(G);
        }
        if (!_matched && declaredType instanceof TObjectPrototype) {
            _matched = true;
            _xifexpression = null;
            TClassifier _objectType = RuleEnvironmentExtensions.objectType(G);
            boolean _equals = Objects.equal((Object)declaredType, (Object)_objectType);
            _xifexpression = _equals ? CollectionLiterals.emptyList() : RuleEnvironmentExtensions.getObjectPrototypesAllImplicitSuperTypeRefs(G);
            _switchResult = _xifexpression;
        }
        if (!_matched && declaredType instanceof TEnum) {
            _matched = true;
            _xifexpression = null;
            boolean _isStringBasedEnumeration = TypeSystemHelper.isStringBasedEnumeration((TEnum)declaredType);
            if (_isStringBasedEnumeration) {
                ParameterizedTypeRef _n4StringBasedEnumTypeRef = RuleEnvironmentExtensions.n4StringBasedEnumTypeRef(G);
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ParameterizedTypeRef[]{_n4StringBasedEnumTypeRef}));
            } else {
                ParameterizedTypeRef _objectTypeRef = RuleEnvironmentExtensions.objectTypeRef(G);
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ParameterizedTypeRef[]{_objectTypeRef}));
            }
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public static List<ParameterizedTypeRef> _collectAllImplicitSuperTypes(RuleEnvironment G, TypeRef typeRef) {
        RecursionGuard _recursionGuard = new RecursionGuard();
        return RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, typeRef, (RecursionGuard<Type>)_recursionGuard);
    }

    public static List<ParameterizedTypeRef> _collectAllImplicitSuperTypes(RuleEnvironment G, IntersectionTypeExpression typeRef) {
        RecursionGuard _recursionGuard = new RecursionGuard();
        return RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, (TypeRef)typeRef, (RecursionGuard<Type>)_recursionGuard);
    }

    public static List<ParameterizedTypeRef> _collectAllImplicitSuperTypes(RuleEnvironment G, FunctionTypeExprOrRef typeRef) {
        RecursionGuard _recursionGuard = new RecursionGuard();
        return RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, (TypeRef)typeRef, (RecursionGuard<Type>)_recursionGuard);
    }

    private static List<ParameterizedTypeRef> _collectAllImplicitSuperTypes(RuleEnvironment G, TypeRef typeRef, RecursionGuard<Type> guard) {
        Type _declaredType = null;
        if (typeRef != null) {
            _declaredType = typeRef.getDeclaredType();
        }
        return RuleEnvironmentExtensions.collectAllImplicitSuperTypesOfType(G, _declaredType, guard);
    }

    private static List<ParameterizedTypeRef> _collectAllImplicitSuperTypes(RuleEnvironment G, IntersectionTypeExpression typeRef, RecursionGuard<Type> guard) {
        Functions.Function1 _function = it -> RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, it, guard);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)typeRef.getTypeRefs(), (Functions.Function1)_function)));
    }

    private static List<ParameterizedTypeRef> _collectAllImplicitSuperTypes(RuleEnvironment G, FunctionTypeExprOrRef typeRef, RecursionGuard<Type> guard) {
        return RuleEnvironmentExtensions.getFunctionTypesAllImplicitSuperTypeRefs(G);
    }

    public static Iterable<TypeRef> assignmentCompatibleTypes(RuleEnvironment G, TypeRef typeRef) {
        List _xblockexpression = null;
        Type declaredType = typeRef.getDeclaredType();
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (declaredType instanceof PrimitiveType) {
            _matched = true;
            _switchResult = RuleEnvironmentExtensions.assignmentCompatibleTypes(G, (PrimitiveType)declaredType);
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public static Iterable<TypeRef> assignmentCompatibleTypes(RuleEnvironment G, PrimitiveType pt) {
        List _xifexpression = null;
        PrimitiveType _assignmentCompatible = pt.getAssignmentCompatible();
        boolean _tripleNotEquals = _assignmentCompatible != null;
        _xifexpression = _tripleNotEquals ? ImmutableList.of((Object)TypeUtils.createTypeRef((Type)pt.getAssignmentCompatible(), (TypeArgument[])new TypeArgument[0])) : CollectionLiterals.emptyList();
        return _xifexpression;
    }

    public static List<ParameterizedTypeRef> getFunctionTypesAllImplicitSuperTypeRefs(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getFunctionTypesAllImplicitSuperTypeRefs();
    }

    public static List<ParameterizedTypeRef> getObjectPrototypesAllImplicitSuperTypeRefs(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getObjectPrototypesAllImplicitSuperTypeRefs();
    }

    public static List<ParameterizedTypeRef> getN4ClassifiersAllImplicitSuperTypeRefs(RuleEnvironment G) {
        return RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope.getN4ClassifiersAllImplicitSuperTypeRefs();
    }

    public static String ruleEnvAsString(RuleEnvironment G) {
        boolean _tripleNotEquals;
        String INDENT = "    ";
        StringBuffer result = new StringBuffer();
        result.append("RuleEnvironment@");
        result.append(Integer.toHexString(System.identityHashCode(G)));
        result.append(" {\n");
        result.append(RuleEnvironmentExtensions.typeVariableSubstitutionsAsString(G.getEnvironment(), "    "));
        RuleEnvironment _next = G.getNext();
        boolean bl = _tripleNotEquals = _next != null;
        if (_tripleNotEquals) {
            String _replaceAll = RuleEnvironmentExtensions.ruleEnvAsString(G.getNext()).replaceAll("\\n", "\n    ");
            String _plus = "    " + _replaceAll;
            result.append(_plus);
        }
        result.append("}");
        return result.toString();
    }

    protected static String typeVariableSubstitutionsAsString(Map<?, ?> substitutions, String indent) {
        ArrayList pairs = CollectionLiterals.newArrayList();
        Set<?> _keySet = substitutions.keySet();
        for (Object currKey : _keySet) {
            String _typeRefOrVariableAsString = RuleEnvironmentExtensions.typeRefOrVariableAsString(currKey);
            String _plus = String.valueOf(indent) + _typeRefOrVariableAsString;
            String _plus_1 = String.valueOf(_plus) + " -> ";
            String _typeRefOrVariableAsString_1 = RuleEnvironmentExtensions.typeRefOrVariableAsString(substitutions.get(currKey));
            String _plus_2 = String.valueOf(_plus_1) + _typeRefOrVariableAsString_1;
            String _plus_3 = String.valueOf(_plus_2) + "\n";
            pairs.add(_plus_3);
        }
        Collections.sort(pairs);
        return IterableExtensions.join((Iterable)pairs);
    }

    protected static String typeRefOrVariableAsString(Object obj) {
        String _xifexpression = null;
        if (obj instanceof Collection) {
            Functions.Function1 _function = it -> RuleEnvironmentExtensions.typeRefOrVariableAsString(it);
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)((Iterable)obj), (Functions.Function1)_function), (CharSequence)", ");
            String _plus = "[ " + _join;
            _xifexpression = String.valueOf(_plus) + " ]";
        } else {
            String _xifexpression_1 = null;
            if (obj instanceof TypeVariable) {
                String _xblockexpression = null;
                EObject parent = ((TypeVariable)obj).eContainer();
                String _xifexpression_2 = null;
                if (parent instanceof IdentifiableElement) {
                    String _name = ((IdentifiableElement)parent).getName();
                    String _plus_1 = String.valueOf(_name) + "#";
                    String _name_1 = ((TypeVariable)obj).getName();
                    _xifexpression_2 = String.valueOf(_plus_1) + _name_1;
                } else {
                    String _xifexpression_3 = null;
                    if (parent != null && parent.eClass() != null) {
                        String _name_2 = parent.eClass().getName();
                        String _plus_2 = String.valueOf(_name_2) + "#";
                        String _name_3 = ((TypeVariable)obj).getName();
                        _xifexpression_3 = String.valueOf(_plus_2) + _name_3;
                    } else {
                        String _name_4 = ((TypeVariable)obj).getName();
                        _xifexpression_3 = "#" + _name_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression = _xifexpression_2;
            } else {
                String _xifexpression_2 = null;
                if (obj instanceof TypeRef && ((TypeRef)obj).getDeclaredType() instanceof TypeVariable) {
                    _xifexpression_2 = RuleEnvironmentExtensions.typeRefOrVariableAsString(((TypeRef)obj).getDeclaredType());
                } else {
                    String _xifexpression_3 = null;
                    _xifexpression_3 = obj instanceof TypeRef ? ((TypeRef)obj).getTypeRefAsString() : obj.toString();
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static boolean isInReturnDeclaration_Of_StaticMethod(EObject locationToCheck, N4MethodDeclaration container) {
        boolean _not;
        boolean _isStatic = container.isStatic();
        boolean bl = _not = !_isStatic;
        if (_not) {
            return false;
        }
        boolean isInReturn = EcoreUtil2.isAncestor((EObject)container.getReturnTypeRef(), (EObject)locationToCheck);
        return isInReturn;
    }

    public static boolean isInBody_Of_StaticMethod(EObject locationToCheck, N4MethodDeclaration container) {
        boolean _not;
        boolean _isStatic = container.isStatic();
        boolean bl = _not = !_isStatic;
        if (_not) {
            return false;
        }
        boolean isInBody = EcoreUtil2.isAncestor((EObject)container.getBody(), (EObject)locationToCheck);
        return isInBody;
    }

    public static List<ParameterizedTypeRef> collectAllImplicitSuperTypes(RuleEnvironment G, TypeRef typeRef) {
        if (typeRef instanceof IntersectionTypeExpression) {
            return RuleEnvironmentExtensions._collectAllImplicitSuperTypes(G, (IntersectionTypeExpression)typeRef);
        }
        if (typeRef instanceof FunctionTypeExprOrRef) {
            return RuleEnvironmentExtensions._collectAllImplicitSuperTypes(G, (FunctionTypeExprOrRef)typeRef);
        }
        if (typeRef != null) {
            return RuleEnvironmentExtensions._collectAllImplicitSuperTypes(G, typeRef);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(G, typeRef).toString());
    }

    private static List<ParameterizedTypeRef> collectAllImplicitSuperTypes(RuleEnvironment G, TypeRef typeRef, RecursionGuard<Type> guard) {
        if (typeRef instanceof IntersectionTypeExpression) {
            return RuleEnvironmentExtensions._collectAllImplicitSuperTypes(G, (IntersectionTypeExpression)typeRef, guard);
        }
        if (typeRef instanceof FunctionTypeExprOrRef) {
            return RuleEnvironmentExtensions._collectAllImplicitSuperTypes(G, (FunctionTypeExprOrRef)typeRef, guard);
        }
        if (typeRef != null) {
            return RuleEnvironmentExtensions._collectAllImplicitSuperTypes(G, typeRef, guard);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(G, typeRef, guard).toString());
    }
}

