/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.versioning;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4idl.scoping.VersionScopeProvider;
import org.eclipse.n4js.n4idl.versioning.VersionUtils;
import org.eclipse.n4js.ts.typeRefs.VersionedReference;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TVersionable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.versions.VersionableUtils;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class VersionHelper {
    @Inject
    private VersionScopeProvider versionScopeProvider;
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private ContainerTypesHelper containerTypesHelper;

    public Optional<Integer> computeMaximumVersion(EObject object) {
        boolean _isVersioned;
        boolean _hasRequestedVersion;
        if (object == null) {
            return Optional.absent();
        }
        boolean _matched = false;
        if (object instanceof VersionedReference && (_hasRequestedVersion = ((VersionedReference)object).hasRequestedVersion())) {
            _matched = true;
            return Optional.of((Object)((VersionedReference)object).getRequestedVersionOrZero());
        }
        if (!_matched && object instanceof N4ClassDeclaration && (_isVersioned = VersionUtils.isVersioned(object))) {
            _matched = true;
            Type _definedType = ((N4ClassDeclaration)object).getDefinedType();
            return this.computeMaximumVersionForVersionable((TVersionable)((TClass)_definedType));
        }
        if (!_matched && object instanceof N4InterfaceDeclaration && (_isVersioned = VersionUtils.isVersioned(object))) {
            _matched = true;
            Type _definedType = ((N4InterfaceDeclaration)object).getDefinedType();
            return this.computeMaximumVersionForVersionable((TVersionable)((TInterface)_definedType));
        }
        if (!_matched && object instanceof N4EnumDeclaration && (_isVersioned = VersionUtils.isVersioned(object))) {
            _matched = true;
            Type _definedType = ((N4EnumDeclaration)object).getDefinedType();
            return this.computeMaximumVersionForVersionable((TVersionable)((TEnum)_definedType));
        }
        if (!_matched && object instanceof FunctionDeclaration && (_isVersioned = VersionUtils.isVersioned(object))) {
            _matched = true;
            Type _definedType = ((FunctionDeclaration)object).getDefinedType();
            return this.computeMaximumVersionForVersionable((TVersionable)((TFunction)_definedType));
        }
        if (!_matched && object instanceof TClassifier) {
            _matched = true;
            return this.computeMaximumVersionForVersionable((TVersionable)object);
        }
        return this.computeMaximumVersion(object.eContainer());
    }

    private Optional<Integer> computeMaximumVersionForVersionable(TVersionable versionableType) {
        if (versionableType == null) {
            return Optional.absent();
        }
        int lowerLimit = versionableType.getVersion();
        return this.computeUpperLimit(versionableType, lowerLimit);
    }

    private Optional<Integer> computeUpperLimit(TVersionable versionable, int lowerLimit) {
        IScope scope = this.versionScopeProvider.getVersionScope((Type)versionable);
        QualifiedName name = this.nameConverter.toQualifiedName(versionable.getName());
        Iterable elements = scope.getElements(name);
        Functions.Function1 _function = it -> it.getEObjectOrProxy() instanceof Type && it.getEObjectOrProxy() instanceof TVersionable;
        Functions.Function1 _function_1 = it -> {
            EObject _eObjectOrProxy = it.getEObjectOrProxy();
            return (Type)_eObjectOrProxy;
        };
        Functions.Function1 _function_2 = it -> {
            int _version = it.getVersion();
            return _version > lowerLimit;
        };
        Functions.Function2 _function_3 = (u, c) -> {
            int _version = c.getVersion();
            int _minus = _version - 1;
            return Integer.min(u, _minus);
        };
        return Optional.of((Object)((Integer)IterableExtensions.fold((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)elements, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Object)Integer.MAX_VALUE, (Functions.Function2)_function_3)));
    }

    public <T extends Type> Iterable<? extends T> findTypeVersions(T type) {
        if (type instanceof TObjectPrototype || !VersionableUtils.isTVersionable(type)) {
            return Collections.singleton(type);
        }
        IScope scope = this.versionScopeProvider.getVersionScope(type);
        QualifiedName name = this.nameConverter.toQualifiedName(type.getName());
        Iterable elements = scope.getElements(name);
        Functions.Function1 _function = d -> d.getEObjectOrProxy();
        Functions.Function1 _function_1 = o -> type.getClass().isInstance(o);
        Functions.Function1 _function_2 = t -> {
            Type _cast = (Type)type.getClass().cast(t);
            return _cast;
        };
        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)elements, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }

    public <T extends Type> T findTypeWithVersion(T type, int version) {
        if (type instanceof TObjectPrototype) {
            return type;
        }
        Iterable<T> elements = this.findTypeVersions(type);
        Functions.Function1 _function = it -> {
            int _version = it.getVersion();
            return _version <= version;
        };
        Functions.Function2 _function_1 = (l, c) -> {
            int _version_1;
            Type _xifexpression = null;
            int _version = l.getVersion();
            boolean _greaterThan = _version > (_version_1 = c.getVersion());
            _xifexpression = _greaterThan ? l : c;
            return _xifexpression;
        };
        return (T)((Type)IterableExtensions.reduce((Iterable)IterableExtensions.filter(elements, (Functions.Function1)_function), (Functions.Function2)_function_1));
    }

    public <T extends TMember> T findMemberWithVersion(T member, int version) {
        ContainerType container = member.getContainingType();
        if (container instanceof TClassifier) {
            TClassifier containerInRequestedVersion = this.findTypeWithVersion((TClassifier)container, version);
            ContainerTypesHelper.MemberCollector memberCollector = this.containerTypesHelper.fromContext((EObject)containerInRequestedVersion);
            TMember result = memberCollector.findMember((ContainerType<?>)containerInRequestedVersion, member.getName(), false, member.isStatic());
            return (T)result;
        }
        return member;
    }
}

