/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.n4js.tester.ui.resultsview.TestResultHyperlink;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;
import org.eclipse.n4js.transpiler.sourcemap.SourceMap;
import org.eclipse.n4js.transpiler.sourcemap.SourceMapFileLocator;
import org.eclipse.n4js.ui.console.JSStackTraceLocationText;

public class TestResultHyperlinkDetector
extends AbstractHyperlinkDetector {
    @Inject
    private SourceMapFileLocator sourceMapFileLocator;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String candidate;
        IRegion lineRegion;
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        try {
            lineRegion = document.getLineInformationOfOffset(offset);
            candidate = document.get(lineRegion.getOffset(), lineRegion.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        Matcher matcher = JSStackTraceLocationText.JAVASCRIPT_STRACKTRACE_LOCATION_PATTERN.matcher(candidate);
        ArrayList<TestResultHyperlink> links = new ArrayList<TestResultHyperlink>();
        while (matcher.find()) {
            JSStackTraceLocationText generatedLocation = new JSStackTraceLocationText(matcher);
            Region linkRegion = new Region(lineRegion.getOffset() + matcher.start(), matcher.end() - matcher.start());
            JSStackTraceLocationText originalLocation = this.retrieveOriginal(generatedLocation);
            if (originalLocation != null) {
                links.add(new TestResultHyperlink((IRegion)linkRegion, originalLocation));
                if (!canShowMultipleHyperlinks) break;
            }
            links.add(new TestResultHyperlink((IRegion)linkRegion, generatedLocation));
            if (!canShowMultipleHyperlinks) break;
        }
        if (links.isEmpty()) {
            return null;
        }
        IHyperlink[] hyperlinks = new IHyperlink[links.size()];
        links.toArray(hyperlinks);
        return hyperlinks;
    }

    private JSStackTraceLocationText retrieveOriginal(JSStackTraceLocationText locationText) {
        File file = new File(locationText.fileName);
        if (file.exists() && file.isFile()) {
            MappingEntry mappingEntry;
            SourceMap sourceMap;
            block8: {
                block7: {
                    File sourceMapFile;
                    block6: {
                        Path path = file.toPath();
                        sourceMapFile = this.sourceMapFileLocator.resolveSourceMapFromGen(path);
                        if (sourceMapFile != null) break block6;
                        return null;
                    }
                    sourceMap = SourceMap.loadAndResolve((Path)sourceMapFile.toPath());
                    if (sourceMap != null) break block7;
                    return null;
                }
                mappingEntry = sourceMap.findMappingForGenPosition(locationText.line - 1, locationText.column - 1);
                if (mappingEntry != null) break block8;
                return null;
            }
            try {
                Path sourcePath = (Path)sourceMap.getResolvedSources().get(mappingEntry.srcIndex);
                return new JSStackTraceLocationText(sourcePath, mappingEntry.srcLine + 1, mappingEntry.srcColumn + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

