/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.organize.imports;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TAnnotationArgument;
import org.eclipse.n4js.ts.types.TAnnotationTypeRefArgument;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.AllSuperTypesCollector;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DIUtility {
    public static boolean isSingleton(Type type) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)AnnotationDefinition.SINGLETON.name);
        };
        return IterableExtensions.exists((Iterable)type.getAnnotations(), (Functions.Function1)_function);
    }

    public static boolean hasSuperType(Type type) {
        boolean _xifexpression = false;
        if (type instanceof TClass) {
            ParameterizedTypeRef _superClassRef = ((TClass)type).getSuperClassRef();
            Type _declaredType = null;
            if (_superClassRef != null) {
                _declaredType = _superClassRef.getDeclaredType();
            }
            _xifexpression = _declaredType instanceof TClass;
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public static boolean hasInjectedMembers(Type type) {
        boolean _xifexpression = false;
        if (type instanceof TClass) {
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)it_1);
                return IterableExtensions.exists((Iterable)it.getOwnedMembers(), (Functions.Function1)_function_1);
            };
            _xifexpression = IterableExtensions.exists((Iterable)AllSuperTypesCollector.collect((ContainerType)((ContainerType)type)), (Functions.Function1)_function);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public static boolean isInjectedClass(Type it) {
        return DIUtility.isSingleton(it) || DIUtility.hasInjectedMembers(it) || DIUtility.hasSuperType(it);
    }

    public static boolean isBinder(Type type) {
        return AnnotationDefinition.BINDER.hasAnnotation((TAnnotableElement)type);
    }

    public static boolean isDIComponent(Type type) {
        return AnnotationDefinition.GENERATE_INJECTOR.hasAnnotation((TAnnotableElement)type);
    }

    public static boolean hasParentInjector(Type type) {
        boolean _or = false;
        boolean _hasAnnotation = AnnotationDefinition.WITH_PARENT_INJECTOR.hasAnnotation((TAnnotableElement)type);
        if (_hasAnnotation) {
            _or = true;
        } else {
            ParameterizedTypeRef _superClassRef;
            boolean _xifexpression = false;
            _xifexpression = type instanceof TClass ? (_superClassRef = ((TClass)type).getSuperClassRef()) != null : false;
            _or = _xifexpression;
        }
        return _or;
    }

    public static Type findParentDIC(Type type) {
        ParameterizedTypeRef _xifexpression = null;
        boolean _hasAnnotation = AnnotationDefinition.WITH_PARENT_INJECTOR.hasAnnotation((TAnnotableElement)type);
        if (_hasAnnotation) {
            TAnnotation _ownedAnnotation = AnnotationDefinition.WITH_PARENT_INJECTOR.getOwnedAnnotation((TAnnotableElement)type);
            EList _args = null;
            if (_ownedAnnotation != null) {
                _args = _ownedAnnotation.getArgs();
            }
            TAnnotationArgument _head = (TAnnotationArgument)IterableExtensions.head(_args);
            _xifexpression = ((TAnnotationTypeRefArgument)_head).getTypeRef();
        } else {
            ParameterizedTypeRef _xifexpression_1 = null;
            _xifexpression_1 = type instanceof TClass ? ((TClass)type).getSuperClassRef() : null;
            _xifexpression = _xifexpression_1;
        }
        ParameterizedTypeRef parent = _xifexpression;
        if (parent != null) {
            return parent.getDeclaredType();
        }
        String _name = type.getName();
        String _plus = "no parent on " + _name;
        throw new RuntimeException(_plus);
    }

    public static List<Type> resolveBinders(Type type) {
        Functions.Function1 _function = it -> it.getArgs();
        Functions.Function1 _function_1 = it -> ((TAnnotationTypeRefArgument)it).getTypeRef().getDeclaredType();
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)IterableExtensions.map(AnnotationDefinition.USE_BINDER.getAllOwnedAnnotations((TAnnotableElement)type), (Functions.Function1)_function)), (Functions.Function1)_function_1)));
    }

    public static boolean requiresInjection(Type type) {
        boolean _xifexpression = false;
        if (type instanceof TClass) {
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)it_1);
                return IterableExtensions.exists((Iterable)it.getOwnedMembers(), (Functions.Function1)_function_1);
            };
            _xifexpression = IterableExtensions.exists((Iterable)AllSuperTypesCollector.collect((ContainerType)((ContainerType)type)), (Functions.Function1)_function);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public static boolean requiresInjection(TypeRef it) {
        return DIUtility.requiresInjection(it.getDeclaredType()) || DIUtility.isProviderType(it) && DIUtility.requiresInjection(DIUtility.getProvidedType(it));
    }

    public static boolean isProviderType(TypeRef it) {
        return it != null && it.getDeclaredType() == RuleEnvironmentExtensions.n4ProviderType(RuleEnvironmentExtensions.newRuleEnvironment((EObject)it));
    }

    public static Type getProvidedType(TypeRef it) {
        boolean _not;
        boolean _isProviderType = DIUtility.isProviderType(it);
        boolean bl = _not = !_isProviderType;
        if (_not) {
            return null;
        }
        TypeRef nestedTypeRef = it;
        while (DIUtility.isProviderType(nestedTypeRef) && nestedTypeRef instanceof ParameterizedTypeRef) {
            Iterable typeArgs = Iterables.filter((Iterable)((ParameterizedTypeRef)nestedTypeRef).getTypeArgs(), TypeRef.class);
            TypeRef _xifexpression = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)typeArgs);
            _xifexpression = _isNullOrEmpty ? null : (TypeRef)IterableExtensions.head((Iterable)typeArgs);
            nestedTypeRef = _xifexpression;
        }
        Type _declaredType = null;
        if (nestedTypeRef != null) {
            _declaredType = nestedTypeRef.getDeclaredType();
        }
        return _declaredType;
    }
}

