/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import java.io.File;
import java.security.Permission;
import java.util.concurrent.TimeUnit;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.N4jscTestFactory;
import org.eclipse.n4js.cli.helper.CliResult;
import org.eclipse.n4js.cli.helper.N4jscTestCallback;
import org.eclipse.n4js.cli.helper.SystemOutRedirecter;
import org.junit.Assert;

public abstract class AbstractCliTest<ArgType> {
    private final SystemOutRedirecter systemOutRedirecter = new SystemOutRedirecter();

    public abstract void doMain(ArgType var1, CliResult var2) throws Exception;

    public final void setN4jscRedirections() {
        this.internalSetN4jscRedirections();
        N4jscTestFactory.set();
    }

    public final void setN4jscRedirectionsDeactivateBackend() {
        this.internalSetN4jscRedirections();
        N4jscTestFactory.setAndDeactivateBackend();
    }

    private void internalSetN4jscRedirections() {
        this.systemOutRedirecter.setRedirections();
        System.setSecurityManager(new NoExitSecurityManager());
    }

    public final void unsetN4jscRedirections() {
        this.systemOutRedirecter.unsetRedirections();
        System.setSecurityManager(null);
        N4jscTestFactory.unset();
    }

    protected CliResult main(ArgType args) {
        return this.main(args, 0);
    }

    protected CliResult main(ArgType args, int exitCode) {
        return this.main(args, exitCode, true);
    }

    protected CliResult main(ArgType args, int exitCode, boolean removeUsage) {
        CliResult cliResult;
        block11: {
            cliResult = new CliResult();
            Stopwatch sw = Stopwatch.createStarted();
            try {
                this.setN4jscRedirections();
                this.doMain(args, cliResult);
            }
            catch (SystemExitException e) {
                cliResult.exitCode = e.status;
                Assert.assertEquals((long)exitCode, (long)e.status);
                cliResult.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
                cliResult.stdOut = this.systemOutRedirecter.getSystemOut();
                cliResult.errOut = this.systemOutRedirecter.getSystemErr();
                Injector lastCreatedInjector = N4jscTestFactory.getLastCreatedInjector();
                if (lastCreatedInjector != null) {
                    N4jscTestCallback callback = (N4jscTestCallback)N4jscFactory.getLanguageClient((Injector)lastCreatedInjector);
                    cliResult.errors = callback.errors;
                    cliResult.warnings = callback.warnings;
                }
                this.unsetN4jscRedirections();
                break block11;
            }
            catch (Exception e) {
                try {
                    cliResult.cause = e;
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                catch (Throwable throwable) {
                    cliResult.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
                    cliResult.stdOut = this.systemOutRedirecter.getSystemOut();
                    cliResult.errOut = this.systemOutRedirecter.getSystemErr();
                    Injector lastCreatedInjector = N4jscTestFactory.getLastCreatedInjector();
                    if (lastCreatedInjector != null) {
                        N4jscTestCallback callback = (N4jscTestCallback)N4jscFactory.getLanguageClient((Injector)lastCreatedInjector);
                        cliResult.errors = callback.errors;
                        cliResult.warnings = callback.warnings;
                    }
                    this.unsetN4jscRedirections();
                    throw throwable;
                }
                cliResult.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
                cliResult.stdOut = this.systemOutRedirecter.getSystemOut();
                cliResult.errOut = this.systemOutRedirecter.getSystemErr();
                Injector lastCreatedInjector = N4jscTestFactory.getLastCreatedInjector();
                if (lastCreatedInjector != null) {
                    N4jscTestCallback callback = (N4jscTestCallback)N4jscFactory.getLanguageClient((Injector)lastCreatedInjector);
                    cliResult.errors = callback.errors;
                    cliResult.warnings = callback.warnings;
                }
                this.unsetN4jscRedirections();
                break block11;
            }
            cliResult.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
            cliResult.stdOut = this.systemOutRedirecter.getSystemOut();
            cliResult.errOut = this.systemOutRedirecter.getSystemErr();
            Injector lastCreatedInjector = N4jscTestFactory.getLastCreatedInjector();
            if (lastCreatedInjector != null) {
                N4jscTestCallback callback = (N4jscTestCallback)N4jscFactory.getLanguageClient((Injector)lastCreatedInjector);
                cliResult.errors = callback.errors;
                cliResult.warnings = callback.warnings;
            }
            this.unsetN4jscRedirections();
        }
        String curDirPath = new File("").getAbsolutePath();
        cliResult.stdOut = cliResult.stdOut.replace(curDirPath, "");
        cliResult.errOut = cliResult.errOut.replace(curDirPath, "");
        if (removeUsage) {
            cliResult.stdOut = cliResult.stdOut.replace(N4jscOptions.USAGE, "");
            cliResult.errOut = cliResult.errOut.replace(N4jscOptions.USAGE, "");
        }
        cliResult.stdOut = cliResult.stdOut.trim();
        cliResult.errOut = cliResult.errOut.trim();
        return cliResult;
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        private final SecurityManager securityManager = System.getSecurityManager();

        NoExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.securityManager != null) {
                this.securityManager.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.securityManager != null) {
                this.securityManager.checkPermission(perm, context);
            }
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new SystemExitException(status);
        }
    }

    static class SystemExitException
    extends SecurityException {
        public final int status;

        public SystemExitException(int status) {
            this.status = status;
        }
    }
}

