/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.runner.helper;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.IllegalBinaryStateException;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class NodejsRunner {
    private static final String NODE_PATH = "NODE_PATH";
    private static final String NODE_PATH_SEP = File.pathSeparator;
    private static final Splitter OPTIONS_SPLITTER = Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();
    private final NodeJsBinary nodeJsBinary;

    public NodejsRunner(NodeJsBinary nodeJsBinary) {
        this.nodeJsBinary = nodeJsBinary;
    }

    public Process run(RunConfiguration runConfig) throws ExecutionException {
        Path workingDirectory;
        IStatus status = this.nodeJsBinary.validate();
        if (!status.isOK()) {
            Exceptions.sneakyThrow((Throwable)new IllegalBinaryStateException((Binary)this.nodeJsBinary, status));
        }
        if ((workingDirectory = runConfig.getWorkingDirectory()) == null) {
            throw new IllegalArgumentException("run configuration does not specify a working directory");
        }
        Map<String, String> env = new LinkedHashMap<String, String>();
        env.putAll(runConfig.getEnvironmentVariables());
        Collection additionalPaths = runConfig.getAdditionalPaths();
        if (additionalPaths != null && !additionalPaths.isEmpty()) {
            env.put(NODE_PATH, Joiner.on((String)NODE_PATH_SEP).join((Iterable)additionalPaths));
        }
        env = this.nodeJsBinary.updateEnvironment(env);
        String[] cmd = this.createCommand(runConfig);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.environment().putAll(env);
        pb.directory(workingDirectory.toFile());
        try {
            return pb.start();
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    private String[] createCommand(RunConfiguration runConfig) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.nodeJsBinary.getBinaryAbsolutePath());
        cmd.add("-r");
        cmd.add("esm");
        String engineOptions = runConfig.getEngineOptions();
        for (String engineOption : this.splitOptions(engineOptions)) {
            cmd.add(engineOption);
        }
        Path fileToRun = runConfig.getFileToRun();
        if (fileToRun == null) {
            throw new IllegalArgumentException("run configuration does not specify a file to run");
        }
        cmd.add(fileToRun.toString());
        String runOptions = runConfig.getRunOptions();
        for (String runOption : this.splitOptions(runOptions)) {
            cmd.add(runOption);
        }
        return cmd.toArray(new String[0]);
    }

    private Iterable<String> splitOptions(String optionsString) {
        return optionsString != null ? OPTIONS_SPLITTER.split((CharSequence)optionsString.trim()) : Collections.emptyList();
    }
}

