/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import java.io.PrintStream;
import java.util.Stack;

public class N4jscConsole {
    private static final Stack<String> moduleNames = new Stack();

    public static PrintStream getPrintStream() {
        return System.out;
    }

    public static void println(String msg) {
        N4jscConsole.println(N4jscConsole.getPrintStream(), msg);
    }

    public static void println(PrintStream ps, String msg) {
        ps.println(N4jscConsole.addModuleNamePrefix(msg));
    }

    private static String addModuleNamePrefix(String msg) {
        if (moduleNames.isEmpty()) {
            return msg;
        }
        String prefix = "[" + String.join((CharSequence)">", moduleNames) + "]";
        return String.valueOf(prefix) + " " + msg;
    }

    public static AutoCloseable addModuleName(final String moduleName) {
        moduleNames.add(moduleName);
        AutoCloseable ac = new AutoCloseable(){

            @Override
            public void close() throws Exception {
                if (moduleName.equals(moduleNames.peek())) {
                    moduleNames.pop();
                }
            }
        };
        return ac;
    }
}

