/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.n4js.cli.N4jscBackend;
import org.eclipse.n4js.cli.N4jscConsole;
import org.eclipse.n4js.cli.N4jscException;
import org.eclipse.n4js.cli.N4jscExitCode;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.N4jscOptionsValidater;

public class N4jscMain {
    public static void main(String[] args) {
        N4jscOptions options = N4jscMain.getOptions(args);
        if (options.getPerformanceReport() != null) {
            N4jscConsole.println("Performance Data Collection is enabled.");
        }
        if (options.isShowSetup()) {
            N4jscConsole.println(options.toSettingsString());
        }
        if (!options.isVerbose()) {
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)new NullAppender());
        }
        try {
            try {
                N4jscMain.performGoal(options);
            }
            catch (N4jscException e) {
                throw e;
            }
            catch (Exception e) {
                throw new N4jscException(N4jscExitCode.ERROR_UNEXPECTED, (Throwable)e);
            }
        }
        catch (N4jscException e) {
            N4jscConsole.println(e.toUserString());
            System.exit(e.getExitCode());
        }
        System.exit(N4jscExitCode.SUCCESS.getExitCodeValue());
    }

    private static N4jscOptions getOptions(String[] args) {
        N4jscOptions options = new N4jscOptions();
        try {
            try {
                options.read(args);
            }
            finally {
                if (options.isVerbose()) {
                    N4jscConsole.println(options.toCallString());
                }
            }
            N4jscOptionsValidater.validate(options);
            return options;
        }
        catch (N4jscException e) {
            N4jscConsole.println(e.toUserString());
            N4jscConsole.println(N4jscOptions.USAGE);
            System.exit(e.getExitCode());
            return null;
        }
    }

    private static void performGoal(N4jscOptions options) throws Exception {
        N4jscBackend backend = N4jscFactory.createBackend();
        switch (options.getGoal()) {
            case help: {
                options.printUsage(N4jscConsole.getPrintStream());
                return;
            }
            case version: {
                throw new N4jscException(N4jscExitCode.NOT_IMPLEMENTED);
            }
            case lsp: {
                backend.goalLsp(options);
                return;
            }
            case clean: {
                backend.goalClean(options);
                return;
            }
            case compile: {
                backend.goalCompile(options);
                return;
            }
            case api: {
                backend.goalApi(options);
                return;
            }
            case watch: {
                backend.goalWatch(options);
                return;
            }
        }
    }
}

