/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.antlr.N4AntlrGeneratorFragment2;
import org.eclipse.n4js.antlr.replacements.Replacements;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;
import org.eclipse.xtext.xtext.generator.grammarAccess.GrammarAccessExtensions;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GeneratedJavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;
import org.eclipse.xtext.xtext.generator.parser.antlr.ContentAssistGrammarNaming;
import org.eclipse.xtext.xtext.generator.parser.antlr.GrammarNaming;
import org.eclipse.xtext.xtext.generator.util.SyntheticTerminalDetector;

@Log
public class N4JSAntlrGeneratorFragment2
extends N4AntlrGeneratorFragment2 {
    @Inject
    private GrammarNaming productionNaming;
    @Inject
    private ReflectExtensions reflector;
    @Inject
    @Extension
    private GrammarAccessExtensions grammarUtil;
    @Inject
    @Extension
    private SyntheticTerminalDetector _syntheticTerminalDetector;
    private static final Logger LOG = Logger.getLogger(N4JSAntlrGeneratorFragment2.class);

    protected void generateProductionGrammar() {
        super.generateProductionGrammar();
        GrammarNaming naming = this.productionNaming;
        String _path = this.getProjectConfig().getRuntime().getSrcGen().getPath();
        String _plus = String.valueOf(_path) + "/";
        String _grammarFileName = naming.getParserGrammar(this.getGrammar()).getGrammarFileName();
        String absoluteParserFileName = String.valueOf(_plus) + _grammarFileName;
        this.massageGrammar(absoluteParserFileName, this.getCodeConfig().getEncoding());
    }

    private void massageGrammar(String absoluteParserFileName, String encoding) {
        try {
            boolean _equals_1;
            boolean _not;
            String javaFile = absoluteParserFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
            File _file = new File(javaFile);
            String content = Files.asCharSource((File)_file, (Charset)Charset.forName(encoding)).read();
            String normalizedContent = content.replace("\r\n", "\n");
            String newContent = this.fixIdentifierAsKeywordWithEOLAwareness(normalizedContent);
            boolean _equals = normalizedContent.equals(newContent);
            if (_equals) {
                LOG.warn((Object)("Replacement not found in " + javaFile));
            }
            boolean bl = _not = !(_equals_1 = content.equals(newContent));
            if (_not) {
                File _file_1 = new File(javaFile);
                Files.asCharSink((File)_file_1, (Charset)Charset.forName(encoding), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)newContent);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected String getParserFileNameSuffix() {
        return ".java";
    }

    protected String getLexerFileNameSuffix() {
        return ".java";
    }

    private String fixIdentifierAsKeywordWithEOLAwareness(String normalizedContent) {
        String c1 = Replacements.applyReplacement(normalizedContent, "ruleNoLineTerminator.java.replacement");
        String c2 = Replacements.applyReplacement(c1, "rulePrimaryExpression.java.replacement");
        return c2;
    }

    private <T> T reflectiveGet(String fieldName) {
        try {
            return (T)this.reflector.get((Object)this, fieldName);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean hasSyntheticTerminalRule() {
        Functions.Function1 _function = it -> this._syntheticTerminalDetector.isSyntheticTerminalRule(it);
        return IterableExtensions.exists((Iterable)GrammarUtil.allTerminalRules((Grammar)this.getGrammar()), (Functions.Function1)_function);
    }

    private ContentAssistGrammarNaming getContentAssistNaming() {
        return (ContentAssistGrammarNaming)this.reflectiveGet("contentAssistNaming");
    }

    private FileAccessFactory getFileFactory() {
        return (FileAccessFactory)this.reflectiveGet("fileFactory");
    }

    private boolean isPartialParsing() {
        return (Boolean)this.reflectiveGet("partialParsing");
    }

    public JavaFileAccess generateContentAssistParser() {
        GeneratedJavaFileAccess _xblockexpression = null;
        final ContentAssistGrammarNaming naming = this.getContentAssistNaming();
        GeneratedJavaFileAccess file = this.getFileFactory().createGeneratedJavaFile(naming.getParserClass(this.getGrammar()));
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                String _simpleName = naming.getParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar()).getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)" extends ");
                TypeReference _parserSuperClass = naming.getParserSuperClass(N4JSAntlrGeneratorFragment2.this.getGrammar(), N4JSAntlrGeneratorFragment2.this.isPartialParsing());
                _builder.append((Object)_parserSuperClass);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                StringConcatenationClient _initNameMappings = N4JSAntlrGeneratorFragment2.this.initNameMappings(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_initNameMappings, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                TypeReference _grammarAccess = N4JSAntlrGeneratorFragment2.this.grammarUtil.getGrammarAccess(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_grammarAccess, "\t");
                _builder.append((Object)" grammarAccess;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"protected ");
                TypeReference _internalParserClass = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_internalParserClass, "\t");
                _builder.append((Object)" createParser() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                TypeReference _internalParserClass_1 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_internalParserClass_1, "\t\t");
                _builder.append((Object)" result = new ");
                TypeReference _internalParserClass_2 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_internalParserClass_2, "\t\t");
                _builder.append((Object)"(null);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"result.setGrammarAccess(grammarAccess);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return result;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                boolean _hasSyntheticTerminalRule = N4JSAntlrGeneratorFragment2.this.hasSyntheticTerminalRule();
                if (_hasSyntheticTerminalRule) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"protected ");
                    _builder.append(TokenSource.class, "\t");
                    _builder.append((Object)" createLexer(");
                    _builder.append(CharStream.class, "\t");
                    _builder.append((Object)" stream) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return new ");
                    TypeReference _tokenSourceClass = naming.getTokenSourceClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
                    _builder.append((Object)_tokenSourceClass, "\t\t");
                    _builder.append((Object)"(super.createLexer(stream));");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"protected String getRuleName(");
                _builder.append(AbstractElement.class, "\t");
                _builder.append((Object)" element) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return nameMappings.getRuleName(element);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"protected ");
                _builder.append(Collection.class, "\t");
                _builder.append((Object)"<");
                TypeReference _typeRef = TypeReference.typeRef((String)"org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElement", (TypeReference[])new TypeReference[0]);
                _builder.append((Object)_typeRef, "\t");
                _builder.append((Object)"> getFollowElements(");
                TypeReference _internalParserSuperClass = naming.getInternalParserSuperClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_internalParserSuperClass, "\t");
                _builder.append((Object)" parser) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"try {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                TypeReference _internalParserClass_3 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_internalParserClass_3, "\t\t\t");
                _builder.append((Object)" typedParser = (");
                TypeReference _internalParserClass_4 = naming.getInternalParserClass(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_internalParserClass_4, "\t\t\t");
                _builder.append((Object)") parser;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"typedParser.");
                String _entryRuleName = N4JSAntlrGeneratorFragment2.this.grammarUtil.entryRuleName((ParserRule)AntlrGrammarGenUtil.getOriginalElement((EObject)((ParserRule)IterableExtensions.head((Iterable)GrammarUtil.allParserRules((Grammar)N4JSAntlrGeneratorFragment2.this.getGrammar())))));
                _builder.append((Object)_entryRuleName, "\t\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return typedParser.getFollowElements();");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"} catch(");
                _builder.append(RecognitionException.class, "\t\t");
                _builder.append((Object)" ex) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"throw new ");
                _builder.append(RuntimeException.class, "\t\t\t");
                _builder.append((Object)"(ex);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"protected String[] getInitialHiddenTokens() {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return new String[] { ");
                List _initialHiddenTokens = N4JSAntlrGeneratorFragment2.this.grammarUtil.initialHiddenTokens(N4JSAntlrGeneratorFragment2.this.getGrammar());
                boolean _hasElements = false;
                for (String hidden : _initialHiddenTokens) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    _builder.append((Object)"\"");
                    _builder.append((Object)hidden, "\t\t");
                    _builder.append((Object)"\"");
                }
                _builder.append((Object)" };");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                TypeReference _grammarAccess_1 = N4JSAntlrGeneratorFragment2.this.grammarUtil.getGrammarAccess(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_grammarAccess_1, "\t");
                _builder.append((Object)" getGrammarAccess() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return this.grammarAccess;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public void setGrammarAccess(");
                TypeReference _grammarAccess_2 = N4JSAntlrGeneratorFragment2.this.grammarUtil.getGrammarAccess(N4JSAntlrGeneratorFragment2.this.getGrammar());
                _builder.append((Object)_grammarAccess_2, "\t");
                _builder.append((Object)" grammarAccess) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.grammarAccess = grammarAccess;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public NameMappings getNameMappings() {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return nameMappings;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public void setNameMappings(NameMappings nameMappings) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.nameMappings = nameMappings;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        file.setContent(_client);
        _xblockexpression = file;
        return _xblockexpression;
    }
}

