/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.MemberFactory;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;

abstract class FieldFactory
implements MemberFactory {
    final ComposedMemberInfo cma;

    FieldFactory(ComposedMemberInfo cma) {
        this.cma = cma;
    }

    abstract MemberAccessModifier getAccessability();

    abstract boolean isFinal();

    abstract TypeRef getReturnTypeRef();

    @Override
    public boolean isValid() {
        return true;
    }

    public TField create(String name) {
        TField field = TypesFactory.eINSTANCE.createTField();
        field.setComposed(true);
        TypeRef typeRef = this.getReturnTypeRef();
        TypeUtils.setMemberTypeRef((TMember)field, (TypeRef)typeRef);
        field.setName(name);
        field.setDeclaredFinal(this.isFinal());
        field.setDeclaredMemberAccessModifier(this.getAccessability());
        return field;
    }

    static class IntersectionFieldFactory
    extends FieldFactory {
        IntersectionFieldFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMax();
        }

        @Override
        boolean isFinal() {
            return this.cma.onlyReadOnlyFields();
        }

        @Override
        TypeRef getReturnTypeRef() {
            List<TypeRef> typeRefs = this.cma.getTypeRefsOfMemberType(MemberType.FIELD, MemberType.GETTER, MemberType.SETTER);
            TypeRef typeRef = typeRefs.get(0);
            return typeRef;
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }
    }

    static class UnionFieldFactory
    extends FieldFactory {
        UnionFieldFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMin();
        }

        @Override
        boolean isFinal() {
            return this.cma.hasReadOnlyField();
        }

        @Override
        TypeRef getReturnTypeRef() {
            List<TypeRef> typeRefs = this.cma.getTypeRefsOfMemberType(MemberType.FIELD);
            TypeRef typeRef = typeRefs.get(0);
            return typeRef;
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }
    }
}

