/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.util.PropertiesUtil;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class BuildInputContext
extends InputContext {
    public static final String CONTEXT_ID = "build-context";
    private HashMap<IDocumentKey, TextEdit> fOperationTable = new HashMap();

    public BuildInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    protected Charset getDefaultCharset() {
        return StandardCharsets.ISO_8859_1;
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        BuildModel model = null;
        if (input instanceof IStorageEditorInput) {
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            model = new BuildModel(document, isReconciling);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                model.setUnderlyingResource((IResource)file);
                model.setCharset(Charset.forName(file.getCharset()));
            } else {
                model.setCharset(this.getDefaultCharset());
            }
            model.load();
        } else if (input instanceof IURIEditorInput) {
            File file = new File(((IURIEditorInput)input).getURI());
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            model = new BuildModel(document, isReconciling);
            model.setInstallLocation(file.getParent());
            model.setCharset(this.getDefaultCharset());
        }
        return model;
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
        Object[] objects;
        Object[] objectArray = objects = event.getChangedObjects();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IDocumentKey key = (IDocumentKey)object;
            TextEdit op = this.fOperationTable.get(key);
            if (op != null) {
                this.fOperationTable.remove(key);
                ops.remove(op);
            }
            switch (event.getChangeType()) {
                case 2: {
                    this.deleteKey(key, ops);
                    break;
                }
                case 1: {
                    this.insertKey(key, ops);
                    break;
                }
                case 3: {
                    this.modifyKey(key, ops);
                }
            }
            ++n2;
        }
    }

    private void insertKey(IDocumentKey key, ArrayList<TextEdit> ops) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
        InsertEdit op = new InsertEdit(PropertiesUtil.getInsertOffset((IDocument)doc), key.write());
        this.fOperationTable.put(key, (TextEdit)op);
        ops.add((TextEdit)op);
    }

    private void deleteKey(IDocumentKey key, ArrayList<TextEdit> ops) {
        if (key.getOffset() >= 0) {
            DeleteEdit op = new DeleteEdit(key.getOffset(), key.getLength());
            this.fOperationTable.put(key, (TextEdit)op);
            ops.add((TextEdit)op);
        }
    }

    private void modifyKey(IDocumentKey key, ArrayList<TextEdit> ops) {
        if (key.getOffset() == -1) {
            this.insertKey(key, ops);
        } else {
            ReplaceEdit op = new ReplaceEdit(key.getOffset(), key.getLength(), key.write());
            this.fOperationTable.put(key, (TextEdit)op);
            ops.add((TextEdit)op);
        }
    }

    @Override
    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        AbstractEditingModel model = (AbstractEditingModel)this.getModel();
        model.reconciled(model.getDocument());
    }

    @Override
    protected String getPartitionName() {
        return "___build_partition";
    }
}

