/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import org.eclipse.n4js.cli.N4jscExitCode;

public class N4jscException
extends Exception {
    private final N4jscExitCode exitCode;

    public int getExitCode() {
        return this.exitCode.getExitCodeValue();
    }

    public N4jscException(N4jscExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public N4jscException(N4jscExitCode exitCode, String string) {
        super(string);
        this.exitCode = exitCode;
    }

    public N4jscException(N4jscExitCode exitCode, Throwable cause) {
        super(cause);
        this.exitCode = exitCode;
    }

    public N4jscException(N4jscExitCode exitCode, String message, Throwable cause) {
        super(message, cause);
        this.exitCode = exitCode;
    }

    public N4jscException(int code) {
        this.exitCode = N4jscException.lookupExitCodeForInt(code);
    }

    public N4jscException(int code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.exitCode = N4jscException.lookupExitCodeForInt(code);
    }

    public N4jscException(int code, String string) {
        super(string);
        this.exitCode = N4jscException.lookupExitCodeForInt(code);
    }

    public N4jscException(int code, String message, Throwable cause) {
        super(message, cause);
        this.exitCode = N4jscException.lookupExitCodeForInt(code);
    }

    public N4jscException(int code, Throwable cause) {
        super(cause);
        this.exitCode = N4jscException.lookupExitCodeForInt(code);
    }

    public boolean hasMessage() {
        return this.getMessage() != null && this.getMessage().length() > 0;
    }

    private static final N4jscExitCode lookupExitCodeForInt(int code) {
        N4jscExitCode exitCode = N4jscExitCode.fromInt(code);
        if (exitCode == null) {
            throw new RuntimeException("Unrecognized compiler exit code " + code);
        }
        return exitCode;
    }

    public String explanationOfExitCode() {
        return " (" + this.exitCode.getExplanation() + ")";
    }

    public String toUserString() {
        String s = this.exitCode.toUserString();
        if (this.hasMessage()) {
            String msg = this.getMessage();
            if (this.getCause() != null) {
                msg = this.getCause().getMessage();
            }
            s = String.valueOf(s) + ":  " + msg;
        }
        return s;
    }
}

