/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class CliResult {
    String stdOut;
    String errOut;
    int exitCode;
    Map<String, String> projects = new LinkedHashMap<String, String>();
    Exception cause;
    Multimap<String, String> errors = HashMultimap.create();
    Multimap<String, String> warnings = HashMultimap.create();
    long duration;
    TreeMap<Path, HashSet<File>> transpiledFiles = new TreeMap();

    public String getStdOut() {
        return this.stdOut;
    }

    public String getErrOut() {
        return this.errOut;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Exception getCause() {
        return this.cause;
    }

    public int getErrs() {
        return this.getErrMsgs().size();
    }

    public int getWrns() {
        return this.getWrnMsgs().size();
    }

    public Map<String, String> getProjects() {
        return this.projects;
    }

    public Collection<String> getErrMsgs() {
        return this.errors.values();
    }

    public Collection<String> getWrnMsgs() {
        return this.warnings.values();
    }

    public long getDuration() {
        return this.duration;
    }

    public int getTranspiledFilesCount() {
        return this.getTranspiledFiles().size();
    }

    public int getTranspiledFilesCount(Path dir) {
        return this.getTranspiledFiles(dir).size();
    }

    public Collection<File> getTranspiledFiles() {
        return this.getTranspiledFiles(null, false);
    }

    public Collection<File> getTranspiledFiles(Path dir) {
        return this.getTranspiledFiles(dir, false);
    }

    private Collection<File> getTranspiledFiles(Path dir, boolean exclusive) {
        if (this.transpiledFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (exclusive && dir != null) {
            Collection filesInDir = this.transpiledFiles.get(dir);
            return filesInDir;
        }
        Path start = dir == null ? this.transpiledFiles.firstKey() : dir;
        LinkedList<File> filesInDir = new LinkedList<File>();
        SortedMap<Path, HashSet<File>> tailMap = this.transpiledFiles.tailMap(start);
        for (Map.Entry next : tailMap.entrySet()) {
            Path curDir = (Path)next.getKey();
            if (dir != null && !curDir.startsWith(dir)) break;
            filesInDir.addAll((Collection)next.getValue());
        }
        return filesInDir;
    }

    public String toString() {
        List fileNameList = this.getTranspiledFiles().stream().map(f -> f.toString()).collect(Collectors.toList());
        List projectNameList = this.getProjects().entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + " at " + (String)e.getValue()).collect(Collectors.toList());
        String s = "CLI Result:\n    duration:  " + this.duration + "ms\n" + "    exit code: " + this.exitCode + "\n" + "    projects (" + this.getProjects().size() + "):\n" + "       " + String.join((CharSequence)"\n       ", projectNameList) + "\n" + "    transpiled (" + this.getTranspiledFilesCount() + "):\n" + (this.getTranspiledFilesCount() > 0 ? "       " : "") + String.join((CharSequence)"\n       ", fileNameList) + "\n" + "    warnings (" + this.getWrns() + "):\n" + (this.getWrns() > 0 ? "    " : "") + String.join((CharSequence)"\n    ", this.getWrnMsgs()) + "\n" + "    errors (" + this.getErrs() + "):\n" + (this.getErrs() > 0 ? "    " : "") + String.join((CharSequence)"\n    ", this.getErrMsgs()) + "\n" + (this.cause != null ? "    exception " + this.cause.getMessage() : "") + "    std out:\n" + (this.stdOut.isBlank() ? "" : ">>>>\n" + this.stdOut + "\n<<<<\n") + "    err out:\n" + (this.errOut.isBlank() ? "" : ">>>>\n" + this.errOut + "\n<<<<\n") + "CLI Result end\n";
        return s;
    }
}

