/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xpect.text.ICanvas;
import org.eclipse.xpect.text.IRenderContext;
import org.eclipse.xpect.text.ITextBlock;
import org.eclipse.xpect.text.TextBlock;

public abstract class Canvas
implements ICanvas {
    public static ICanvas create() {
        return new RootCanvas();
    }

    public static ICanvas create(char backgroud) {
        return new RootCanvas(Character.valueOf(backgroud));
    }

    public static ICanvas create(char backgroud, String lineSeparator) {
        return new RootCanvas(Character.valueOf(backgroud), lineSeparator);
    }

    @Override
    public IRenderContext at(int line, int column) {
        return new RenderContext(this).at(line, column);
    }

    @Override
    public void fill(Object value) {
        new RenderContext(this).fill(value);
    }

    protected abstract char getBackground();

    @Override
    public int getColumnCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getLineCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ICanvas newSubCanvas() {
        return new SubCanvas(this, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected abstract void print(int var1, int var2, int var3, int var4, List<String> var5);

    @Override
    public void print(Object value) {
        new RenderContext(this).print(value);
    }

    @Override
    public IRenderContext withBounds(int maxLines, int maxColumns) {
        return new RenderContext(this).withBounds(maxLines, maxColumns);
    }

    protected static class RenderContext
    implements IRenderContext {
        private int columns;
        private int left;
        private int lines;
        private final Canvas parent;
        private int top;

        protected RenderContext(Canvas parent) {
            this.parent = parent;
            this.lines = parent.getLineCount();
            this.columns = parent.getColumnCount();
        }

        @Override
        public IRenderContext at(int line, int column) {
            int parentLines = this.parent.getLineCount();
            int parentColumns = this.parent.getColumnCount();
            Preconditions.checkArgument((line >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((line < parentLines ? 1 : 0) != 0);
            Preconditions.checkArgument((column < parentColumns ? 1 : 0) != 0);
            this.top = line;
            this.left = column;
            this.lines = Math.min(parentLines - line, this.lines);
            this.columns = Math.min(parentColumns - column, this.columns);
            return this;
        }

        @Override
        public void fill(Object value) {
            List<String> block = TextBlock.get(value).getLines();
            char background = this.parent.getBackground();
            int blockLenght = 0;
            for (String b : block) {
                int l = b.length();
                if (l <= blockLenght) continue;
                blockLenght = l;
            }
            ArrayList padded = Lists.newArrayList();
            for (String b : block) {
                StringBuilder chunk = new StringBuilder(blockLenght);
                chunk.append(b);
                while (chunk.length() < blockLenght) {
                    chunk.append(background);
                }
                StringBuilder line = new StringBuilder(this.columns);
                while (line.length() < this.columns) {
                    line.append((CharSequence)chunk);
                }
                padded.add(line.toString());
            }
            ArrayList full = Lists.newArrayList();
            while (full.size() < this.lines) {
                full.addAll(padded);
            }
            this.parent.print(this.top, this.left, this.lines, this.columns, full);
        }

        @Override
        public ICanvas newSubCanvas() {
            return new SubCanvas(this.parent, this.top, this.left, this.columns, this.lines);
        }

        @Override
        public void print(Object value) {
            ITextBlock block = TextBlock.get(value);
            this.parent.print(this.top, this.left, this.lines, this.columns, block.getLines());
        }

        @Override
        public IRenderContext withBounds(int maxLines, int maxColumns) {
            Preconditions.checkArgument((maxLines > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((maxColumns > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((maxLines + this.top <= this.parent.getLineCount() ? 1 : 0) != 0);
            Preconditions.checkArgument((maxColumns + this.left <= this.parent.getColumnCount() ? 1 : 0) != 0);
            this.lines = maxLines;
            this.columns = maxColumns;
            return this;
        }
    }

    protected static class RootCanvas
    extends Canvas {
        private final Character background;
        private final List<StringBuilder> document = Lists.newArrayList();
        private final String lineSeparator;

        protected RootCanvas() {
            this(Character.valueOf(' '));
        }

        protected RootCanvas(Character background) {
            this(background, "\n");
        }

        protected RootCanvas(Character background, String lineSeparator) {
            this.background = background;
            this.lineSeparator = lineSeparator;
        }

        @Override
        protected char getBackground() {
            return this.background.charValue();
        }

        @Override
        protected void print(int line, int column, int maxLines, int maxColumns, List<String> strings) {
            int lineCount = Math.min(strings.size(), maxLines);
            int i = this.document.size();
            while (i < line + lineCount) {
                this.document.add(new StringBuilder());
                ++i;
            }
            i = 0;
            while (i < lineCount) {
                int end;
                int length;
                StringBuilder l = this.document.get(line + i);
                String s = strings.get(i);
                if (s.length() > maxColumns) {
                    s = s.substring(0, maxColumns);
                }
                if ((length = l.length()) < (end = column + s.length())) {
                    l.setLength(end);
                }
                int j = length;
                while (j < column) {
                    l.setCharAt(j, this.background.charValue());
                    ++j;
                }
                l.replace(column, end, s);
                ++i;
            }
        }

        public String toString() {
            return Joiner.on((String)this.lineSeparator).join(this.document);
        }
    }

    protected static class SubCanvas
    extends Canvas {
        private final int columns;
        private final int left;
        private final int lines;
        private final Canvas parent;
        private final int top;

        protected SubCanvas(Canvas parent, int top, int left, int columns, int rows) {
            this.parent = parent;
            this.top = top;
            this.left = left;
            this.columns = columns;
            this.lines = rows;
        }

        @Override
        protected char getBackground() {
            return this.parent.getBackground();
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public int getLineCount() {
            return this.lines;
        }

        @Override
        public ICanvas newSubCanvas() {
            return new SubCanvas(this.parent, this.top, this.left, this.columns, this.lines);
        }

        @Override
        protected void print(int line, int column, int maxLines, int maxColumns, List<String> strings) {
            this.parent.print(line + this.top, column + this.left, maxLines, maxColumns, strings);
        }
    }
}

