/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.outline;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.ui.JSONUIModelUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;

public class JSONOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    public void createChildren(IOutlineNode parent, EObject modelElement) {
        if (modelElement instanceof JSONDocument) {
            JSONValue content = ((JSONDocument)modelElement).getContent();
            if (JSONUIModelUtils.isContainer(content)) {
                List<? extends EObject> children = JSONUIModelUtils.getChildren(content);
                for (EObject eObject : children) {
                    this.createNode(parent, eObject);
                }
                return;
            }
            if (content != null) {
                this.createNode(parent, (EObject)content);
            }
            return;
        }
        if (modelElement instanceof NameValuePair) {
            NameValuePair pair = (NameValuePair)modelElement;
            JSONValue pairValue = pair.getValue();
            if (!JSONUIModelUtils.isContainer(pairValue)) {
                return;
            }
            for (EObject eObject : JSONUIModelUtils.getChildren(pairValue)) {
                this.createNode(parent, eObject);
            }
            return;
        }
        super.createChildren(parent, modelElement);
    }

    protected void createNode(IOutlineNode parent, EObject modelElement) {
        if (modelElement instanceof NameValuePair && !JSONUIModelUtils.isContainer(((NameValuePair)modelElement).getValue())) {
            this.createEObjectNode(parent, modelElement, (Image)this.imageDispatcher.invoke(new Object[]{modelElement}), this.textDispatcher.invoke(new Object[]{modelElement}), true);
            return;
        }
        super.createNode(parent, modelElement);
    }
}

